/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.RegisterExecutor;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.apache.spark.network.shuffle.protocol.UploadBlock;

public abstract class BlockTransferMessage
implements Encodable {
    protected abstract Type type();

    public byte[] toByteArray() {
        ByteBuf buf = Unpooled.buffer(this.encodedLength() + 1);
        buf.writeByte(this.type().id);
        this.encode(buf);
        assert (buf.writableBytes() == 0) : "Writable bytes remain: " + buf.writableBytes();
        return buf.array();
    }

    public static class Decoder {
        public static BlockTransferMessage fromByteArray(byte[] msg) {
            ByteBuf buf = Unpooled.wrappedBuffer(msg);
            byte type = buf.readByte();
            switch (type) {
                case 0: {
                    return OpenBlocks.decode(buf);
                }
                case 1: {
                    return UploadBlock.decode(buf);
                }
                case 2: {
                    return RegisterExecutor.decode(buf);
                }
                case 3: {
                    return StreamHandle.decode(buf);
                }
            }
            throw new IllegalArgumentException("Unknown message type: " + type);
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type OPEN_BLOCKS = new Type(0);
        public static final /* enum */ Type UPLOAD_BLOCK = new Type(1);
        public static final /* enum */ Type REGISTER_EXECUTOR = new Type(2);
        public static final /* enum */ Type STREAM_HANDLE = new Type(3);
        private final byte id;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int id) {
            assert (id < 128) : "Cannot have more than 128 message types";
            this.id = (byte)id;
        }

        public byte id() {
            return this.id;
        }

        static {
            $VALUES = new Type[]{OPEN_BLOCKS, UPLOAD_BLOCK, REGISTER_EXECUTOR, STREAM_HANDLE};
        }
    }
}

