/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.sasl.SaslClientBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.shuffle.ShuffleClient;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.shuffle.protocol.RegisterExecutor;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalShuffleClient
extends ShuffleClient {
    private final Logger logger = LoggerFactory.getLogger(ExternalShuffleClient.class);
    private final TransportConf conf;
    private final boolean saslEnabled;
    private final SecretKeyHolder secretKeyHolder;
    private TransportClientFactory clientFactory;
    private String appId;

    public ExternalShuffleClient(TransportConf conf, SecretKeyHolder secretKeyHolder, boolean saslEnabled) {
        this.conf = conf;
        this.secretKeyHolder = secretKeyHolder;
        this.saslEnabled = saslEnabled;
    }

    @Override
    public void init(String appId) {
        this.appId = appId;
        TransportContext context = new TransportContext(this.conf, new NoOpRpcHandler());
        ArrayList bootstraps = Lists.newArrayList();
        if (this.saslEnabled) {
            bootstraps.add(new SaslClientBootstrap(this.conf, appId, this.secretKeyHolder));
        }
        this.clientFactory = context.createClientFactory(bootstraps);
    }

    @Override
    public void fetchBlocks(final String host, final int port, final String execId, String[] blockIds, BlockFetchingListener listener) {
        assert (this.appId != null) : "Called before init()";
        this.logger.debug("External shuffle fetch from {}:{} (executor id {})", new Object[]{host, port, execId});
        try {
            RetryingBlockFetcher.BlockFetchStarter blockFetchStarter = new RetryingBlockFetcher.BlockFetchStarter(){

                @Override
                public void createAndStart(String[] blockIds, BlockFetchingListener listener) throws IOException {
                    TransportClient client = ExternalShuffleClient.this.clientFactory.createClient(host, port);
                    new OneForOneBlockFetcher(client, ExternalShuffleClient.this.appId, execId, blockIds, listener).start();
                }
            };
            int maxRetries = this.conf.maxIORetries();
            if (maxRetries > 0) {
                new RetryingBlockFetcher(this.conf, blockFetchStarter, blockIds, listener).start();
            } else {
                blockFetchStarter.createAndStart(blockIds, listener);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while beginning fetchBlocks", (Throwable)e);
            for (String blockId : blockIds) {
                listener.onBlockFetchFailure(blockId, e);
            }
        }
    }

    public void registerWithShuffleServer(String host, int port, String execId, ExecutorShuffleInfo executorInfo) throws IOException {
        assert (this.appId != null) : "Called before init()";
        TransportClient client = this.clientFactory.createClient(host, port);
        byte[] registerMessage = new RegisterExecutor(this.appId, execId, executorInfo).toByteArray();
        client.sendRpcSync(registerMessage, 5000L);
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }
}

