/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.shuffle.ExternalShuffleBlockManager;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.RegisterExecutor;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalShuffleBlockHandler
extends RpcHandler {
    private final Logger logger = LoggerFactory.getLogger(ExternalShuffleBlockHandler.class);
    private final ExternalShuffleBlockManager blockManager;
    private final OneForOneStreamManager streamManager;

    public ExternalShuffleBlockHandler(TransportConf conf) {
        this(new OneForOneStreamManager(), new ExternalShuffleBlockManager(conf));
    }

    @VisibleForTesting
    ExternalShuffleBlockHandler(OneForOneStreamManager streamManager, ExternalShuffleBlockManager blockManager) {
        this.streamManager = streamManager;
        this.blockManager = blockManager;
    }

    @Override
    public void receive(TransportClient client, byte[] message, RpcResponseCallback callback) {
        BlockTransferMessage msgObj = BlockTransferMessage.Decoder.fromByteArray(message);
        if (msgObj instanceof OpenBlocks) {
            OpenBlocks msg = (OpenBlocks)msgObj;
            ArrayList blocks = Lists.newArrayList();
            for (String blockId : msg.blockIds) {
                blocks.add(this.blockManager.getBlockData(msg.appId, msg.execId, blockId));
            }
            long streamId = this.streamManager.registerStream(blocks.iterator());
            this.logger.trace("Registered streamId {} with {} buffers", (Object)streamId, (Object)msg.blockIds.length);
            callback.onSuccess(new StreamHandle(streamId, msg.blockIds.length).toByteArray());
        } else if (msgObj instanceof RegisterExecutor) {
            RegisterExecutor msg = (RegisterExecutor)msgObj;
            this.blockManager.registerExecutor(msg.appId, msg.execId, msg.executorInfo);
            callback.onSuccess(new byte[0]);
        } else {
            throw new UnsupportedOperationException("Unexpected message: " + msgObj);
        }
    }

    @Override
    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    public void applicationRemoved(String appId, boolean cleanupLocalDirs) {
        this.blockManager.applicationRemoved(appId, cleanupLocalDirs);
    }
}

