/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.util.IOMode;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportServer
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(TransportServer.class);
    private final TransportContext context;
    private final TransportConf conf;
    private ServerBootstrap bootstrap;
    private ChannelFuture channelFuture;
    private int port = -1;

    public TransportServer(TransportContext context, int portToBind) {
        this.context = context;
        this.conf = context.getConf();
        this.init(portToBind);
    }

    public int getPort() {
        if (this.port == -1) {
            throw new IllegalStateException("Server not initialized");
        }
        return this.port;
    }

    private void init(int portToBind) {
        EventLoopGroup bossGroup;
        IOMode ioMode = IOMode.valueOf(this.conf.ioMode());
        EventLoopGroup workerGroup = bossGroup = NettyUtils.createEventLoop(ioMode, this.conf.serverThreads(), "shuffle-server");
        PooledByteBufAllocator allocator = NettyUtils.createPooledByteBufAllocator(this.conf.preferDirectBufs(), true, this.conf.serverThreads());
        this.bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(bossGroup, workerGroup).channel(NettyUtils.getServerChannelClass(ioMode))).option(ChannelOption.ALLOCATOR, allocator)).childOption(ChannelOption.ALLOCATOR, allocator);
        if (this.conf.backLog() > 0) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, this.conf.backLog());
        }
        if (this.conf.receiveBuf() > 0) {
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, this.conf.receiveBuf());
        }
        if (this.conf.sendBuf() > 0) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, this.conf.sendBuf());
        }
        this.bootstrap.childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                TransportServer.this.context.initializePipeline(ch);
            }
        });
        this.channelFuture = this.bootstrap.bind(new InetSocketAddress(portToBind));
        this.channelFuture.syncUninterruptibly();
        this.port = ((InetSocketAddress)this.channelFuture.channel().localAddress()).getPort();
        this.logger.debug("Shuffle server started on port :" + this.port);
    }

    @Override
    public void close() {
        if (this.channelFuture != null) {
            this.channelFuture.channel().close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
            this.channelFuture = null;
        }
        if (this.bootstrap != null && this.bootstrap.group() != null) {
            this.bootstrap.group().shutdownGracefully();
        }
        if (this.bootstrap != null && this.bootstrap.childGroup() != null) {
            this.bootstrap.childGroup().shutdownGracefully();
        }
        this.bootstrap = null;
    }
}

