/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportResponseHandler;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.RequestMessage;
import org.apache.spark.network.protocol.ResponseMessage;
import org.apache.spark.network.server.TransportRequestHandler;
import org.apache.spark.network.util.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportChannelHandler
extends SimpleChannelInboundHandler<Message> {
    private final Logger logger = LoggerFactory.getLogger(TransportChannelHandler.class);
    private final TransportClient client;
    private final TransportResponseHandler responseHandler;
    private final TransportRequestHandler requestHandler;

    public TransportChannelHandler(TransportClient client, TransportResponseHandler responseHandler, TransportRequestHandler requestHandler) {
        this.client = client;
        this.responseHandler = responseHandler;
        this.requestHandler = requestHandler;
    }

    public TransportClient getClient() {
        return this.client;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.warn("Exception in connection from " + NettyUtils.getRemoteAddress(ctx.channel()), cause);
        this.requestHandler.exceptionCaught(cause);
        this.responseHandler.exceptionCaught(cause);
        ctx.close();
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        try {
            this.requestHandler.channelUnregistered();
        }
        catch (RuntimeException e) {
            this.logger.error("Exception from request handler while unregistering channel", (Throwable)e);
        }
        try {
            this.responseHandler.channelUnregistered();
        }
        catch (RuntimeException e) {
            this.logger.error("Exception from response handler while unregistering channel", (Throwable)e);
        }
        super.channelUnregistered(ctx);
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, Message request) {
        if (request instanceof RequestMessage) {
            this.requestHandler.handle((RequestMessage)request);
        } else {
            this.responseHandler.handle((ResponseMessage)request);
        }
    }
}

