/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSaslServer {
    private final Logger logger = LoggerFactory.getLogger(SparkSaslServer.class);
    static final String DEFAULT_REALM = "default";
    static final String DIGEST = "DIGEST-MD5";
    static final Map<String, String> SASL_PROPS = ImmutableMap.builder().put((Object)"javax.security.sasl.qop", (Object)"auth").put((Object)"javax.security.sasl.server.authentication", (Object)"true").build();
    private final String secretKeyId;
    private final SecretKeyHolder secretKeyHolder;
    private SaslServer saslServer;

    public SparkSaslServer(String secretKeyId, SecretKeyHolder secretKeyHolder) {
        this.secretKeyId = secretKeyId;
        this.secretKeyHolder = secretKeyHolder;
        try {
            this.saslServer = Sasl.createSaslServer(DIGEST, null, DEFAULT_REALM, SASL_PROPS, new DigestCallbackHandler());
        }
        catch (SaslException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public synchronized boolean isComplete() {
        return this.saslServer != null && this.saslServer.isComplete();
    }

    public synchronized byte[] response(byte[] token) {
        try {
            return this.saslServer != null ? this.saslServer.evaluateResponse(token) : new byte[]{};
        }
        catch (SaslException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        if (this.saslServer != null) {
            try {
                this.saslServer.dispose();
            }
            catch (SaslException saslException) {
            }
            finally {
                this.saslServer = null;
            }
        }
    }

    public static String encodeIdentifier(String identifier) {
        Preconditions.checkNotNull((Object)identifier, (Object)"User cannot be null if SASL is enabled");
        return Base64.encode(Unpooled.wrappedBuffer(identifier.getBytes(Charsets.UTF_8))).toString(Charsets.UTF_8);
    }

    public static char[] encodePassword(String password) {
        Preconditions.checkNotNull((Object)password, (Object)"Password cannot be null if SASL is enabled");
        return Base64.encode(Unpooled.wrappedBuffer(password.getBytes(Charsets.UTF_8))).toString(Charsets.UTF_8).toCharArray();
    }

    private class DigestCallbackHandler
    implements CallbackHandler {
        private DigestCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    SparkSaslServer.this.logger.trace("SASL server callback: setting username");
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(SparkSaslServer.encodeIdentifier(SparkSaslServer.this.secretKeyHolder.getSaslUser(SparkSaslServer.this.secretKeyId)));
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    SparkSaslServer.this.logger.trace("SASL server callback: setting password");
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(SparkSaslServer.encodePassword(SparkSaslServer.this.secretKeyHolder.getSecretKey(SparkSaslServer.this.secretKeyId)));
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    SparkSaslServer.this.logger.trace("SASL server callback: setting realm");
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    AuthorizeCallback ac = (AuthorizeCallback)callback;
                    String authId = ac.getAuthenticationID();
                    String authzId = ac.getAuthorizationID();
                    ac.setAuthorized(authId.equals(authzId));
                    if (ac.isAuthorized()) {
                        ac.setAuthorizedID(authzId);
                    }
                    SparkSaslServer.this.logger.debug("SASL Authorization complete, authorized set to {}", (Object)ac.isAuthorized());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
            }
        }
    }
}

