/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import com.google.common.base.Throwables;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.sasl.SparkSaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSaslClient {
    private final Logger logger = LoggerFactory.getLogger(SparkSaslClient.class);
    private final String secretKeyId;
    private final SecretKeyHolder secretKeyHolder;
    private SaslClient saslClient;

    public SparkSaslClient(String secretKeyId, SecretKeyHolder secretKeyHolder) {
        this.secretKeyId = secretKeyId;
        this.secretKeyHolder = secretKeyHolder;
        try {
            this.saslClient = Sasl.createSaslClient(new String[]{"DIGEST-MD5"}, null, null, "default", SparkSaslServer.SASL_PROPS, new ClientCallbackHandler());
        }
        catch (SaslException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public synchronized byte[] firstToken() {
        if (this.saslClient != null && this.saslClient.hasInitialResponse()) {
            try {
                return this.saslClient.evaluateChallenge(new byte[0]);
            }
            catch (SaslException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return new byte[0];
    }

    public synchronized boolean isComplete() {
        return this.saslClient != null && this.saslClient.isComplete();
    }

    public synchronized byte[] response(byte[] token) {
        try {
            return this.saslClient != null ? this.saslClient.evaluateChallenge(token) : new byte[]{};
        }
        catch (SaslException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        if (this.saslClient != null) {
            try {
                this.saslClient.dispose();
            }
            catch (SaslException saslException) {
            }
            finally {
                this.saslClient = null;
            }
        }
    }

    private class ClientCallbackHandler
    implements CallbackHandler {
        private ClientCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    SparkSaslClient.this.logger.trace("SASL client callback: setting username");
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(SparkSaslServer.encodeIdentifier(SparkSaslClient.this.secretKeyHolder.getSaslUser(SparkSaslClient.this.secretKeyId)));
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    SparkSaslClient.this.logger.trace("SASL client callback: setting password");
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(SparkSaslServer.encodePassword(SparkSaslClient.this.secretKeyHolder.getSecretKey(SparkSaslClient.this.secretKeyId)));
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    SparkSaslClient.this.logger.trace("SASL client callback: setting realm");
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof RealmChoiceCallback) continue;
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
            }
        }
    }
}

