/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import java.util.concurrent.ConcurrentMap;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.sasl.SaslMessage;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.sasl.SparkSaslServer;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslRpcHandler
extends RpcHandler {
    private final Logger logger = LoggerFactory.getLogger(SaslRpcHandler.class);
    private final RpcHandler delegate;
    private final SecretKeyHolder secretKeyHolder;
    private final ConcurrentMap<TransportClient, SparkSaslServer> channelAuthenticationMap;

    public SaslRpcHandler(RpcHandler delegate, SecretKeyHolder secretKeyHolder) {
        this.delegate = delegate;
        this.secretKeyHolder = secretKeyHolder;
        this.channelAuthenticationMap = Maps.newConcurrentMap();
    }

    @Override
    public void receive(TransportClient client, byte[] message, RpcResponseCallback callback) {
        SparkSaslServer saslServer = (SparkSaslServer)this.channelAuthenticationMap.get(client);
        if (saslServer != null && saslServer.isComplete()) {
            this.delegate.receive(client, message, callback);
            return;
        }
        SaslMessage saslMessage = SaslMessage.decode(Unpooled.wrappedBuffer(message));
        if (saslServer == null) {
            saslServer = new SparkSaslServer(saslMessage.appId, this.secretKeyHolder);
            this.channelAuthenticationMap.put(client, saslServer);
        }
        byte[] response = saslServer.response(saslMessage.payload);
        if (saslServer.isComplete()) {
            this.logger.debug("SASL authentication successful for channel {}", (Object)client);
        }
        callback.onSuccess(response);
    }

    @Override
    public StreamManager getStreamManager() {
        return this.delegate.getStreamManager();
    }

    @Override
    public void connectionTerminated(TransportClient client) {
        SparkSaslServer saslServer = (SparkSaslServer)this.channelAuthenticationMap.remove(client);
        if (saslServer != null) {
            saslServer.dispose();
        }
    }
}

