/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.sasl.SaslMessage;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.sasl.SparkSaslClient;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslClientBootstrap
implements TransportClientBootstrap {
    private final Logger logger = LoggerFactory.getLogger(SaslClientBootstrap.class);
    private final TransportConf conf;
    private final String appId;
    private final SecretKeyHolder secretKeyHolder;

    public SaslClientBootstrap(TransportConf conf, String appId, SecretKeyHolder secretKeyHolder) {
        this.conf = conf;
        this.appId = appId;
        this.secretKeyHolder = secretKeyHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doBootstrap(TransportClient client) {
        SparkSaslClient saslClient = new SparkSaslClient(this.appId, this.secretKeyHolder);
        try {
            byte[] payload = saslClient.firstToken();
            while (!saslClient.isComplete()) {
                SaslMessage msg = new SaslMessage(this.appId, payload);
                ByteBuf buf = Unpooled.buffer(msg.encodedLength());
                msg.encode(buf);
                byte[] response = client.sendRpcSync(buf.array(), this.conf.saslRTTimeoutMs());
                payload = saslClient.response(response);
            }
        }
        finally {
            try {
                saslClient.dispose();
            }
            catch (RuntimeException e) {
                this.logger.error("Error while disposing SASL client", (Throwable)e);
            }
        }
    }
}

