/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NettyManagedBuffer;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.ResponseMessage;
import org.apache.spark.network.protocol.StreamChunkId;

public final class ChunkFetchSuccess
implements ResponseMessage {
    public final StreamChunkId streamChunkId;
    public final ManagedBuffer buffer;

    public ChunkFetchSuccess(StreamChunkId streamChunkId, ManagedBuffer buffer) {
        this.streamChunkId = streamChunkId;
        this.buffer = buffer;
    }

    @Override
    public Message.Type type() {
        return Message.Type.ChunkFetchSuccess;
    }

    @Override
    public int encodedLength() {
        return this.streamChunkId.encodedLength();
    }

    @Override
    public void encode(ByteBuf buf) {
        this.streamChunkId.encode(buf);
    }

    public static ChunkFetchSuccess decode(ByteBuf buf) {
        StreamChunkId streamChunkId = StreamChunkId.decode(buf);
        buf.retain();
        NettyManagedBuffer managedBuf = new NettyManagedBuffer(buf.duplicate());
        return new ChunkFetchSuccess(streamChunkId, managedBuf);
    }

    public boolean equals(Object other) {
        if (other instanceof ChunkFetchSuccess) {
            ChunkFetchSuccess o = (ChunkFetchSuccess)other;
            return this.streamChunkId.equals(o.streamChunkId) && this.buffer.equals(o.buffer);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("streamChunkId", (Object)this.streamChunkId).add("buffer", (Object)this.buffer).toString();
    }
}

