/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.buffer;

import com.google.common.base.Objects;
import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.spark.network.util.JavaUtils;

public final class LazyFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private final File file;
    private final long position;
    private final long count;
    private FileChannel channel;
    private long numBytesTransferred = 0L;

    public LazyFileRegion(File file, long position, long count) {
        this.file = file;
        this.position = position;
        this.count = count;
    }

    @Override
    protected void deallocate() {
        JavaUtils.closeQuietly(this.channel);
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long transfered() {
        return this.numBytesTransferred;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public long transferTo(WritableByteChannel target, long position) throws IOException {
        long count;
        if (this.channel == null) {
            this.channel = new FileInputStream(this.file).getChannel();
        }
        if ((count = this.count - position) < 0L || position < 0L) {
            throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (count - 1L) + ')');
        }
        if (count == 0L) {
            return 0L;
        }
        long written = this.channel.transferTo(this.position + position, count, target);
        if (written > 0L) {
            this.numBytesTransferred += written;
        }
        return written;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("file", (Object)this.file).add("position", this.position).add("count", this.count).toString();
    }
}

