/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import com.google.common.collect.Lists;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import java.util.List;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.client.TransportResponseHandler;
import org.apache.spark.network.protocol.MessageDecoder;
import org.apache.spark.network.protocol.MessageEncoder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportChannelHandler;
import org.apache.spark.network.server.TransportRequestHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportContext {
    private final Logger logger = LoggerFactory.getLogger(TransportContext.class);
    private final TransportConf conf;
    private final RpcHandler rpcHandler;
    private final MessageEncoder encoder;
    private final MessageDecoder decoder;

    public TransportContext(TransportConf conf, RpcHandler rpcHandler) {
        this.conf = conf;
        this.rpcHandler = rpcHandler;
        this.encoder = new MessageEncoder();
        this.decoder = new MessageDecoder();
    }

    public TransportClientFactory createClientFactory(List<TransportClientBootstrap> bootstraps) {
        return new TransportClientFactory(this, bootstraps);
    }

    public TransportClientFactory createClientFactory() {
        return this.createClientFactory(Lists.newArrayList());
    }

    public TransportServer createServer(int port) {
        return new TransportServer(this, port);
    }

    public TransportServer createServer() {
        return new TransportServer(this, 0);
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel) {
        try {
            TransportChannelHandler channelHandler = this.createChannelHandler(channel);
            channel.pipeline().addLast("encoder", (ChannelHandler)this.encoder).addLast("frameDecoder", (ChannelHandler)NettyUtils.createFrameDecoder()).addLast("decoder", (ChannelHandler)this.decoder).addLast("handler", (ChannelHandler)channelHandler);
            return channelHandler;
        }
        catch (RuntimeException e) {
            this.logger.error("Error while initializing Netty pipeline", (Throwable)e);
            throw e;
        }
    }

    private TransportChannelHandler createChannelHandler(Channel channel) {
        TransportResponseHandler responseHandler = new TransportResponseHandler(channel);
        TransportClient client = new TransportClient(channel, responseHandler);
        TransportRequestHandler requestHandler = new TransportRequestHandler(channel, client, this.rpcHandler);
        return new TransportChannelHandler(client, responseHandler, requestHandler);
    }

    public TransportConf getConf() {
        return this.conf;
    }
}

