﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace processArcive
{
    static class twsValueUtill
    {

        //入力到着週形未対応
        static public SortedDictionary<string, string> getCTwsValueList()
        {
            SortedDictionary<string, string> buffValue = new SortedDictionary<string, string>();

            //現在の曜日。 1 は月曜日、7 は日曜日を表す。
            if ((int)DateTime.Now.DayOfWeek == 0)
            {
                buffValue.Add("CDAY", "7");
            }
            else
            {
                buffValue.Add("CDAY", ((int)(DateTime.Now.DayOfWeek) + 1).ToString());
            }

            // 現在の日 (月のうちの日にち、DD 形式) 
            buffValue.Add("CDD", DateTime.Now.ToString("dd"));
            // 現在の年の日番号 
            buffValue.Add("CDDD", DateTime.Now.DayOfYear.ToString("000"));
            //現在の日付 (DDMMYY 形式)
            buffValue.Add("CDDMMYY", DateTime.Now.ToString("ddMMyy"));
            //現在の時刻 (HH 形式)
            buffValue.Add("CHH", DateTime.Now.ToString("HH"));
            //現在の時と分 (HHMM 形式)
            buffValue.Add("CHHMM", DateTime.Now.ToString("HHmm"));
            //現在の時、分、秒、100 分の 1 秒 (HHMMSSXX 形式) 
            //擬似的操作
            buffValue.Add("CHHMMSSX", DateTime.Now.ToString("HHmmss") + "00");
            //現在の時と分 (HHMM 形式)
            buffValue.Add("CMM", DateTime.Now.ToString("MM"));
            //現在の月 (MMYY 形式) 
            buffValue.Add("CMMYY", DateTime.Now.ToString("MMyy"));
            //現在の日付 (YYYYMMDD 形式)
            buffValue.Add("CYMD", DateTime.Now.ToString("yyyyMMdd"));
            //現在の年 (YY 形式)
            buffValue.Add("CYY", DateTime.Now.ToString("yy"));
            //現在の年間通算日 (YYDDD 形式)
            buffValue.Add("CYYDDD", DateTime.Now.ToString("yy") + DateTime.Now.DayOfYear.ToString("000"));
            //現在の月 (YYMM 形式) 
            buffValue.Add("CYYMM", DateTime.Now.ToString("yyMM"));
            //現在の日付 (YYMMDD 形式)
            buffValue.Add("CYYMMDD", DateTime.Now.ToString("yyMMdd"));
            //YYYY 形式の現在年 (たとえば、1997)。
            buffValue.Add("CYYYY", DateTime.Now.ToString("yyyy"));
            //現在の月 (YYYYMM 形式)
            buffValue.Add("CYYYYMM", DateTime.Now.ToString("yyyyMM"));

            return buffValue;
        }

        //入力到着週形未対応
        static public SortedDictionary<string, string> getOTwsValueList(string jobname, TEKIYOUGYOUMU tekiyougyoumu)
        {

            SortedDictionary<string, string> buffValue = new SortedDictionary<string, string>();

            //アプリケーションID18桁
            buffValue.Add("OADID", tekiyougyoumu.applID.ToString("0000000000000000"));
            //オカレンス所有者-16桁
            //buffValue.Add("OADOWNER","       LOCALUSER");
            //権限グループ-8桁
            //buffValue.Add("OAUGROUP", "");
            // カレンダー名-16桁
            //buffValue.Add("OCALID", "");
            // オカレンスの入力到着曜日 (1 ～ 7); 1 は 月曜日、7 は日曜日。1桁
            if ((int)tekiyougyoumu.timeValue.DayOfWeek == 0)
            {
                buffValue.Add("ODAY", "7");
            }
            else
            {
                buffValue.Add("ODAY", ((int)(tekiyougyoumu.timeValue.DayOfWeek) + 1).ToString());
            }
            //オカレンスの入力到着日 (月の中の日にち。DD 形式)。
            buffValue.Add("ODD", tekiyougyoumu.timeValue.ToString("dd"));
            //オカレンスの入力到着日の年間通算日 (DDD 形式)。
            buffValue.Add("ODDD", tekiyougyoumu.timeValue.DayOfYear.ToString("000"));
            //オカレンスの入力到着日 (DDMMYY 形式)。
            buffValue.Add("ODMY1", tekiyougyoumu.timeValue.ToString("ddMMyy"));
            //オカレンスの入力到着日 (DD/MM/YY 形式)。
            buffValue.Add("ODMY2", tekiyougyoumu.timeValue.ToString("dd/MM/yy"));
            //オカレンスの入力到着時 (HH 形式)。
            buffValue.Add("OHH", tekiyougyoumu.timeValue.ToString("HH"));
            //オカレンスの入力到着の時および分 (HHMM 形式)。
            buffValue.Add("OHHMM", tekiyougyoumu.timeValue.ToString("HHmm"));
            //オカレンスの入力到着月 (MM 形式)。
            buffValue.Add("OMM", tekiyougyoumu.timeValue.ToString("MM"));
            //オカレンスの入力到着の月および年 (MMYY 形式)。
            buffValue.Add("OMMYY", tekiyougyoumu.timeValue.ToString("MMyy"));
            //オカレンスの入力到着日 (YYYYMMDD 形式)。
            buffValue.Add("OYMD", tekiyougyoumu.timeValue.ToString("yyyyMMdd"));
            //オカレンスの入力到着月 (YYYYMM 形式)。
            buffValue.Add("OYM", tekiyougyoumu.timeValue.ToString("yyyyMM"));
            //オカレンスの入力到着日 (YYMMDD 形式)。
            buffValue.Add("OYMD1", tekiyougyoumu.timeValue.ToString("yyMMdd"));
            //オカレンスの入力到着日 (YY/MM/DD 形式)。
            buffValue.Add("OYMD2", tekiyougyoumu.timeValue.ToString("yy/MM/dd"));
            //オカレンスの入力到着日 (YYYY/MM/DD 形式)。
            buffValue.Add("OYMD3", tekiyougyoumu.timeValue.ToString("yyyy/MM/dd"));
            //オカレンスの入力到着年 (YY 形式)。
            buffValue.Add("OYY", tekiyougyoumu.timeValue.ToString("yy"));
            //オカレンスの入力到着日の年間通算日 (YYDDD 形式)。 
            buffValue.Add("OYYDDD", tekiyougyoumu.timeValue.ToString("yy") + tekiyougyoumu.timeValue.DayOfYear.ToString("000"));
            //オカレンスの入力到着月 (YYMM 形式)。
            buffValue.Add("OYYMM", tekiyougyoumu.timeValue.ToString("yyMM"));
            //オカレンスの入力到着月 (YYMM 形式)。
            buffValue.Add("OYYYY", tekiyougyoumu.timeValue.ToString("yyyy"));

            //オカレンスの入力到着月 (YYMM 形式)。
            buffValue.Add("OJOBNAME", jobname);
            //オカレンス内の操作番号。右寄せでゼロが埋め込まれる。
            buffValue.Add("OOPNO", tekiyougyoumu.joblist[jobname].opertionNumber.ToString("000"));
            //現行操作のワークステーション ID
            buffValue.Add("OWSID", tekiyougyoumu.joblist[jobname].workstationId);

            //現在の曜日。 1 は月曜日、7 は日曜日を表す。
            if ((int)DateTime.Now.DayOfWeek == 0)
            {
                buffValue.Add("CDAY", "7");
            }
            else
            {
                buffValue.Add("CDAY", ((int)(DateTime.Now.DayOfWeek) + 1).ToString());
            }

            // 現在の日 (月のうちの日にち、DD 形式) 
            buffValue.Add("CDD", DateTime.Now.ToString("dd"));
            // 現在の年の日番号 
            buffValue.Add("CDDD", DateTime.Now.DayOfYear.ToString("000"));
            //現在の日付 (DDMMYY 形式)
            buffValue.Add("CDDMMYY", DateTime.Now.ToString("ddMMyy"));
            //現在の時刻 (HH 形式)
            buffValue.Add("CHH", DateTime.Now.ToString("HH"));
            //現在の時と分 (HHMM 形式)
            buffValue.Add("CHHMM", DateTime.Now.ToString("HHmm"));
            //現在の時、分、秒、100 分の 1 秒 (HHMMSSXX 形式) 
            //擬似的操作
            buffValue.Add("CHHMMSSX", DateTime.Now.ToString("HHmmss") + "00");
            //現在の時と分 (HHMM 形式)
            buffValue.Add("CMM", DateTime.Now.ToString("MM"));
            //現在の月 (MMYY 形式) 
            buffValue.Add("CMMYY", DateTime.Now.ToString("MMyy"));
            //現在の日付 (YYYYMMDD 形式)
            buffValue.Add("CYMD", DateTime.Now.ToString("yyyyMMdd"));
            //現在の年 (YY 形式)
            buffValue.Add("CYY", DateTime.Now.ToString("yy"));
            //現在の年間通算日 (YYDDD 形式)
            buffValue.Add("CYYDDD", DateTime.Now.ToString("yy") + DateTime.Now.DayOfYear.ToString("000"));
            //現在の月 (YYMM 形式) 
            buffValue.Add("CYYMM", DateTime.Now.ToString("yyMM"));
            //現在の日付 (YYMMDD 形式)
            buffValue.Add("CYYMMDD", DateTime.Now.ToString("yyMMdd"));
            //YYYY 形式の現在年 (たとえば、1997)。
            buffValue.Add("CYYYY", DateTime.Now.ToString("yyyy"));
            //現在の月 (YYYYMM 形式)
            buffValue.Add("CYYYYMM", DateTime.Now.ToString("yyyyMM"));

            return buffValue;
        }
    }
}
