/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡξȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: tinet_app_config.h,v 1.5 2009/12/24 06:20:39 abe Exp abe $
 */

#ifndef _TINET_APP_CONFIG_H_
#define _TINET_APP_CONFIG_H_

/*
 *  󥿡ͥåȥץȥեߥ꡼Υݡ
 *
 *    Makefile ǻꤷƤɤ
 */

/*#define SUPPORT_INET4		TCP/IP,IPv4		*/
/*#define SUPPORT_INET6		TCP/IP,IPv6		*/
/*#define SUPPORT_TCP		TCP			*/
/*#define SUPPORT_UDP		UDP			*/

/*ǡؤΥͥåȥ󥿥ե򤹤	*/
/*줫ĤǤ롣				*/

/*#define SUPPORT_PPP		PointtoPointProtocol	*/
/*#define SUPPORT_LOOP		LocalLoopBack		*/
/*#define SUPPORT_ETHER		Ethernet		*/

/*#define SUPPORT_MIB		MIB(SNMP)		*/

/*
 *  TCP/IP ˴ؤ
 */

/* TCP ˴ؤ */

/*
 *  TCPǽưץΤߥݡȤ뤳Ȥꤹ롣
 */

#ifdef UNDEF_TCP_CFG_PASSIVE_OPEN
#undef TCP_CFG_PASSIVE_OPEN
#endif

/*
 *  TCP ̿üɥХåեξʥԡǽ
 *    : Makefile ǻꤷƤ롣
 */
/*#define TCP_CFG_RWBUF_CSAVE_ONLY*/
			/* TCP ̿üμɥХåեξʥԡǽΤͭˤ롣	*/
/*#define TCP_CFG_RWBUF_CSAVE*/
			/* TCP ̿üμɥХåեξʥԡǽͭˤ롣	*/
/*#define TCP_CFG_SWBUF_CSAVE_ONLY*/
			/* TCP ̿üɥХåեξʥԡǽΤͭˤ롣	*/
/*#define TCP_CFG_SWBUF_CSAVE*/
			/* TCP ̿üɥХåեξʥԡǽͭˤ롣	*/

/*
 *  TCP ̿üμɥХåեξʥԡǽΡ
 *  ɥХåե塼κ票ȥ
 *  ˼Ȥ˴뤿ᡢä롣
 *  ޤꤷʤ¤ʤ
 */
/*#define TCP_CFG_RWBUF_CSAVE_MAX_QUEUES	2*/

/*
 *  TCP ̿üɥХåեξʥԡǽǡ
 *  ɥХåե˻ѤͥåȥХåեΥ
 */

#ifdef USE_TCP_MSS_SEG

#ifdef SUPPORT_INET4
#define TCP_CFG_SWBUF_CSAVE_MAX_SIZE	(IF_HDR_SIZE + IP4_MSS)		/* 祵 */
#endif

#ifdef SUPPORT_INET6
#define TCP_CFG_SWBUF_CSAVE_MAX_SIZE	(IF_HDR_SIZE + IPV6_MMTU)	/* 祵 */
#endif

#else	/* of #ifdef USE_TCP_MSS_SEG */

#define TCP_CFG_SWBUF_CSAVE_MAX_SIZE	IF_PDU_SIZE			/* 祵 */

#endif	/* of #ifdef USE_TCP_MSS_SEG */

#define TCP_CFG_SWBUF_CSAVE_MIN_SIZE	0				/* Ǿ */

/*
 *  TCP ΥΥ֥å󥰥뵡ǽ
 */

#ifdef UNDEF_TCP_CFG_NON_BLOCKING
#undef TCP_CFG_NON_BLOCKING
#endif

/*
 *  MAX_TCP_SND_SEG: ȥκ
 *
 *    ꤫ MSS ץǥȥꤵƤ⡢
 *    ͤǡȥ¤Ǥ롣
 */

#ifdef USE_TCP_MSS_SEG

#ifdef MAX_TCP_SND_SEG
#undef MAX_TCP_SND_SEG
#endif

#ifdef SUPPORT_INET4
#define MAX_TCP_SND_SEG			TCP_MSS
#endif

#ifdef SUPPORT_INET6
#define MAX_TCP_SND_SEG			TCP6_MSS
#endif

#endif	/* of #ifdef USE_TCP_MSS_SEG */

/*
 *  DEF_TCP_RCV_SEG: ȥε
 */

#ifdef USE_TCP_MSS_SEG

#ifdef DEF_TCP_RCV_SEG
#undef DEF_TCP_RCV_SEG
#endif

#ifdef SUPPORT_INET4
#define DEF_TCP_RCV_SEG			TCP_MSS
#endif

#ifdef SUPPORT_INET6
#define DEF_TCP_RCV_SEG			TCP6_MSS
#endif

#endif	/* of #ifdef USE_TCP_MSS_SEG */

/*
 *   Time Wait ֤ TCP ̿üʬΥǽ
 *
 *  Time Wait ֤ TCP ̿üΥȥꤹ롣
 *  ꤷʤ0 ꤹȡ
 *   Time Wait ֤ TCP ̿üʬΥ뵡ǽȹޤʤ
 */
#if defined(USE_TCP_MSS_SEG)
#define NUM_TCP_TW_CEP_ENTRY		3
#else
#define NUM_TCP_TW_CEP_ENTRY		6
#endif

/*
 *  TCP إåΥȥ졼ϵǽ
 */
//#define TCP_CFG_TRACE

/*
 *  ȥ졼оݤΥ⡼ȥۥȤ IPv4 ɥ쥹
 *  IPV4_ADDRANY ꤹȡƤΥۥȤоݤȤ롣
 */
#define TCP_CFG_TRACE_IPV4_RADDR	IPV4_ADDRANY

/*
 *  ȥ졼оݤΥ⡼ȥۥȤΥݡֹ
 *  TCP_PORTANY ꤹȡƤΥݡֹоݤˤ롣
 */
#define TCP_CFG_TRACE_RPORTNO		TCP_PORTANY
//#define TCP_CFG_TRACE_RPORTNO		UINT_C(7)

/*
 *  ȥ졼оݤΥۥȤΥݡֹ
 *  TCP_PORTANY ꤹȡƤΥݡֹоݤˤ롣
 */
#define TCP_CFG_TRACE_LPORTNO		TCP_PORTANY
//#define TCP_CFG_TRACE_LPORTNO		UINT_C(7)

/*
 *  ITRON TCP/IP APITCP γĥǽ
 */
//#define TCP_CFG_EXTENTIONS

/*
 *  TCP_CFG_URG_OFFSET: ۵ޥǡκǸΥХȤΥեå
 *
 *    -1: BSD μ۵ޥݥ󥿤ϡ۵ޥǡκǸΥХȤμΥХȤ򺹤
 *     0: RFC1122 εꡢ۵ޥݥ󥿤ϡ۵ޥǡκǸΥХȤ򺹤
 */

//#define TCP_CFG_URG_OFFSET	-1
//#define TCP_CFG_URG_OFFSET	0

/* UDP ˴ؤ */

/*
 *  UDP ΥΥ֥å󥰥뵡ǽ
 */

#ifdef UNDEF_UDP_CFG_NON_BLOCKING
#undef UDP_CFG_NON_BLOCKING
#endif

/*
 *  ITRON TCP/IP APIUDP γĥǽ
 */
//#define UDP_CFG_EXTENTIONS

/* IPv4 ˴ؤ */

#ifdef SUPPORT_INET4

#ifdef SUPPORT_PPP

#if 1
#define IPV4_ADDR_LOCAL			MAKE_IPV4_ADDR(192,168,1,21)
#else
#define IPV4_ADDR_LOCAL			MAKE_IPV4_ADDR(0,0,0,0)		/* ˳ƤƤ餦	*/
#endif

#if 1
#define IPV4_ADDR_REMOTE		MAKE_IPV4_ADDR(192,168,1,31)
#else
#define IPV4_ADDR_REMOTE		MAKE_IPV4_ADDR(0,0,0,0)		/* ˳ƤƤ餦	*/
#endif

#define NUM_STATIC_ROUTE_ENTRY		1
#define NUM_REDIRECT_ROUTE_ENTRY	0

#endif	/* of #ifdef SUPPORT_PPP */

#ifdef SUPPORT_ETHER

#ifdef DHCP_CFG

#define IPV4_ADDR_LOCAL			MAKE_IPV4_ADDR(0,0,0,0)
#define IPV4_ADDR_LOCAL_MASK		MAKE_IPV4_ADDR(0,0,0,0)
#define IPV4_ADDR_DEFAULT_GW		MAKE_IPV4_ADDR(0,0,0,0)

#else	/* of #ifdef DHCP_CFG */

#define IPV4_ADDR_LOCAL			MAKE_IPV4_ADDR(172,25,129,205)
#define IPV4_ADDR_LOCAL_MASK		MAKE_IPV4_ADDR(255,255,255,0)
#define IPV4_ADDR_DEFAULT_GW		MAKE_IPV4_ADDR(172,25,129,140)

#endif	/* of #ifdef DHCP_CFG */

#define NUM_STATIC_ROUTE_ENTRY		3
#define NUM_REDIRECT_ROUTE_ENTRY	1

#endif	/* of #ifdef SUPPORT_ETHER */

#ifdef SUPPORT_LOOP

#define NUM_STATIC_ROUTE_ENTRY		1
#define NUM_REDIRECT_ROUTE_ENTRY	0

#endif	/* of #ifdef SUPPORT_LOOP */

#endif	/* of #ifdef SUPPORT_INET4 */

/* IPv6 ˴ؤ */

#ifdef SUPPORT_INET6

#ifdef SUPPORT_PPP

#define NUM_STATIC_ROUTE_ENTRY		0
#define NUM_REDIRECT_ROUTE_ENTRY	0

#endif	/* of #ifdef SUPPORT_PPP */

#ifdef SUPPORT_LOOP

#define NUM_STATIC_ROUTE_ENTRY		0
#define NUM_REDIRECT_ROUTE_ENTRY	0

#endif	/* of #ifdef SUPPORT_LOOP */

#ifdef SUPPORT_ETHER

#define NUM_STATIC_ROUTE_ENTRY		0
#define NUM_REDIRECT_ROUTE_ENTRY	1

#endif	/* of #ifdef SUPPORT_ETHER */

#endif	/* of #ifdef SUPPORT_INET6 */

/*
 *  ǡ (ͥåȥ󥿥ե) ˴ؤ
 */

/*
 *  ͥåȤ˴ؤ
 */

/*
 *  PPP ˴ؤ
 */

#define HDLC_PORTID			1	/* HDLC(PPP)Ѥ륷ꥢݡֹ	*/

/*#define PPP_IDLE_TIMEOUT		(180*NET_TIMER_HZ)*/
					/* ǤޤǤΥɥ֡		*/
					/* ǤʤϥȥȤ롣	*/

/*#define PPP_CFG_MODEM			 ǥ³ξϥȤ򳰤	*/

#define MODEM_CFG_INIT			"ATE1&D0&S0\\V0\\Q1S0=1"
					/* ǥʸ			*/
					/* NTT DoComo Х륢ץ 96F 	*/
					/*   E1: Хå			*/
					/*  &D0: ER̵			*/
					/*  &S0: DR ON			*/
					/*  \V0: ꥶȥ TYPE 1		*/
					/*  \Q1: XON/XOFF ե		*/
					/* S0=1: ư忮󥰲 = 1 	*/

#define MODEM_CFG_PHONE_NUMBER		"090-xxxx-9242"

					/* ε			*/
#define DEF_LCP_LOCAL_CFGS		(LCP_CFG_MRU|LCP_CFG_ACCM|LCP_CFG_MAGIC|\
					 LCP_CFG_ACCOMP|LCP_CFG_PCOMP|LCP_CFG_PAP)

					/* ˵ε		*/
#define DEF_LCP_REMOTE_CFGS		(LCP_CFG_MRU|LCP_CFG_ACCM|LCP_CFG_MAGIC|\
					 LCP_CFG_ACCOMP|LCP_CFG_PCOMP|LCP_CFG_PAP)

/*
 *  ǧڤ˴ؤ
 */

#define AUTH_CFG_CLIENT		   	/* ǧڥ饤ȥ⡼ɤλϥȤ򳰤	*/
#define AUTH_CFG_SERVER			/* ǧڥХ⡼ɤλϥȤ򳰤		*/

#define AUTH_LOCAL_USER			"h8"		/* ۥȤؤΥǧڥ桼̾	*/
#define AUTH_LOCAL_PASSWD		"3048f"		/* ۥȤؤΥǧڥѥ	*/
#define AUTH_REMOTE_USER		"pen3"		/* ؤΥǧڥ桼̾		*/
#define AUTH_REMOTE_PASSWD		"600MHz"	/* ؤΥǧڥѥ		*/

/*
 *  ARP ˴ؤ
 */

/*#define ARP_CFG_CALLBACK_DUPLICATED*/	/* IP ɥ쥹ʣХХåؿ	*/
					/* ϥȤ򳰤		*/

/*
 *  ICMPv4/v6 ˴ؤ
 */

#ifdef USE_PING

#define ICMP_CFG_CALLBACK_ECHO_REPLY	/* ICMP ECHO ȤƽФХåؿ	*/
					/* ϥȤ򳰤			*/

#endif	/* of #ifdef USE_PING */

/*
 *  ͥåȥХåե˴ؤ
 */

#ifdef SUPPORT_ETHER

/*
 *  ͥåȤξΥͥåȥХåեγ
 */

/*
 *  64 ƥå
 *
 *    IPv4 ǤΤ߳Ƥ롣
 *
 *    IPv6 ǤϡTCP 楻ȡCSEGSDU ʤ˥
 *    ͥåȥХåեIF + IPv6 + TCP = 74˰ʲ
 *    ͥåȥХåեפǤ롣
 */

#ifdef NUM_MPF_NET_BUF_64
#undef NUM_MPF_NET_BUF_64
#endif

#ifdef SUPPORT_INET4
#define NUM_MPF_NET_BUF_64		2
#else
#define NUM_MPF_NET_BUF_64		0
#endif

/*
 *  CSEGIF + IP + TCP
 *
 *    IPv6 ǤΤ߳Ƥ롣
 *
 *    NE2000 ߴ NIC ΥǥХɥ饤Сif_edˤκĹϡ
 *    ͥåȥե졼κûĹǤ 60CRC  4 ƥåȤ
 *    ˥饤󤷤 62˥ƥåȤǤ롣
 *    äơIPv4 ǤϡCSEG ΥͥåȥХåե
 *   IF + IPv4 + TCP = 54ˤפǤ롣
 */

#ifdef NUM_MPF_NET_BUF_CSEG
#undef NUM_MPF_NET_BUF_CSEG
#endif

#ifdef SUPPORT_INET6
#define NUM_MPF_NET_BUF_CSEG		2
#else
#define NUM_MPF_NET_BUF_CSEG		0
#endif

/*
 *  128 ƥå
 *
 *    IPv4 ǡTCP MSSIP MSSIF + 576 ƥåȡˤ
 *    ͥåȥХåեƤ硢
 *    128 ƥåȤΥͥåȥХåեϳƤʤ
 */

#ifdef NUM_MPF_NET_BUF_128
#undef NUM_MPF_NET_BUF_128
#endif

#if defined(USE_TCP_MSS_SEG)
#define NUM_MPF_NET_BUF_128		0
#else
#define NUM_MPF_NET_BUF_128		1
#endif

/*
 *  256 ƥå
 *
 *    IPv4 ǡTCP MSSIP MSSIF + 576 ƥåȡˤ
 *    ͥåȥХåեƤ硢
 *    256 ƥåȤΥͥåȥХåեϳƤʤ
 */

#ifdef NUM_MPF_NET_BUF_256
#undef NUM_MPF_NET_BUF_256
#endif

#if defined(USE_TCP_MSS_SEG)
#define NUM_MPF_NET_BUF_256		0
#else
#define NUM_MPF_NET_BUF_256		1
#endif

/*
 *  512 ƥå	
 *
 *    IPv4 ǡTCP MSSIP MSSIF + 576 ƥåȡˤ
 *    ͥåȥХåեƤ硢
 *    512 ƥåȤΥͥåȥХåեϳƤʤ
 */

#ifdef NUM_MPF_NET_BUF_512
#undef NUM_MPF_NET_BUF_512
#endif

#if defined(USE_TCP_MSS_SEG)
#define NUM_MPF_NET_BUF_512		0
#else
#define NUM_MPF_NET_BUF_512		1
#endif

/*
 *  TCP MSSIP MSSIF + 576 ƥåȡ
 *
 *   IPv4 ǤΤ߳Ƥ롣
 *   ɥХåեξʥԡǽͭǡ
 *     ʥԡ API ѤȤϡ+1 Ƥ롣
 */

#ifdef NUM_MPF_NET_BUF_IP_MSS
#undef NUM_MPF_NET_BUF_IP_MSS
#endif

#if defined(SUPPORT_INET4) && defined(USE_TCP_MSS_SEG)

#if (defined(TCP_CFG_RWBUF_CSAVE)      || defined(TCP_CFG_SWBUF_CSAVE) ||	\
     defined(TCP_CFG_RWBUF_CSAVE_ONLY) || defined(TCP_CFG_SWBUF_CSAVE_ONLY)) && defined(USE_COPYSAVE_API)
#define NUM_MPF_NET_BUF_IP_MSS		3
#else
#define NUM_MPF_NET_BUF_IP_MSS		2	/* IF + 576 ƥå	*/
#endif

#else	/* of #if defined(SUPPORT_INET4) && defined(USE_TCP_MSS_SEG) */

#define NUM_MPF_NET_BUF_IP_MSS		0	/* IF + 576 ƥå	*/

#endif	/* of #if defined(SUPPORT_INET4) && defined(USE_TCP_MSS_SEG) */

/*
 *  1024 ƥå	
 *
 *    TCP MSS ΥͥåȥХåեƤ硢
 *    1024 ƥåȤΥͥåȥХåեϳƤʤ
 */

#ifdef NUM_MPF_NET_BUF_1024
#undef NUM_MPF_NET_BUF_1024
#endif

#if defined(USE_TCP_MSS_SEG)
#define NUM_MPF_NET_BUF_1024		0	/* 1024 ƥå	*/
#else
#define NUM_MPF_NET_BUF_1024		1	/* 1024 ƥå	*/
#endif

/*
 *  TCP MSSIPV6 MMTUIF + 1280 ƥåȡ
 *
 *   IPv6 ǤΤ߳Ƥ롣
 *   ɥХåեξʥԡǽͭǡ
 *     ʥԡ API ѤȤϡ+1 Ƥ롣
 */

#ifdef NUM_MPF_NET_BUF_IPV6_MMTU
#undef NUM_MPF_NET_BUF_IPV6_MMTU
#endif

#if defined(SUPPORT_INET6) && (defined(USE_TCP_MSS_SEG) || defined(USE_IPV6_MMTU))

#if (defined(TCP_CFG_RWBUF_CSAVE)      || defined(TCP_CFG_SWBUF_CSAVE) ||	\
     defined(TCP_CFG_RWBUF_CSAVE_ONLY) || defined(TCP_CFG_SWBUF_CSAVE_ONLY)) && defined(USE_COPYSAVE_API)
#define NUM_MPF_NET_BUF_IPV6_MMTU	3	/* IF + 1280	*/
#else
#define NUM_MPF_NET_BUF_IPV6_MMTU	2	/* IF + 1280	*/
#endif

#else	/* of #if defined(SUPPORT_INET6) && (defined(USE_TCP_MSS_SEG) || defined(USE_IPV6_MMTU)) */

#define NUM_MPF_NET_BUF_IPV6_MMTU	0	/* IF + 1280	*/

#endif	/* of #if defined(SUPPORT_INET6) && (defined(USE_TCP_MSS_SEG) || defined(USE_IPV6_MMTU)) */

/*
 *  IF  PDU 
 *
 *   TCP MSS ΥͥåȥХåեƤ硢
 *     IF  PDU ΥͥåȥХåեϳƤʤ
 *   ɥХåեξʥԡǽͭǡ
 *     ʥԡ API ѤȤϡ+1 Ƥ롣
 */

#ifdef NUM_MPF_NET_BUF_IF_PDU
#undef NUM_MPF_NET_BUF_IF_PDU
#endif

#ifdef USE_TCP_MSS_SEG

#define NUM_MPF_NET_BUF_IF_PDU		0

#else	/* of #ifdef USE_TCP_MSS_SEG */

#if (defined(TCP_CFG_RWBUF_CSAVE) || defined(TCP_CFG_SWBUF_CSAVE)) && defined(USE_COPYSAVE_API)
#define NUM_MPF_NET_BUF_IF_PDU		6
#else
#define NUM_MPF_NET_BUF_IF_PDU		5
#endif

#endif	/* of #ifdef USE_TCP_MSS_SEG */

/*
 *  65536 ƥå
 *
 *  NET_BUF_CFG_LONG_LEN ȤΤ߳Ƥ롣
 */

#ifdef NET_BUF_CFG_LONG_LEN

/* IPv6  */

#ifdef NUM_MPF_NET_BUF6_65536
#undef NUM_MPF_NET_BUF6_65536
#endif

#if defined(USE_TCP_MSS_SEG)
#define NUM_MPF_NET_BUF6_65536	0
#else
#define NUM_MPF_NET_BUF6_65536	2
#endif

#else	/* of ifdef NET_BUF_CFG_LONG_LEN */

#define NUM_MPF_NET_BUF6_65536	0

#endif	/* of ifdef NET_BUF_CFG_LONG_LEN */

#endif	/* of #ifdef SUPPORT_ETHER */

#endif /* _TINET_APP_CONFIG_H_ */
