/*
 * Decompiled with CFR 0.152.
 */
package webScraping.utility;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import webScraping.core.SearchData;

public class SearchDataRW {
    DocumentBuilder builder;
    public Document document;
    Element root;
    private final String splitchar = "\t";
    private String UrlAdress;
    private ArrayList<SearchData> slist = new ArrayList();

    public SearchDataRW() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void seturl(String UrlAdress) {
        this.UrlAdress = UrlAdress;
    }

    public void setslist(ArrayList slist) {
        this.slist = slist;
    }

    public String geturl() {
        return this.UrlAdress;
    }

    public ArrayList getslist() {
        return this.slist;
    }

    public void save(File file) {
        this.saveUrl(this.UrlAdress);
        this.saveSearchList(this.slist);
        this.write(file);
    }

    public void load(File file) {
        this.read(file);
        this.loadUrl();
        this.loadSearchList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCsv(File file) {
        BufferedWriter bufferedwriter = null;
        try {
            file.createNewFile();
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            OutputStreamWriter outputstreamwriter = new OutputStreamWriter((OutputStream)fileoutputstream, "UTF-8");
            bufferedwriter = new BufferedWriter(outputstreamwriter);
            bufferedwriter.write(this.UrlAdress);
            bufferedwriter.write("\n");
            Iterator<SearchData> i$ = this.slist.iterator();
            while (i$.hasNext()) {
                SearchData slist1;
                SearchData sdat = slist1 = i$.next();
                StringBuilder str = new StringBuilder();
                str.append(sdat.getitem()).append("\t");
                str.append(sdat.getHtmltag()).append("\t");
                str.append(sdat.getHtmlid()).append("\t");
                str.append(sdat.getHtmlclass()).append("\t");
                str.append(sdat.getaround()).append("\t");
                str.append(sdat.getregexp()).append("\n");
                bufferedwriter.write(str.toString());
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (bufferedwriter != null) {
                    bufferedwriter.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCsv(File file) {
        this.slist = new ArrayList();
        BufferedReader bufferedreader = null;
        try {
            String rec;
            FileInputStream fileinputstream = new FileInputStream(file);
            InputStreamReader inputstreamreader = new InputStreamReader((InputStream)fileinputstream, "UTF-8");
            bufferedreader = new BufferedReader(inputstreamreader);
            this.UrlAdress = bufferedreader.readLine();
            while ((rec = bufferedreader.readLine()) != null) {
                String[] recary = rec.split("\t", -1);
                SearchData sdat = new SearchData();
                sdat.setitem(recary[0]);
                sdat.setHtmltag(recary[1]);
                sdat.setHtmlid(recary[2]);
                sdat.setHtmlclass(recary[3]);
                sdat.setaround(recary[4]);
                sdat.setregexp(recary[5]);
                this.slist.add(sdat);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (bufferedreader != null) {
                    bufferedreader.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void saveXml(File file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder wkBuilder = factory.newDocumentBuilder();
            DOMImplementation domImpl = wkBuilder.getDOMImplementation();
            Document doc = domImpl.createDocument("", "searchdata", null);
            Element wkRoot = doc.getDocumentElement();
            Element url = doc.createElement("url");
            url.appendChild(doc.createTextNode(this.UrlAdress));
            wkRoot.appendChild(url);
            Iterator<SearchData> i$ = this.slist.iterator();
            while (i$.hasNext()) {
                SearchData slist1;
                SearchData sdat = slist1 = i$.next();
                Element cslist = doc.createElement("searchlist");
                Element item = doc.createElement("item");
                Element htmltag = doc.createElement("htmltag");
                Element htmlid = doc.createElement("htmlid");
                Element htmlclass = doc.createElement("htmlclass");
                Element around = doc.createElement("around");
                Element regexp = doc.createElement("regexp");
                item.appendChild(doc.createTextNode(sdat.getitem()));
                htmltag.appendChild(doc.createTextNode(sdat.getHtmltag()));
                htmlid.appendChild(doc.createTextNode(sdat.getHtmlid()));
                htmlclass.appendChild(doc.createTextNode(sdat.getHtmlclass()));
                around.appendChild(doc.createTextNode(sdat.getaround()));
                regexp.appendChild(doc.createTextNode(sdat.getregexp()));
                cslist.appendChild(item);
                cslist.appendChild(htmltag);
                cslist.appendChild(htmlid);
                cslist.appendChild(htmlclass);
                cslist.appendChild(around);
                cslist.appendChild(regexp);
                wkRoot.appendChild(cslist);
            }
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            FileOutputStream os = new FileOutputStream(file);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
        catch (FileNotFoundException | ParserConfigurationException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadXml(File file) {
        this.slist = new ArrayList();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder wkBuilder = factory.newDocumentBuilder();
            Document doc = wkBuilder.parse(file);
            Element wkRoot = doc.getDocumentElement();
            NodeList url = wkRoot.getElementsByTagName("url");
            Node urlnode = url.item(0);
            this.UrlAdress = urlnode.getFirstChild().getNodeValue();
            NodeList cslist = wkRoot.getElementsByTagName("searchlist");
            for (int i = 0; i < cslist.getLength(); ++i) {
                SearchData sdat = new SearchData();
                Node slistnode = cslist.item(i);
                block19: for (Node child = slistnode.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 1) continue;
                    String tag = child.getNodeName();
                    String rtn = "";
                    if (child.getFirstChild() != null) {
                        rtn = child.getFirstChild().getNodeValue();
                    }
                    switch (tag) {
                        case "item": {
                            sdat.setitem(rtn);
                            continue block19;
                        }
                        case "htmltag": {
                            sdat.setHtmltag(rtn);
                            continue block19;
                        }
                        case "htmlid": {
                            sdat.setHtmlid(rtn);
                            continue block19;
                        }
                        case "htmlclass": {
                            sdat.setHtmlclass(rtn);
                            continue block19;
                        }
                        case "around": {
                            sdat.setaround(rtn);
                            continue block19;
                        }
                        case "regexp": {
                            sdat.setregexp(rtn);
                        }
                    }
                }
                this.slist.add(sdat);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void loadUrl() {
        NodeList nodelist = this.root.getElementsByTagName("url");
        Node node = nodelist.item(0);
        this.UrlAdress = node.getFirstChild().getNodeValue();
    }

    public void loadSearchList() {
        this.slist.clear();
        SearchData.clear();
        NodeList nodelist = this.root.getElementsByTagName("searchlist");
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node childnode = nodelist.item(i);
            boolean sdatflg = false;
            SearchData sdat = new SearchData();
            block17: for (Node child = childnode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1) continue;
                String tag = child.getNodeName();
                String rtn = "";
                if (child.getFirstChild() != null) {
                    rtn = child.getFirstChild().getNodeValue();
                }
                switch (tag) {
                    case "item": {
                        sdat.setitem(rtn);
                        sdatflg = true;
                        continue block17;
                    }
                    case "htmltag": {
                        sdat.setHtmltag(rtn);
                        sdatflg = true;
                        continue block17;
                    }
                    case "htmlid": {
                        sdat.setHtmlid(rtn);
                        sdatflg = true;
                        continue block17;
                    }
                    case "htmlclass": {
                        sdat.setHtmlclass(rtn);
                        sdatflg = true;
                        continue block17;
                    }
                    case "around": {
                        sdat.setaround(rtn);
                        sdatflg = true;
                        continue block17;
                    }
                    case "regexp": {
                        sdat.setregexp(rtn);
                        sdatflg = true;
                    }
                }
            }
            if (sdatflg) {
                this.slist.add(sdat);
            }
            if (!sdatflg) continue;
            SearchData.add(sdat);
        }
    }

    public String loadMsg404() {
        StringBuilder strbuf = new StringBuilder();
        NodeList nodelist = this.root.getElementsByTagName("msg404");
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node childnode = nodelist.item(i);
            String str = childnode.getFirstChild().getNodeValue();
            if (strbuf.length() > 0) {
                strbuf.append("\n");
            }
            strbuf.append(str);
        }
        return strbuf.toString();
    }

    public Element loadElement(String elementTagName) {
        NodeList nodelist = this.root.getElementsByTagName(elementTagName);
        Element element = (Element)nodelist.item(0);
        return element;
    }

    void saveUrl(String urladdress) {
        this.checkdoc();
        this.removeElement("url");
        Element url = this.document.createElement("url");
        url.appendChild(this.document.createTextNode(urladdress));
        this.root.appendChild(url);
    }

    void saveSearchList(ArrayList slist) {
        this.checkdoc();
        this.removeElement("searchlist");
        int count = 0;
        for (Object slist1 : slist) {
            SearchData sdat = (SearchData)slist1;
            Element cslist = this.document.createElement("searchlist");
            cslist.setAttribute("listNo", String.valueOf(++count));
            this.addChild(cslist, "item", sdat.getitem());
            this.addChild(cslist, "htmltag", sdat.getHtmltag());
            this.addChild(cslist, "htmlid", sdat.getHtmlid());
            this.addChild(cslist, "htmlclass", sdat.getHtmlclass());
            this.addChild(cslist, "around", sdat.getaround());
            this.addChild(cslist, "regexp", sdat.getregexp());
            this.root.appendChild(cslist);
        }
    }

    void saveMsg404(String msg) {
        this.checkdoc();
        this.removeElement("msg404");
        String[] msgs = msg.split("\n");
        int count = 0;
        for (String msgOne : msgs) {
            Element msgElement = this.document.createElement("msg404");
            msgElement.setAttribute("No", String.valueOf(++count));
            msgElement.appendChild(this.document.createTextNode(msgOne));
            this.root.appendChild(msgElement);
        }
    }

    public void saveElement(Element element) {
        this.checkdoc();
        this.removeElement(element.getTagName());
        this.root.appendChild(element);
    }

    private void addChild(Element cslist, String keyword, String data) {
        if (!data.isEmpty()) {
            Element element = this.document.createElement(keyword);
            element.appendChild(this.document.createTextNode(data));
            cslist.appendChild(element);
        }
    }

    private void removeElement(String elementTagName) {
        int nodeSize;
        do {
            NodeList nodelist = this.document.getElementsByTagName(elementTagName);
            nodeSize = nodelist.getLength();
            for (int i = 0; i < nodelist.getLength(); ++i) {
                Node node = nodelist.item(i);
                this.root.removeChild(node);
            }
        } while (nodeSize > 0);
    }

    public void checkdoc() {
        if (this.document == null) {
            DOMImplementation domImpl = this.builder.getDOMImplementation();
            this.document = domImpl.createDocument("", "searchdata", null);
        }
        this.root = this.document.getDocumentElement();
    }

    public void read(File file) {
        try {
            this.document = this.builder.parse(file);
            this.root = this.document.getDocumentElement();
        }
        catch (IOException | SAXException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void write(File file) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            DOMSource source = new DOMSource(this.document);
            FileOutputStream os = new FileOutputStream(file);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException | TransformerException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

