/*
 * Decompiled with CFR 0.152.
 */
package webScraping.core;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import webScraping.core.AttributeData;
import webScraping.core.DebugProcess;
import webScraping.core.SearchData;

class HtmlParserCallback
extends HTMLEditorKit.ParserCallback {
    HashMap<HTML.Tag, Integer> tagMap = new HashMap();
    String keytag;
    String keyid;
    String keyclass;
    int bufCount = 0;
    HTML.Tag bufTag = null;
    StringBuilder bufText;
    ArrayList sData;
    AttributeData attrdata;

    protected HtmlParserCallback(SearchData skey) {
        this.keytag = skey.getHtmltag();
        this.keyid = skey.getHtmlid();
        this.keyclass = skey.getHtmlclass();
        this.sData = new ArrayList();
    }

    ArrayList getrtnData() {
        return this.sData;
    }

    @Override
    public void handleStartTag(HTML.Tag tag, MutableAttributeSet attr, int pos) {
        int count = 1;
        if (this.tagMap.containsKey(tag)) {
            count = this.tagMap.get(tag);
            ++count;
        }
        this.tagMap.put(tag, count);
        AttributeData handleStartattrdata = new AttributeData();
        handleStartattrdata.add(tag, attr);
        DebugProcess.htmlinfo(tag, attr, "handleStartTag", count);
        if (this.bufCount == 0 && tag.toString().equals(this.keytag) && this.serachAttribute(tag, handleStartattrdata)) {
            this.bufCount = count;
            this.bufTag = tag;
            this.attrdata = new AttributeData();
            this.bufText = new StringBuilder();
        }
        if (this.bufCount > 0) {
            this.attrdata.add(tag, attr);
        }
    }

    @Override
    public void handleEndTag(HTML.Tag tag, int pos) {
        int count = 0;
        if (this.tagMap.containsKey(tag)) {
            count = this.tagMap.get(tag);
        }
        DebugProcess.htmlinfo(tag, null, "handleEndTag", count);
        if (tag.equals(this.bufTag) && count <= this.bufCount) {
            this.sData.add(this.bufText.toString());
            this.bufCount = 0;
            this.bufTag = null;
            this.bufText = null;
        }
        this.tagMap.put(tag, --count);
    }

    @Override
    public void handleText(char[] data, int pos) {
        DebugProcess.htmlinfo(data, "handleText");
        String splitchar = "\t";
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] <= '\u001f' || data[i] == '\u007f' || data[i] == '\u00a0') continue;
            buf.append(data[i]);
        }
        if (this.bufCount > 0) {
            if (this.bufText.length() > 0) {
                this.bufText.append(splitchar);
            }
            this.bufText.append(buf.toString());
        }
    }

    @Override
    public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attr, int pos) {
        if (this.bufCount > 0) {
            this.attrdata.add(tag, attr);
        }
        DebugProcess.htmlinfo(tag, attr, "handleSimpleTag", 0);
    }

    boolean serachAttribute(MutableAttributeSet attr) {
        String currentID = (String)attr.getAttribute(HTML.Attribute.ID);
        String currentClass = (String)attr.getAttribute(HTML.Attribute.CLASS);
        if (!this.keyid.isEmpty() && !this.keyclass.isEmpty() && this.keyid.equals(currentID) && this.keyclass.equals(currentClass)) {
            return true;
        }
        if (!this.keyid.isEmpty() && this.keyid.equals(currentID)) {
            return true;
        }
        return !this.keyclass.isEmpty() && this.keyclass.equals(currentClass);
    }

    boolean serachAttribute(HTML.Tag tag, AttributeData attrdata) {
        if (!this.keyid.isEmpty() && !this.keyclass.isEmpty() && attrdata.searchId(tag, this.keyid) && attrdata.searchClass(tag, this.keyclass)) {
            return true;
        }
        if (!this.keyid.isEmpty()) {
            return attrdata.searchId(tag, this.keyid);
        }
        if (!this.keyclass.isEmpty()) {
            return attrdata.searchClass(tag, this.keyclass);
        }
        return false;
    }
}

