﻿using System;
using System.IO;
using System.Security.Principal;
using System.Threading;
using System.Windows.Forms;
using System.Collections;

namespace F_FileTree
{
    public class clsFileAttr
    {
        public string filepath { get; set; }
        public string fileOwner { get; set; }
        public long filesize { get; set; }
        public int threadno { get; set; }
    }

    public class Program
    {
        static void Main(string[] args)
        {
            if (args.Length < 2)
            {
                Console.WriteLine("[usage]");
                Console.WriteLine("C:\\>F_FileTree C:\\ *.*");
                Console.WriteLine("");
                // バージョン名（AssemblyInformationalVersion属性）を取得
                string appVersion = Application.ProductVersion;
                // 製品名（AssemblyProduct属性）を取得
                string appProductName = Application.ProductName;
                // 会社名（AssemblyCompany属性）を取得
                string appCompanyName = Application.CompanyName;
                Console.WriteLine(appProductName + " " + appVersion + "\r\nCopyright© 2014 Ohyamahoo \r\nSimplified BSD License");
                return;
            }
            
            //Stopwatchオブジェクトを作成する
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            //ストップウォッチを開始する
            sw.Start();

            SearchFiles printer = new SearchFiles(); // （1）
            printer.setParam(args[0], args[1]); // （2）
            Thread.Sleep(100);
            while (bufferd.getThreadCnt() > 0)
            {
                Thread.Sleep(100);
            }

            clsFileAttr[] stFilePathes = bufferd.getData();

            //ストップウォッチを止める
            sw.Stop();

            //結果を表示する
            Console.WriteLine(sw.Elapsed);

            // 取得したファイル名を列挙する
            System.Collections.Hashtable hash = new Hashtable();
            foreach (clsFileAttr stFilePath in stFilePathes)
            {
                if (stFilePath != null)
                {
                    Console.WriteLine("\"" + stFilePath.filepath + "\"," + stFilePath.filesize + ",\"" + stFilePath.fileOwner + "\"," + stFilePath.threadno);
                    string ext = "<non>";
                    if (stFilePath.filepath.LastIndexOf(".") > 0 && stFilePath.filepath.Substring(stFilePath.filepath.LastIndexOf(".")).IndexOf("\\") < 0)
                    {
                        ext = stFilePath.filepath.Substring(stFilePath.filepath.LastIndexOf("."));
                    }
                    if (hash.Contains(ext))
                    {
                        clsFileAttr cfa = (clsFileAttr)hash[ext];
                        cfa.filesize += stFilePath.filesize;
                        cfa.threadno += 1;
                        hash[ext] = cfa;
                    }
                    else
                    {
                        clsFileAttr cfa = new clsFileAttr();
                        cfa.filepath = ext;
                        cfa.filesize = stFilePath.filesize;
                        cfa.threadno = 1;
                        hash.Add(ext, cfa);
                    }
                }
                //stPrompt += stFilePath + System.Environment.NewLine;
            }

            IDictionaryEnumerator denum = hash.GetEnumerator();
            DictionaryEntry dentry;
            while (denum.MoveNext())
            {
                dentry = (DictionaryEntry)denum.Current;
                clsFileAttr cfa = (clsFileAttr)dentry.Value;
                Console.WriteLine("***,{0},{1},{2}", cfa.filepath, cfa.threadno, cfa.filesize);
            }

            //Console.ReadLine();
        }
    }

    public class SearchFiles // （3）
    {
        private string stRootPath, stPattern;
        private int runthreadno = 0;
        private Thread thread;

        public Boolean isRunning()
        {
            return thread.IsAlive;
        }

        public void setParam(string srcRootPath, string srcPattern) // （4）
        {
            // （5）
            stRootPath = srcRootPath;
            stPattern = srcPattern;
            while (bufferd.getThreadCnt() > 50)
            {
                Thread.Sleep(100);
            }
            runthreadno = bufferd.getThreadCnt();
            thread = new Thread(new ThreadStart(ThreadMethod));
            //thread.IsBackground = true;
            thread.Start();
        }

        // 別スレッドで動作させるメソッド
        private void ThreadMethod() // （6）
        {
            if (stRootPath.IndexOf("$RECYCLE.BIN") >= 0)
            {
                return;
            }
            bufferd.addCnt();
            System.Collections.ArrayList hStringCollection = new System.Collections.ArrayList();

            try
            {
                // このディレクトリ内のすべてのファイルを検索する
                foreach (string stFilePath in System.IO.Directory.GetFiles(stRootPath, stPattern))
                {
                    string owner = "#err#";
                    long filesize = 0;
                    try
                    {
                        var fileSecurity = File.GetAccessControl(stFilePath);
                        // NTAccount形式で取得
                        var account = fileSecurity.GetOwner(typeof(NTAccount));
                        //Console.WriteLine("Account: " + account.Value);
                        owner = account.Value;
                        // SIDで取得
                        //var sid = fileSecurity.GetOwner(typeof(SecurityIdentifier));
                        //Console.WriteLine("SID: " + sid.Value); 
                    }
                    catch (Exception)
                    {
                    }
                    try
                    {
                        FileInfo fi = new System.IO.FileInfo(stFilePath);
                        //ファイルのサイズを取得
                        filesize = fi.Length;
                    }
                    catch (Exception)
                    {
                    }
                    clsFileAttr a = new clsFileAttr();
                    a.filepath = stFilePath;
                    a.fileOwner = owner;
                    a.filesize = filesize;
                    a.threadno = runthreadno;
                    hStringCollection.Add(a);
                    Thread.Yield();
                }
                bufferd.setData(hStringCollection);
                bufferd.subCnt();
                // このディレクトリ内のすべてのサブディレクトリを検索する (再帰)
                foreach (string stDirPath in System.IO.Directory.GetDirectories(stRootPath))
                {
                    SearchFiles printer = new SearchFiles();
                    printer.setParam(stDirPath, stPattern);
                }
            }
            catch (System.ArgumentException)
            {
                clsFileAttr a = new clsFileAttr();
                a.filepath = stRootPath;
                a.fileOwner = "#err#";
                a.filesize = -1;
                a.threadno = -1;
                hStringCollection.Add(a);
                Thread.Yield();

                bufferd.setData(hStringCollection);
                bufferd.subCnt();
            }
            catch (System.UnauthorizedAccessException)
            {
                clsFileAttr a = new clsFileAttr();
                a.filepath = stRootPath;
                a.fileOwner = "#err#";
                a.filesize = -1;
                a.threadno = -1;
                hStringCollection.Add(a);
                Thread.Yield();

                bufferd.setData(hStringCollection);
                bufferd.subCnt();
            }
        }
    }

    public class bufferd
    {
        private static System.Collections.ArrayList buff = new System.Collections.ArrayList();
        private static int threadcnt = 0;
        private static System.Object lockThis = new System.Object();
        private static Mutex mx2 = new Mutex(false);
        private static Mutex mx = new Mutex(false);

        public static int getThreadCnt()
        {
            int ret = 0;
            mx2.WaitOne();
            ret = threadcnt;
            mx2.ReleaseMutex();
            return ret;
        }

        public static void addCnt()
        {
            mx2.WaitOne();
            threadcnt++;
            mx2.ReleaseMutex();
        }

        public static void subCnt()
        {
            mx2.WaitOne();
            threadcnt--;
            mx2.ReleaseMutex();
        }

        public static void setData(System.Collections.ArrayList src)
        {
            mx.WaitOne();
            buff.AddRange(src);
            mx.ReleaseMutex();
        }

        public static clsFileAttr[] getData()
        {
            // StringCollection を 1 次元の String 配列にして返す
            clsFileAttr[] stReturns = new clsFileAttr[buff.Count];
            buff.CopyTo(stReturns, 0);
            return stReturns;
        }
    }
}
