/*
	vfd.h

	Virtual Floppy Disk kernel-mode driver for Windows NT platform
	Copyright (C) 2002 Kenji Kato
*/

#ifndef _VFDDRV_H_
#define _VFDDRV_H_

#ifndef __T
#ifdef _NTDDK_
#define __T(x)	L ## x
#else
#define __T(x)	x
#endif
#endif

#ifndef _T
#define _T(x)	__T(x)
#endif

//
//	String Definitions
//

#define VFD_DEVICE_PREFIX		_T("\\Device\\")
#define VFD_DEVICE_BASENAME		_T("VirtualFD")

#define VFD_DEVICE_FULLNAME		VFD_DEVICE_PREFIX	VFD_DEVICE_BASENAME

//
//	Device IO control codes
//

//	Mount existing image file or create a new image file of specified size

#define IOCTL_VFD_OPEN_FILE			CTL_CODE(				\
										IOCTL_DISK_BASE,	\
										0x800,				\
										METHOD_BUFFERED,	\
										FILE_READ_ACCESS | FILE_WRITE_ACCESS)

//	Unmount currently mounted image file

#define IOCTL_VFD_CLOSE_FILE		CTL_CODE(				\
										IOCTL_DISK_BASE,	\
										0x801,				\
										METHOD_NEITHER,		\
										FILE_READ_ACCESS | FILE_WRITE_ACCESS)

//	Get currently mounted image file information

#define IOCTL_VFD_QUERY_FILE		CTL_CODE(				\
										IOCTL_DISK_BASE,	\
										0x802,				\
										METHOD_BUFFERED,	\
										FILE_ANY_ACCESS)

//	Image file information structure

typedef struct _VFD_FILE_INFO {
	ULONG		FileSize;
	BOOLEAN		ReadOnly;
	USHORT		FileNameLength;
	CHAR		FileName[1];
} VFD_FILE_INFO, *PVFD_FILE_INFO;

//	Supported file size values

#define	VFD_FILESIZE_720KB 	737280
#define VFD_FILESIZE_1P44MB	1474560
#define VFD_FILESIZE_2P88MB	2949120

#endif	//	_VFDDRV_H_
