/*
	vfdctl.h

	Virtual Floppy Disk driver control routines header
	Copyright (C) 2003 Kenji Kato
*/

#ifndef _VFDCTL_H_
#define _VFDCTL_H_

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

#include "vfd.h"
#include "vfderr.h"

//
//	custom SERVICE STATE value
//
#define VFD_NOT_INSTALLED		0xffffffff

//
//	Message string for registering a window message
//
#define VFD_BROADCAST_MSG_STR	"VfdBroadcastMessage"

//
//	Virtual FD operation number
//
enum {
	VFD_OPERATION_NONE,
	VFD_OPERATION_INSTALL,
	VFD_OPERATION_REMOVE,
	VFD_OPERATION_START,
	VFD_OPERATION_STOP,
	VFD_OPERATION_MOUNT,
	VFD_OPERATION_UMOUNT,
	VFD_OPERATION_LINK,
	VFD_OPERATION_ULINK
};

//
//	function prototypes
//

//	Get current driver config information

DWORD VfdGetDriverConfig(
	LPTSTR	driver_path,
	LPDWORD	start_type);

//	Get current driver state

DWORD VfdGetDriverState(
	LPDWORD	current_state);

//	Install the driver

DWORD VfdInstall(
	LPCTSTR	driver_path,
	BOOL	auto_start);

//	Uninstall the driver

DWORD VfdRemove();

//	Start the driver

DWORD VfdStart(DWORD *state);

//	Stop the driver

DWORD VfdStop(DWORD *state);

//	Mount an image file

DWORD VfdMount(
	LPCTSTR	file_name,
	BOOL	read_only,
	ULONG	file_size);

//	Unmount an image file

DWORD VfdUmount();

//	Get current image file information

DWORD VfdGetFileInfo(
	LPTSTR	file_name,
	ULONG	*file_size,
	BOOL	*read_only);

//	Get current media state (mounted / write protected)

DWORD VfdGetMediaState();

//	Assign a drive letter

DWORD VfdSetDriveLetter(
	TCHAR	drive_letter);

//	Remove a drive letter

DWORD VfdDelDriveLetter(
	TCHAR	drive_letter);

//	Get current drive letter

DWORD VfdGetDriveLetter(
	TCHAR	*drive_letter);

//	Check if specified file is valid VFD driver

DWORD VfdCheckDriverFile(
	LPCTSTR	driver_path);

//	Check if specified path is valid for an image file

DWORD VfdCheckImageFile(
	LPCTSTR	file_name,
	ULONG	*file_size,
	BOOL	*read_only);

//	Get VFD error message

int VfdErrorMessage(
	DWORD	err,
	LPTSTR	buf,
	DWORD	size);

#ifdef __cplusplus
}
#endif	//	__cplusplus

#endif	//	_VFDCTL_H_

//	End Of File
