/* $Id$ */
package nicobrowser;

import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;

/**
 *
 * @author yuki
 */
public class VideoInfo {

    public static final String KEY_THREAD_ID = "thread_id";
    private static final String KEY_VIDEO_LENGTH = "l";
    private static final String KEY_URL = "url";
    private static final String KEY_SMILE_LINK = "link";
    private static final String KEY_MESSAGE_URL = "ms";
    public static final String KEY_USER_ID = "user_id";
    public static final String KEY_OPTIONAL_THREAD_ID = "optional_thread_id";
    /** (リダイレクトが必要な動画の場合、リダイレクトした後の)動画ID */
    private final String realVideoId;
    /** watchページから取得した動画タイトル. **/
    private final String titleInWatchPage;
    private final String threadId;
    private final URL videoUrl;
    private final URL messageUrl;
    private final URL smileUrl;
    private final String userId;
    private final int videoLength;
    private final String optionalThreadId;
    private final Map<String, String> keyMap;

    /**
     *
     * @param realVideoId
     * @param getflvReceivedMap
     * @param keyMap 公式動画投稿者コメント取得用パラメータ.
     */
    public VideoInfo(String realVideoId, String title, Map<String, String> getflvReceivedMap, Map<String, String> keyMap) {
        try {
            this.realVideoId = realVideoId;
            this.titleInWatchPage = title;
            threadId = getflvReceivedMap.get(KEY_THREAD_ID);
            videoUrl = new URL(URLDecoder.decode(getflvReceivedMap.get(KEY_URL), "UTF-8"));
            messageUrl = new URL(URLDecoder.decode(getflvReceivedMap.get(KEY_MESSAGE_URL), "UTF-8"));
            smileUrl = new URL(URLDecoder.decode("http://www.upload.nicovideo.jp/allegation/"+realVideoId.replaceAll("sm|nm|so|ca",""), "UTF-8"));
            userId = getflvReceivedMap.get(KEY_USER_ID);
            videoLength = Integer.parseInt(getflvReceivedMap.get(KEY_VIDEO_LENGTH));
            optionalThreadId = getflvReceivedMap.get(KEY_OPTIONAL_THREAD_ID);
            this.keyMap = keyMap;
        } catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getRealVideoId() {
        return realVideoId;
    }

    public String getTitleInWatchPage() {
        return titleInWatchPage;
    }

    public URL getMessageUrl() {
        return messageUrl;
    }

    public URL getSmileUrl() {
        return smileUrl;
    }

    public String getThreadId() {
        return threadId;
    }

    public String getUserId() {
        return userId;
    }

    /** @return 再生時間(秒) */
    public int getVideoLength() {
        return videoLength;
    }

    public URL getVideoUrl() {
        return videoUrl;
    }

    public String getOptionalThreadId() {
        return optionalThreadId;
    }

    public Map<String, String> getKeyMap() {
        return keyMap;
    }

    /**
     * 実際のres_fromに設定するにはこの値に-1をかける必要があります.
     * @return 動画の長さに応じたコメント表示数.
     */
    public int getResFrom() {
        if (videoLength < 60) {
            return 100;
        } else if (videoLength < 300) {
            return 250;
        } else if (videoLength < 600) {
            return 500;
        }
        return 1000;
    }
}
