package nicobrowser.util

import org.cyberneko.html.parsers.SAXParser

/**
 * watchページのパースを実行するクラス.
 * ニコニコ動画(原宿)より前のバージョンでは動作未検証.
 * @author yuki
 */
class WatchParse {
    def slurper = new XmlSlurper(new SAXParser())
    def headerTitlePattern = /^(.+) ‐ ニコニコ動画\(.+\)$/

    String getTitle(InputStream is){
        def html = slurper.parse(is)
        def res = html.HEAD.TITLE
        def headerTitle = res.text()
        def matcher = (headerTitle =~ headerTitlePattern)
        if(matcher){
            return matcher[0][1]
        }

        // ニコニコ動画(Zero)用
        def innerTitle = html.'**'.find {
            it.@id == 'videoHeaderDetail'
        }
        return innerTitle.DIV.H2.text()
    }
}
