/*$Id$*/
package nicobrowser.util;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {

    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    static ResultParse rp = new ResultParse();
    static WatchParse wp = new WatchParse();
    static UserInfo ui = new UserInfo();

    public static String getExtention(String contentType) {
        if ("video/flv".equals(contentType) || "video/x-flv".equals(contentType)) {
            return "flv";
        } else if ("video/mp4".equals(contentType)) {
            return "mp4";
        } else if ("application/x-shockwave-flash".equals(contentType)) {
            return "swf";
        }
        return contentType.split("/")[1];
    }

    public static List<Result> parseSearchResult(InputStream is) {
        return rp.parse(is);
    }

    public static TreeMap<Integer, String> getOtherPages(InputStream is) {
        return rp.getOtherPages(is);
    }

    /**
     * ユーザIDを取得する
     *
     * @param is ニコニコ動画のウォッチページストリーム.
     * @return ユーザID. 取得できなければnull.
     */
    public static String getUserId(InputStream is) {
        return ui.getUserId(is);
    }

    /**
     * 違反通報ページURLを取得する.
     *
     * @param is ニコニコ動画のウォッチページストリーム.
     * @return 違反通報ページURL. 取得できなければnull.
     */
    public static URL getNotifierUrl(InputStream is) {
        String res = ui.getNotifierUrl(is);
        if (res == null) {
            return null;
        }

        try {
            return new URL(res);
        } catch (MalformedURLException ex) {
            logger.error(null, ex);
            return null;
        }
    }

    /**
     * ユーザ名を取得する.
     *
     * @param is 違反通報ページストリーム.
     * @return ユーザ名. 取得できなければnull.
     */
    public static String getUserName(InputStream is) {
        String userName = ui.getUserName(is);
        if ("".equals(userName)) {
            userName = null;
        }
        return userName;
    }

    /**
     * Watchページから動画タイトルを取得する.
     *
     * @param watchPage watchページストリーム.
     * @return 動画名.
     */
    public static String getTitle(InputStream watchPage) {
        return wp.getTitle(watchPage);
    }
}
