/***********************************************************************/
/*                                                                     */
/*  FILE        :lowsrc.c                                              */
/*  DATE        :Wed, Aug 27, 2014                                     */
/*  DESCRIPTION :Program of I/O Stream                                 */
/*  CPU TYPE    :RX62N                                                 */
/*                                                                     */
/*  This file is generated by Renesas Project Generator (Ver.4.53).    */
/*  NOTE:THIS IS A TYPICAL EXAMPLE.                                    */
/*                                                                     */
/***********************************************************************/
/*********************************************************************
*
* Device     : RX
*
* File Name  : lowsrc.c
*
* Abstract   : Program of I/O Stream.
*
* History    : 1.00  (2009-08-07)
*
* NOTE       : THIS IS A TYPICAL EXAMPLE.
*
* Copyright (C) 2009 Renesas Electronics Corporation.
* and Renesas Solutions Corporation. All rights reserved.
*
*********************************************************************/

#include <string.h>
#include <stdio.h>
#include <stddef.h>
#include "lowsrc.h"

/* t@Cԍ */
#define STDIN  0                    /* W           (R\[) */
#define STDOUT 1                    /* Wo           (R\[) */
#define STDERR 2                    /* WG[o     (R\[) */

#define FLMIN  0                    /* ŏ̃t@Cԍ              */
#define _MOPENR	0x1
#define _MOPENW	0x2
#define _MOPENA	0x4
#define _MTRUNC	0x8
#define _MCREAT	0x10
#define _MBIN	0x20
#define _MEXCL	0x40
#define _MALBUF	0x40
#define _MALFIL	0x80
#define _MEOF	0x100
#define _MERR	0x200
#define _MLBF	0x400
#define _MNBF	0x800
#define _MREAD	0x1000
#define _MWRITE	0x2000
#define _MBYTE	0x4000
#define _MWIDE	0x8000
/* t@CtO */
#define O_RDONLY 0x0001 /* ǂݍݐpɃI[v                      */
#define O_WRONLY 0x0002 /* opɃI[v                      */
#define O_RDWR   0x0004 /* ǂݏApɃI[v                    */
#define O_CREAT  0x0008 /* t@C݂ȂꍇAVK쐬          */
#define O_TRUNC  0x0010 /* t@C݂ꍇAt@CTCY0 */
#define O_APPEND 0x0020 /* ɓǂݏst@C̈ʒuݒ    */
                        /* 0Ft@C̐擪  1Ft@C̍Ō        */

/* ꕶR[h */
#define CR 0x0d                     /* A                            */
#define LF 0x0a                     /* s                            */

extern const long _nfiles;     /* o̓t@Cw               */
char flmod[IOSTREAM];          /* I[vt@C̃[hݒꏊ */

unsigned char sml_buf[IOSTREAM];

#define FPATH_STDIN     "C:\\stdin"
#define FPATH_STDOUT    "C:\\stdout"
#define FPATH_STDERR    "C:\\stderr"

/* W͂1͏ */
extern void charput(unsigned char);
/* Wo͂ւ1o͏ */
extern unsigned char charget(void);

#include <stdio.h>
FILE *_Files[IOSTREAM]; // t@C\
char *env_list[] = { //ϐz(**environ)
    "ENV1=temp01",
    "ENV2=temp02",
    "ENV9=end",
    '\0'            // ϐzI[NULL
};

char **environ = env_list;

/****************************************************************************/
/* _INIT_IOLIB                                                              */
/*  Initialize C library Functions, if necessary.                           */
/*  Define USES_SIMIO on Assembler Option.                                  */
/****************************************************************************/
void _INIT_IOLIB( void )
{
    /* Wo͗pt@CI[vA܂͐܂BeFILE\̂     */
    /* ̓CuōsĂ܂Bet@C\̂_Bufo   */
    /* freopen()ɂăZbgꂽobt@ŏI|C^Đݒ肵܂B  */

    /* W͗pt@C                                                   */
    if( freopen( FPATH_STDIN, "r", stdin ) == NULL )
        stdin->_Mode = 0xffff;          /* I[vs̃ANZX֎~     */
    stdin->_Mode  = _MOPENR;            /* t@Cǂݍݐpɐݒ     */
    stdin->_Mode |= _MNBF;              /* f[^̃obt@OȂɐݒ */
    stdin->_Bend = stdin->_Buf + 1;     /* obt@ŏI|C^̍Đݒ     */

    /* Wo͗pt@C                                                   */
    if( freopen( FPATH_STDOUT, "w", stdout ) == NULL ) 
        stdout->_Mode = 0xffff;         /* I[vs̃ANZX֎~     */
    stdout->_Mode |= _MNBF;             /* f[^̃obt@OȂɐݒ */
    stdout->_Bend = stdout->_Buf + 1;   /* obt@ŏI|C^̍Đݒ     */
    
    /* WG[o͗pt@C                                             */
    if( freopen( FPATH_STDERR, "w", stderr ) == NULL )
        stderr->_Mode = 0xffff;         /* I[vs̃ANZX֎~     */
    stderr->_Mode |= _MNBF;             /* f[^̃obt@OȂɐݒ */
    stderr->_Bend = stderr->_Buf + 1;   /* obt@ŏI|C^̍Đݒ     */
}

/****************************************************************************/
/* _CLOSEALL                                                                */
/****************************************************************************/
void _CLOSEALL( void )
{
    long i;

    for( i=0; i < _nfiles; i++ )
    {
        /* t@CI[vĂ邩`FbN                              */
        if( _Files[i]->_Mode & (_MOPENR | _MOPENW | _MOPENA ) )
        fclose( _Files[i] );    /* t@CN[Y                    */
    }
}

/**************************************************************************/
/*       open:file open                                                   */
/*          Return value:File number (Pass)                               */
/*                       -1          (Failure)                            */
/**************************************************************************/
long open(const char *name,               /* t@C                   */
     long  mode,                          /* I[v[h               */
     long  flg)                           /* I[vtO               */
{

   
    if( strcmp( name, FPATH_STDIN ) == 0 )      /* W̓t@C       */
    {
        if( ( mode & O_RDONLY ) == 0 ) return -1;
        flmod[STDIN] = mode;
        return STDIN;
    }
    else if( strcmp( name, FPATH_STDOUT ) == 0 )/* Wo̓t@C       */
    {
        if( ( mode & O_WRONLY ) == 0 ) return -1;
        flmod[STDOUT] = mode;
        return STDOUT;
    }
    else if(strcmp(name, FPATH_STDERR ) == 0 )  /* WG[o̓t@C */
    {
        if( ( mode & O_WRONLY ) == 0 ) return -1;
        flmod[STDERR] = mode;
        return STDERR;
    }
    else return -1;                             /*Wo͈ȊÕt@C*/
}

long close( long fileno )
{
    return 1;
}

/**************************************************************************/
/* write:Data write                                                       */
/*  Return value:Number of write characters (Pass)                        */
/*               -1                         (Failure)                     */
/**************************************************************************/
long write(long  fileno,                  /* t@Cԍ                 */
      const unsigned char *buf,           /* ]obt@AhX       */
      long  count)                        /* o               */
{
    long    i;                           /* JEgpϐ                */
    unsigned char    c;                  /* o͕                      */

    /* t@C̃[h`FbNAꕶÂo                       */
    /* op or ǂݍݏopɃI[vĂ邩     */
    if(flmod[fileno]&O_WRONLY || flmod[fileno]&O_RDWR)
    {
        if( fileno == STDIN ) return -1;            /* W           */
        else if( (fileno == STDOUT) || (fileno == STDERR) ) /* Wo   */
        {
            for( i = count; i > 0; --i )
            {
                c = *buf++;
                charput(c);
            }
            return count;                /* oԋpB        */
        }
        else return -1;                  /* t@Co                  */
    }
    else return -1;                      /* G[                        */
}

long read( long fileno, unsigned char *buf, long count )
{
	   long i;

       /* t@Cԍɏ]ă[h`FbNAꕶÂ͂ăobt@Ɋi[ */

       if((flmod[fileno]&_MOPENR) || (flmod[fileno]&O_RDWR)){
             for(i = count; i > 0; i--){
                   *buf = charget();
                   if(*buf==CR){              /* s̒u */
                         *buf = LF;
                   }
                   buf++;
             }
             return count;
       }
       else {
             return -1;
       }
}

long lseek( long fileno, long offset, long base )
{
    return -1L;
}

