/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.moenizer.effect;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeUI;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeUtil;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.effect.Effect;
import org.omegat.util.Log;
import org.omegat.util.gui.UIThreadsUtil;

public class SlideEffect
extends Effect
implements Runnable {
    private final String KEY_TARGET = "target";
    private final String KEY_OPACITY = "opacity";
    private final String KEY_IMAGE = "image";
    private final String KEY_PATHS = "paths";
    private final String KEY_BGCOLOR = "bgColor";
    private final String KEY_EXCLUDE = "exclude";
    private final String KEY_INTERVAL = "interval";
    private MoeUI.Parts target = MoeUI.Parts.MainWindow;
    private float opacity = 0.5f;
    private List<String> images = null;
    private Color bgColor = null;
    private EnumSet<MoeUI.Parts> exclude = null;
    private int intervalInMinutes = 1;
    private int currentImageIndex = 0;
    private MoeUI ui = null;

    public SlideEffect(Map<String, Object> config) {
        Integer rgb;
        this.target = this.get("target", config, this.target);
        if (config.containsKey("image")) {
            Map conf = (Map)config.get("image");
            this.images = this.getImages(this.get("paths", conf, this.images));
            this.opacity = this.get("opacity", conf, Float.valueOf(this.opacity)).floatValue();
        }
        if ((rgb = (Integer)this.get("bgColor", config, null)) != null) {
            this.bgColor = new Color(rgb);
        }
        ArrayList excludeList = new ArrayList();
        this.exclude = this.getExcludeParts(this.get("exclude", config, excludeList));
        this.intervalInMinutes = this.get("interval", config, this.intervalInMinutes);
    }

    @Override
    public void invoke(MoeUI ui, ScheduledThreadPoolExecutor service) {
        if (this.images.isEmpty()) {
            return;
        }
        try {
            ui.setBackground(this.target, this.getImage(this.images.get(0)));
        }
        catch (MalformedURLException ex) {
            Log.log((String)ex.getMessage());
        }
        catch (IOException ex) {
            Log.log((String)ex.getMessage());
        }
        ui.setOpacity(this.target, this.opacity);
        ui.setBackground(this.target, this.bgColor);
        ui.transparent(this.target, this.exclude);
        if (this.images.size() > 1) {
            this.ui = ui;
            service.scheduleAtFixedRate(this, this.intervalInMinutes, this.intervalInMinutes, TimeUnit.MINUTES);
        }
    }

    @Override
    public void run() {
        ++this.currentImageIndex;
        if (this.currentImageIndex >= this.images.size()) {
            this.currentImageIndex = 0;
        }
        UIThreadsUtil.executeInSwingThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    SlideEffect.this.ui.setBackground(SlideEffect.this.target, SlideEffect.this.getImage((String)SlideEffect.this.images.get(SlideEffect.this.currentImageIndex)));
                    SlideEffect.this.ui.repaint();
                }
                catch (MalformedURLException ex) {
                    Log.log((String)ex.getMessage());
                }
                catch (IOException ex) {
                    Log.log((String)ex.getMessage());
                }
            }
        });
    }

    private List<String> getImages(List<String> paths) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String path : paths) {
            String lcased = path.toLowerCase();
            if (lcased.startsWith("http://") || lcased.startsWith("https://")) {
                ret.add(path);
                continue;
            }
            File file = new File(path);
            if (file.isFile()) {
                ret.add(path);
                continue;
            }
            if (!file.isDirectory()) continue;
            try {
                List<String> imagePaths = MoeUtil.collectImagePaths(file);
                ret.addAll(imagePaths);
            }
            catch (IOException ex) {}
        }
        return ret;
    }

    private EnumSet<MoeUI.Parts> getExcludeParts(List<MoeUI.Parts> exclude) {
        EnumSet<MoeUI.Parts> excludeParts = EnumSet.noneOf(MoeUI.Parts.class);
        for (MoeUI.Parts part : EnumSet.allOf(MoeUI.Parts.class)) {
            if (!exclude.contains((Object)part)) continue;
            excludeParts.add(part);
        }
        return excludeParts;
    }

    private BufferedImage getImage(String path) throws IOException {
        String lcased = path.toLowerCase();
        return lcased.startsWith("http://") || lcased.startsWith("https://") ? ImageIO.read(new URL(path)) : ImageIO.read(new File(path));
    }
}

