/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.JComponent;

public class MoeUIDelegator {
    private BufferedImage image = null;
    private BufferedImage tiledImage = null;
    private Color bgColor = null;
    private JComponent component = null;
    private final float DEFAULT_ALPHA = 0.5f;
    private float alpha = 0.5f;
    private AlphaComposite alphaComposite = this.getAlphaComposite(this.alpha);
    private int marginTop = 0;

    public void setOpacity(float opacity) {
        this.alpha = opacity;
        this.alphaComposite = opacity >= 1.0f ? null : this.getAlphaComposite(opacity);
    }

    public void setBackgroundImage(BufferedImage image) {
        this.image = image;
        this.tiledImage = this.component == null ? image : this.createTiledImage(image, this.component.getWidth(), this.component.getHeight());
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = color;
        if (this.component != null) {
            this.component.setBackground(color);
        }
    }

    public BufferedImage getBackgroundImage() {
        return this.image;
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    public void setComponent(JComponent c) {
        if (!c.isOpaque()) {
            c.setOpaque(true);
        }
        if (this.bgColor != null) {
            c.setBackground(this.bgColor);
        }
        this.component = c;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public void paintBackground(Graphics g) {
        if (this.image != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.alphaComposite != null) {
                g2.setComposite(this.alphaComposite);
            }
            if (this.bgColor != null) {
                g2.setBackground(this.bgColor);
            }
            int width = this.component.getWidth();
            int height = this.component.getHeight();
            if (width > this.tiledImage.getWidth() || height > this.tiledImage.getHeight()) {
                this.tiledImage = this.createTiledImage(this.image, width, height);
            }
            g2.drawImage((Image)this.tiledImage, 0, this.marginTop, this.component);
            g2.dispose();
        }
    }

    private AlphaComposite getAlphaComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    private BufferedImage createTiledImage(BufferedImage image, int width, int height) {
        WritableRaster r1 = image.getRaster();
        WritableRaster r2 = r1.createCompatibleWritableRaster(width, height);
        int w = r1.getWidth();
        int h = r1.getHeight();
        for (int x = 0; x < width; x += w) {
            for (int y = 0; y < height; y += h) {
                r2.setRect(x, y, r1);
            }
        }
        BufferedImage ret = new BufferedImage(width, height, image.getType());
        ret.setData(r2);
        return ret;
    }
}

