﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Media.Imaging;
using Microsoft.Win32;

namespace JoinNotes_ExportNotes
{
    /// <summary>
    /// App.xaml の相互作用ロジック
    /// </summary>
    public partial class App : Application
    {
        StringBuilder outstring = new StringBuilder();
        StringWriter writer;
        string title = null;
        bool IsFirstParagraph = true;
        int imageNumber = 0;
        string InputPath { get; set; }
        string OutputPath { get; set; }
        string OutputFilename { get; set; }
        string ResourceDirectoryName { get; set; }
        const string StyleFilename = "style.css";

        private void Application_Startup(object sender, StartupEventArgs e)
        {
            var exitcode = AppMain();
            this.Shutdown(exitcode);
        }

        int AppMain()
        {
            //FIXME: 起動時、標準入力がリダイレクトされていないと異常終了
            //UNDONE: | more などとリダイレクトありで起動させないとConsole.WriteLine()が出力されない
            //TODO: 入力がなければダイアログ表示。ファイル選択（複数）
            //TODO: 起動時のコマンドラインオプションで出力先が与えられていれば、出力先を選択するダイアログを出さない

            try
            {
                try
                {
                    //this.InputPath = Path.Combine(new[]{
                    //    Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments),
                    //    "JoinNotes",
                    //    "Start.join.rtf",
                    //});

                    {
                        if (Console.In is TextReader && Console.In.Peek() == -1)
                        {
                            return 11;
                        }

                        this.InputPath = Console.In.ReadLine();
                    }

                    if (!File.Exists(this.InputPath))
                        return 12;

                    {
                        var dialog = new SaveFileDialog();
                        dialog.AddExtension = true;
                        //dialog.CheckPathExists = true;
                        dialog.OverwritePrompt = true;
                        dialog.DereferenceLinks = true;
                        //dialog.CreatePrompt = true;
                        //FIXME: .join.rtfに対応したものに。
                        dialog.FileName = Path.GetFileNameWithoutExtension(this.InputPath);
                        dialog.DefaultExt = ".html";
                        dialog.Filter = "HTML (.html)|*.html";
                        //FIXME: .join.rtfに対応したものに。
                        //this.OutputPath = Path.ChangeExtension(this.InputPath, ".html");
                        var ret = dialog.ShowDialog();
                        if (ret.HasValue && ret.Value)
                        {
                            this.OutputPath = Path.GetDirectoryName(dialog.FileName);
                            this.OutputFilename = Path.GetFileName(dialog.FileName);
                        }
                        else
                        {
                            this.OutputPath = null;
                            this.OutputFilename = null;
                        }
                    }
                }
                catch (IOException ex)
                {
                    // 標準入力がリダイレクトされていないとき、「ハンドルが無効です」
                    MessageBox.Show(ex.Message + " (" + ex.GetType().Name + ")\n" + ex.Source + "\n" + ex.StackTrace);
                }

                var doc = new FlowDocument();

                // OutputPath\OutputFilename
                // OutputPath\ResourceDirectoryName\StyleFilename

                //FIXME: .join.rtfに対応したものに。
                this.ResourceDirectoryName = Path.GetFileNameWithoutExtension(this.OutputFilename) + ".files";
                Debug.WriteLine(new { this.InputPath, this.OutputPath, this.OutputFilename, this.ResourceDirectoryName, App.StyleFilename }, "AppMain");

                try
                {
                    using (var stream = new FileStream(this.InputPath, FileMode.Open, FileAccess.Read, FileShare.Read))
                    {
                        var range = new TextRange(doc.ContentStart, doc.ContentEnd);
                        range.Load(stream, DataFormats.Rtf);
                    }
                }
                catch (Exception ex)
                {
                    Trace.WriteLine(ex.Message, "* " + ex.Source);
                }

                // pre-scan
                for (var pointer = doc.ContentStart; pointer != null && pointer.CompareTo(doc.ContentEnd) <= 0; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
                {
                    if (pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.ElementStart)
                    {
                        var element = pointer.GetAdjacentElement(LogicalDirection.Forward);
                        if (element is Paragraph)
                        {
                            var paragraph = (Paragraph)element;

                            //FIXME: テキスト化の方法
                            title = new TextRange(paragraph.ContentStart, paragraph.ContentEnd).Text;
                            break;
                        }
                    }
                }

                if (title == null)
                {
                    //FIXME: .join.rtf を取り除くように
                    title = Path.GetFileNameWithoutExtension(this.InputPath);
                }

                if (this.OutputPath == null)
                    return 13;

                {
                    var path = Path.Combine(this.OutputPath, this.ResourceDirectoryName);

                    //FIXME: 古いファイルはごみ箱に入れる
                    if (Directory.Exists(path))
                        Directory.Delete(path, true);

                    Directory.CreateDirectory(path);

                    using (writer = new StringWriter(outstring))
                    {
                        WriteElement(doc);
                    }

                    using (var htmlWriter = new StreamWriter(new FileStream(Path.Combine(this.OutputPath, this.OutputFilename), FileMode.Create)))
                    {
                        htmlWriter.Write(writer.ToString());
                    }
                }

                {
                    // create css
                    var srcPath = Path.GetFullPath(Path.Combine(Path.GetDirectoryName(System.Reflection.Assembly.GetEntryAssembly().Location), App.StyleFilename));
                    var destPath = Path.GetFullPath(Path.Combine(new[] { this.OutputPath, this.ResourceDirectoryName, App.StyleFilename }));
                    //MessageBox.Show("src: " + srcPath + "\ndest: " + destPath);
                    if (srcPath != destPath)
                        File.Copy(srcPath, destPath, true);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message + " (" + ex.GetType().Name + ")\n" + ex.Source + "\n" + ex.StackTrace);
            }

            return 0;
        }

        static HashSet<TextMarkerStyle> OrderedMarkerStyle = new HashSet<TextMarkerStyle> {
            TextMarkerStyle.Decimal,
            TextMarkerStyle.LowerLatin,
            TextMarkerStyle.LowerRoman,
            TextMarkerStyle.UpperLatin,
            TextMarkerStyle.UpperRoman,
        };

        void WriteElement(dynamic unknown)
        {
            Debug.WriteLine(new { unknown.GetType().Name, Hash = unknown.GetHashCode() }, "WriteElement Start\t");

            if (unknown is Run)
            {
                var elem = (Run)unknown;

                this.writer.Write(elem.Text);
            }
            else if (unknown is Span)
            {
                var elem = (Span)unknown;

                ////FIXME: elem.tag: DataFormats.Rtf に残る属性に
                //var tag = elem.Tag as Dictionary<string, object>;
                //if (tag != null && tag.ContainsKey("id") && tag["id"] == "header")
                //{
                //    writer.Write("<header id=\"header\">\n");
                //    writer.Write("<h1>");

                //    foreach (var inline in elem.Inlines)
                //    {
                //        WriteElement(inline);
                //    }

                //    writer.Write("</h1>\n");
                //    writer.Write("</header>\n");
                //}
                //else
                //{
                foreach (var inline in elem.Inlines)
                {
                    WriteElement(inline);
                }
                //}
            }
            else if (unknown is Paragraph)
            {
                var elem = (Paragraph)unknown;

                writer.Write("\n");

                if (IsFirstParagraph)
                {
                    ////FIXME: テキスト化の方法
                    //title = new TextRange(elem.ContentStart, elem.ContentEnd).Text;

                    writer.Write("<header id=\"header\">");
                    writer.Write("<h1>");
                    writer.Write(title);
                    writer.Write("</h1>");
                    writer.Write("</header>\n");

                    IsFirstParagraph = false;
                }
                else if (elem.Inlines.Count >= 1)
                {
                    foreach (var inline in elem.Inlines)
                    {
                        WriteElement(inline);
                    }
                    writer.Write("<br />\n");
                }
            }
            else if (unknown is List)
            {
                var elem = (List)unknown;

                if (OrderedMarkerStyle.Contains(elem.MarkerStyle))
                    writer.Write("<ol>");
                else
                    writer.Write("<ul>");

                foreach (var item in elem.ListItems)
                {
                    writer.Write("<li>");
                    WriteElement(item);
                    writer.Write("</li>\n");
                }

                if (OrderedMarkerStyle.Contains(elem.MarkerStyle))
                    writer.Write("</ol>");
                else
                    writer.Write("</ul>");
            }
            else if (unknown is Image)
            {
                var elem = (Image)unknown;

                // .rtfになった時点でビットマップになっているので、すべて同じ形式で保存していい。

                var filename = "image" + imageNumber.ToString("d4") + ".jpg";
                //var path = "image" + imageNumber.ToString("d4") + ".png";
                //var path = "image" + imageNumber.ToString("d4") + ".bmp";

                imageNumber++;
                //FIXME: 他の画像形式に対応
                using (var stream = new FileStream(Path.Combine(new[] { this.OutputPath, this.ResourceDirectoryName, filename }), FileMode.Create))
                {
                    var encoder = new JpegBitmapEncoder();
                    // encoder.QualityLevel はデフォルトで。画像ごとに90あたりで自動調整される？
                    //encoder.QualityLevel = 100; // 最高品質でも.rtfに埋め込んでいた時より小さい。

                    //TODO: オプションでJPEG/PNG/JPEG品質100を選べるように。デフォルトはJPEGで品質自動調整。

                    //var encoder = new PngBitmapEncoder();
                    //encoder.Interlace = PngInterlaceOption.Default;

                    //var encoder = new BmpBitmapEncoder();

                    encoder.Frames.Add(BitmapFrame.Create((BitmapSource)elem.Source));
                    encoder.Save(stream);
                }

                //FIXME: .join.rtfに対応したものに。
                writer.Write(@"<img src=""" + Uri.EscapeUriString("./" + this.ResourceDirectoryName + "/" + filename) + @"""");
            }
            else if (unknown is FlowDocument)
            {
                var elem = (FlowDocument)unknown;

                writer.Write("<!DOCTYPE html>");
                writer.Write("<html>\n");

                writer.Write("<head>\n");
                writer.Write("<title>" + title + "</title>\n");
                //FIXME: .join.rtfに対応したものに。
                writer.Write(@"<link rel=""stylesheet"" href=""./" + Uri.EscapeUriString(this.ResourceDirectoryName + "/" + App.StyleFilename) + @""">");
                //writer.Write("<script src=\"\">");
                writer.Write("</head>\n");

                writer.Write("<body>\n");

                writer.Write("<div id=\"contents\">\n");
                writer.Write("<article>\n");

                foreach (var block in elem.Blocks)
                {
                    WriteElement(block);
                }

                writer.Write("</article>\n");
                writer.Write("</div>\n");

                writer.Write("</body>\n");
                writer.Write("</html>\n");
            }
            else if (unknown is TextElement)
            {
                writer.Write("<!-- " + unknown.GetType().Name + " -->");

                if (unknown.GetType().GetProperty("Blocks") != null)
                {
                    foreach (var block in unknown.Blocks)
                    {
                        WriteElement(block);
                    }
                }

                if (unknown.GetType().GetProperty("Inlines") != null)
                {
                    foreach (var inline in unknown.Inlines)
                    {
                        WriteElement(inline);
                    }
                }

                if (unknown.GetType().GetProperty("Child") != null)
                {
                    WriteElement(unknown.Child);
                }

                if (unknown.GetType().GetProperty("Children") != null)
                {
                    foreach (var child in unknown.Children)
                    {
                        WriteElement(child);
                    }
                }
            }
            else
            {
                writer.Write("<!-- " + unknown.GetType().Name + " -->");
                Debug.Fail("Unknown Type.");
            }

            Debug.WriteLine(new { unknown.GetType().Name, Hash = unknown.GetHashCode() }, "WriteElement End\t");
        }

    }
}
