/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import groovy.util.ConfigObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeUI;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.effect.Effect;
import org.omegat.util.Log;

public class ThemeChanger {
    private final int THREAD_NUM = 2;
    private final MoeUI model;
    private ConfigObject theme = null;
    private ScheduledThreadPoolExecutor service = null;

    public ThemeChanger(MoeUI ui) {
        this.model = ui;
    }

    public void setTheme(ConfigObject theme) {
        this.theme = theme;
    }

    public void apply() {
        if (this.service != null) {
            this.service.shutdownNow();
            this.service = null;
        }
        if (this.theme == null || !this.theme.containsKey((Object)"effects")) {
            return;
        }
        List effects = (List)this.theme.get((Object)"effects");
        if (effects.isEmpty()) {
            return;
        }
        this.service = new ScheduledThreadPoolExecutor(2);
        for (Map conf : effects) {
            try {
                Effect.Type type = conf.containsKey("type") ? (Effect.Type)((Object)conf.get("type")) : Effect.Type.Basic;
                Effect effect = Effect.create(type, conf);
                effect.invoke(this.model, this.service);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Log.log((String)("Error on ThemeChanger#apply(): " + ex.getMessage()));
            }
        }
    }
}

