/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import com.vlsolutions.swing.docking.DockingDesktop;
import groovy.util.ConfigObject;
import java.util.Set;
import javax.swing.SwingUtilities;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MenuHandler;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeConfig;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeUI;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeUtil;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.ThemeChanger;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.gui.ConfigEditDialog;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.util.Log;

public class Moenizer
implements IApplicationEventListener {
    private static boolean instantiated = false;
    private MoeUI ui;
    private MoeConfig config;
    private ThemeChanger themeChanger;
    private MenuHandler menu;

    public static void loadPlugins() {
        try {
            if (instantiated) {
                throw new RuntimeException("Moenizer plugin could be instantiated only once.");
            }
            if (!Moenizer.isSupportedVLDockingFramework()) {
                throw new RuntimeException("Moenizer plugin is not compatibled with current VLDocking framework library.\nPlease update to OmegaT 3.1.2u1 or later.");
            }
            CoreEvents.registerApplicationEventListener((IApplicationEventListener)new Moenizer());
            instantiated = true;
        }
        catch (Throwable ex) {
            String msg = ex.getMessage();
            Log.logErrorRB((String)"LD_ERROR", (Object[])new Object[]{msg});
            Core.pluginLoadingError((String)msg);
        }
    }

    private static boolean isSupportedVLDockingFramework() {
        return !"2.1.4".equals(DockingDesktop.getDockingFrameworkVersion());
    }

    public static void unloadPlugins() {
    }

    public void onApplicationStartup() {
        try {
            this.config = new MoeConfig(MoeUtil.getMoeConfigFile());
            this.ui = MoeUI.getInstance();
            this.themeChanger = new ThemeChanger(this.ui);
            this.themeChanger.setTheme(this.config.getCurrentConfig());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CoreEvents.unregisterApplicationEventListener((IApplicationEventListener)Moenizer.this);
                    Moenizer.this.themeChanger.apply();
                }
            });
        }
        catch (Exception e) {
            Log.log((String)("Error raised at " + this.getClass().getCanonicalName() + ".onApplicationStartup()\n" + e));
            e.printStackTrace();
        }
    }

    public void onApplicationShutdown() {
    }

    private void showSettingDialog() {
        Set<ConfigObject> sortedConfigs = this.config.getSortedConfigs();
        ConfigEditDialog dialog = new ConfigEditDialog(sortedConfigs, this.themeChanger);
        dialog.setVisible(true);
        this.onConfigUpdate();
    }

    private void onConfigUpdate() {
    }
}

