#!/usr/local/bin/luac53 -p --
--[[
--@brief  Quasi Robot Language; aibrain
--@date   Sun,06 Jul,2014 - Sun,01 Mar,2015
--@date   Tue,18 Aug,2015
--@date   Sun,30 Aug,2015
--@date   Tue,27 Oct,2015
--@date   Sun,13 Dec,2015
--@date   Sat,19 Dec,2015
--@date   Sun,27 Dec,2015
--@date   Fri,18 Aug,2017
--@date   Sun,03 Sep,2017
--@date   Fri,06 Apr,2018
--@date   Sat,07 Apr,2018
--@date   Sat,12 May,2018
--@date   Sun,02 Dec,2018
--@date   Tue,01 Jan,2019
--@date   Sat,23 Mar,2019
--@date   Sat,25 Jan,2020
--@date   Sun,26 Jan,2020
--@date   Tue,07 Apr,2020
--@date   Sat,18 Apr,2020
--@date   Sun,19 Apr,2020
--@date   Wed,22 Apr,2020
--@date   Thu,23 Apr,2020
--@date   Sat,25 Apr,2020
--@date   Tue,28 Apr,2020
--@date   Sun,11 Oct,2020
--@date   Wed,21 Oct,2020
--@date   Fri,11 Mar,2022
--@author Copyright(C)2014-2022 G-HAL
--]]



define_const("Hot_Terr_CHARA_WALK", { [1] =
 2, 3, 4,-1, 2,  2, 3, 3, 4, 5,
 3,-1,-1, 2,-1,  2, 2,-1, 2, 2,
-1,-1,-1,-1, 2,  2,-1, 2,-1, 2,
-1,-1,-1,-1,-1, -1,-1,-1, 2, 4,
 2,-1 });
define_const("Hot_Terr_MECHA_WALK", { [1] =
 2, 3, 4, 5, 2,  2, 3, 3, 4, 5,
 3,-1,-1, 2,-1,  2, 2,-1, 2, 2,
 5, 5,-1,-1, 2,  2,-1, 2,-1, 2,
-1,-1,-1,-1,-1, -1,-1,-1, 2, 4,
 2,-1 });
define_const("Hot_Terr_MECHA_ROLL", { [1] =
 2,-1,-1,-1, 3,  1, 4, 3, 4, 5,
 4,-1,-1, 2,-1,  2, 2,-1, 2, 2,
 5, 5,-1,-1, 2,  2,-1, 2,-1, 2,
-1,-1,-1,-1,-1, -1,-1,-1, 2,-1,
 2,-1 });
define_const("Hot_Terr_MECHA_SKIM", { [1] =
 2, 3, 4, 2, 2,  2, 3, 3, 4, 5,
 2,-1,-1, 2,-1,  2, 2,-1, 2, 2,
 2, 2,-1,-1, 2,  2,-1, 2,-1, 2,
-1,-1,-1,-1,-1, -1,-1,-1, 2, 4,
 2,-1 });
define_const("Hot_Terr_MECHA_FLY" , { [1] =
 2, 2, 2, 2, 2,  2, 2, 2, 2, 2,
 2, 2,-1, 2,-1,  2, 2,-1, 2, 2,
 2, 2,-1,-1, 2,  2,-1, 2,-1, 2,
-1,-1,-1,-1,-1, -1,-1,-1, 2, 2,
 2,-1 });
define_const("Hot_Terr", { Hot_Terr_CHARA_WALK, Hot_Terr_MECHA_WALK, Hot_Terr_MECHA_ROLL, Hot_Terr_MECHA_SKIM, Hot_Terr_MECHA_FLY });
define_const("NumFFMap", 3);
define_const("Hot_Map_Validity", 10);
define_const("Hot_Map_UpperLimit", 9999);

local MapUpdate = {};
local MapTeam = {};
local MapOrder = {};
local MapMoveMode = {};
local HotMap = {};
local ColdMap = {};


function InitMaps()
  local t;
  for t = 1, NumFFMap, 1 do
    MapUpdate[t] = -1;
  end;
  for t = 1, NumFFMap, 1 do
    MapTeam[t] = 0;
  end;
  for t = 1, NumFFMap, 1 do
    MapOrder[t] = 0;
  end;
  for t = 1, NumFFMap, 1 do
    MapMoveMode[t] = 0;
  end;

  local x;
  local y;
  for t = 1, NumFFMap, 1 do
    HotMap[t] = {};
    for x = 1, XMax, 1 do
      HotMap[t][x] = {};
      for y = 1, YMax, 1 do
        HotMap[t][x][y] = 0;
      end;
    end;
  end;
  for t = 1, NumFFMap, 1 do
    ColdMap[t] = {};
    for x = 1, XMax, 1 do
      ColdMap[t][x] = {};
      for y = 1, YMax, 1 do
        ColdMap[t][x][y] = 0;
      end;
    end;
  end;

  InitShadowMap_for_HotMap();
  return;
end;

function ClearHotMaps()
  local t;
  for t = 1, NumFFMap, 1 do
    MapUpdate[ t ] = -1;
  end;
  return;
end;


function HotMapFloodFill(GB, N, MM)
  local function HotTileBlocksLOS(GB, X, Y, MM, terr)
    return TileBlocksLOS_for_HotMap(GB, X, Y, 5) or (Hot_Terr[MM + 1][terr] < 0);
  end;

  local flag = true;
  local X, Y;
  local terr;
  local DV, DH, DD, DP;
  while flag do
    flag = false;
    for Y = 1, YMax, 1 do
      for X = 1, XMax, 1 do
        terr = GB_Map_Terr(GB, X, Y);
        if not HotTileBlocksLOS(GB, X, Y, MM, terr) then
          DH = Hot_Map_UpperLimit;
          if OnTheMap_XY(X - 1, Y) then
            DH = Hot_Terr[MM + 1][terr] + HotMap[N][X - 1][Y];
          end;
          DV = Hot_Map_UpperLimit;
          if OnTheMap_XY(X, Y - 1) then
            DV = Hot_Terr[MM + 1][terr] + HotMap[N][X][Y - 1];
          end;
          if (DV < DH) then
            DH = DV;
          end;
          DD = Hot_Map_UpperLimit;
          if OnTheMap_XY(X - 1, Y - 1) then
            DD = Hot_Terr[MM + 1][terr] + 1 + HotMap[N][X - 1][Y - 1];
          end;
          if (DD < DH) then
            DH = DD;
          end;
          DP = Hot_Map_UpperLimit;
          if OnTheMap_XY(X + 1, Y - 1) then
            DP = Hot_Terr[MM + 1][terr] + 1 + HotMap[N][X + 1][Y - 1];
          end;
          if (DP < DH) then
            DH = DP;
          end;

          if (DH < HotMap[N][X][Y]) then
            HotMap[N][X][Y] = DH;
            flag = true;
          end;
        end;
      end;
    end;

    for Y = YMax, 1, -1 do
      for X = XMax, 1, -1 do
        terr = GB_Map_Terr(GB, X, Y);
        if not HotTileBlocksLOS(GB, X, Y, MM, terr) then
          DH = Hot_Map_UpperLimit;
          if OnTheMap_XY(X + 1, Y) then
            DH = Hot_Terr[MM + 1][terr] + HotMap[N][X + 1][Y];
          end;
          DV = Hot_Map_UpperLimit;
          if OnTheMap_XY(X, Y + 1) then
            DV = Hot_Terr[MM + 1][terr] + HotMap[N][X][Y + 1];
          end;
          if (DV < DH) then
            DH = DV;
          end;
          DD = Hot_Map_UpperLimit;
          if OnTheMap_XY(X + 1, Y + 1) then
            DD = Hot_Terr[MM + 1][terr] + 1 + HotMap[N][X + 1][Y + 1];
          end;
          if (DD < DH) then
            DH = DD;
          end;
          DP = Hot_Map_UpperLimit;
          if OnTheMap_XY(X - 1, Y + 1) then
            DP = Hot_Terr[MM + 1][terr] + 1 + HotMap[N][X - 1][Y + 1];
          end;
          if (DP < DH) then
            DH = DP;
          end;

          if (DH < HotMap[N][X][Y]) then
            HotMap[N][X][Y] = DH;
            flag = true;
          end;
        end;
      end;
    end;
  end;
  return;
end;

function Calc_FollowMap(GB, N, UID, MM)
  local M = GB_Meks(GB);
  local P_X, P_Y, P_Z;
  while (nil ~= M) do
    if (GG_DisposeGear < Mek_G(M)) then
      P_X, P_Y, P_Z = GearCurrentLocation(M);
      if IsMasterGear(M) and OnTheMap_XY(P_X, P_Y) and GearOperational(M) then
        ColdMap[N][P_X][P_Y] = ColdMap[N][P_X][P_Y] + 1;
      elseif (GG_MetaTerrain == Mek_G(M)) and (Mek_Stat(M, STAT_Pass) <= -100) and NotDestroyed(M) then
        ColdMap[N][P_X][P_Y] = ColdMap[N][P_X][P_Y] + 1;
      end;
      if (Mek_NAttValue_EpisodeData(M, NAS_UID) == UID) then
        P_X, P_Y, P_Z = GearCurrentLocation(M);
        if OnTheMap_XY(P_X, P_Y) then
          HotMap[N][P_X][P_Y] = 0;
          HotMapFloodFill(GB, N, MM);
        end;
      end;
    end;
    M = Mek_Next(M);
  end;
  return;
end;

function Calc_SpotMap(GB, N, PDat, MM)
  local M = GB_Meks(GB);
  local P_X, P_Y, P_Z;
  while (nil ~= M) do
    if (GG_DisposeGear < Mek_G(M)) then
      P_X, P_Y, P_Z = GearCurrentLocation(M);
      if IsMasterGear(M) and OnTheMap_XY(P_X, P_Y) and GearOperational(M) then
        ColdMap[N][P_X][P_Y] = ColdMap[N][P_X][P_Y] + 1;
      elseif (GG_MetaTerrain == Mek_G(M)) and (Mek_Stat(M, STAT_Pass) <= -100) and NotDestroyed(M) then
        ColdMap[N][P_X][P_Y] = ColdMap[N][P_X][P_Y] + 1;
      end;
    end;
    M = Mek_Next(M);
  end;

  P_X = PDat % (XMax + 1);
  P_Y = math.floor(PDat / (XMax + 1));
  if OnTheMap_XY(P_X, P_Y) then
    HotMap[N][P_X][P_Y] = 0;
  end;

  MapUpdate[N] = GB_ComTime(GB) + 100;

  HotMapFloodFill(GB, N, MM);
  return;
end;

function Calc_EdgeMap(GB, N, PDat, MM)
  local M = GB_Meks(GB);
  local P_X, P_Y, P_Z;
  while (nil ~= M) do
    if (GG_DisposeGear < Mek_G(M)) then
      P_X, P_Y, P_Z = GearCurrentLocation(M);
      if IsMasterGear(M) and OnTheMap_XY(P_X, P_Y) and GearOperational(M) then
        ColdMap[N][P_X][P_Y] = ColdMap[N][P_X][P_Y] + 1;
      elseif (GG_MetaTerrain == Mek_G(M)) and (Mek_Stat(M, STAT_Pass) <= -100) and NotDestroyed(M) then
        ColdMap[N][P_X][P_Y] = ColdMap[N][P_X][P_Y] + 1;
      end;
    end;
    M = Mek_Next(M);
  end;

  local X;
  for X = 1, XMax, 1 do
    if (-1 == AngDir_Y[PDat + 1]) then
      HotMap[N][X][1] = 0;
    elseif (1 == AngDir_Y[PDat + 1]) then
      HotMap[N][X][YMax] = 0;
    end;
  end;
  local Y;
  for Y = 1, YMax, 1 do
    if (-1 == AngDir_X[PDat + 1]) then
      HotMap[N][1][Y] = 0;
    elseif (1 == AngDir_X[PDat + 1]) then
      HotMap[N][XMax][Y] = 0;
    end;
  end;

  MapUpdate[N] = GB_ComTime(GB) + 100;

  HotMapFloodFill(GB, N, MM);
  return;
end;

function Calc_NearestEdgeMap(GB, N, MM)
  local M = GB_Meks(GB);
  local P_X, P_Y, P_Z;
  while (nil ~= M) do
    if (GG_DisposeGear < Mek_G(M)) then
      P_X, P_Y, P_Z = GearCurrentLocation(M);
      if IsMasterGear(M) and OnTheMap_XY(P_X, P_Y) and GearOperational(M) then
        ColdMap[N][P_X][P_Y] = ColdMap[N][P_X][P_Y] + 1;
      elseif (GG_MetaTerrain == Mek_G(M)) and (Mek_Stat(M, STAT_Pass) <= -100) and NotDestroyed(M) then
        ColdMap[N][P_X][P_Y] = ColdMap[N][P_X][P_Y] + 1;
      end;
    end;
    M = Mek_Next(M);
  end;

  local X;
  for X = 1, XMax, 1 do
    HotMap[N][X][1] = 0;
    HotMap[N][X][YMax] = 0;
  end;
  local Y;
  for Y = 1, YMax, 1 do
    HotMap[N][1][Y] = 0;
    HotMap[N][XMax][Y] = 0;
  end;

  MapUpdate[N] = GB_ComTime(GB) + 100;

  HotMapFloodFill(GB, N, MM);
  return;
end;

function Calc_SDMap(GB, N, Team, MM)
  local M = GB_Meks(GB);
  local P_X, P_Y, P_Z;
  local Flag = true;
  while (nil ~= M) do
    if (GG_DisposeGear < Mek_G(M)) then
      P_X, P_Y, P_Z = GearCurrentLocation(M);
      if IsMasterGear(M) and OnTheMap_XY(P_X, P_Y) and GearOperational(M) then
        ColdMap[N][P_X][P_Y] = ColdMap[N][P_X][P_Y] + 1;
        if TeamCanSeeTarget(GB, Team, M) and AreEnemies_TT(GB, Team, Mek_NAttValue_Location(M, NAS_Team)) then
          HotMap[N][P_X][P_Y] = 0;
          Flag = false;
        end;
      elseif (GG_MetaTerrain == Mek_G(M)) and (Mek_Stat(M, STAT_Pass) <= -100) and NotDestroyed(M) then
        ColdMap[N][P_X][P_Y] = ColdMap[N][P_X][P_Y] + 1;
      end;
    end;
    M = Mek_Next(M);
  end;

  if Flag then
    return;
  end;

  HotMapFloodFill(GB, N, MM);
  return;
end;

function Calc_TeamMap(GB, N, Team, MM)
  local M = GB_Meks(GB);
  local P_X, P_Y, P_Z;
  local Flag = true;
  while (nil ~= M) do
    if (GG_DisposeGear < Mek_G(M)) then
      P_X, P_Y, P_Z = GearCurrentLocation(M);
      if IsMasterGear(M) and OnTheMap_XY(P_X, P_Y) and GearOperational(M) then
        ColdMap[N][P_X][P_Y] = ColdMap[N][P_X][P_Y] + 1;
        if (Team == Mek_NAttValue_Location(M, NAS_Team)) then
          HotMap[N][P_X][P_Y] = 0;
          Flag = false;
        end;
      elseif (GG_MetaTerrain == Mek_G(M)) and (Mek_Stat(M, STAT_Pass) <= -100) and NotDestroyed(M) then
        ColdMap[N][P_X][P_Y] = ColdMap[N][P_X][P_Y] + 1;
      end;
    end;
    M = Mek_Next(M);
  end;

  if Flag then
    return;
  end;

  HotMapFloodFill(GB, N, MM);
  return;
end;


function GetHotMap(GB, Team, MM, O)
  if (MM < 0) then
    return 0;
  end;

  local RepMap = 1;
  local GoodMap = 0;
  local t;
  for t = 1, NumFFMap, 1 do
    if (GB_ComTime(GB) <= MapUpdate[t]) and (Team == MapTeam[t]) and (MM == MapMoveMode[t]) and (O == MapOrder[t]) then
      GoodMap = t;
    end;
    if (MapUpdate[t] < MapUpdate[RepMap]) then
      RepMap = t;
    end;
  end;

  if (0 ~= GoodMap) then
    return GoodMap;
  end;

  local function CalculateHotMap(GB, N, Team, MM, O)
    MapUpdate[N] = GB_ComTime(GB) + Hot_Map_Validity;
    MapTeam[N] = Team;
    MapMoveMode[N] = MM;
    MapOrder[N] = O;

    local X;
    local Y;
    for X = 1, XMax, 1 do
      for Y = 1, YMax, 1 do
        HotMap[N][X][Y] = Hot_Map_UpperLimit;
        ColdMap[N][X][Y] = 0;
      end;
    end;
    UpdateShadowMap_for_General(GB);
    UpdateShadowMap_for_HotMap(GB);

    local switch = {
      default                   = function(GB, N, Team, MM) print('ERROR: CalculateHotMap Failed.'); end;
      [ORD_SeekEnemy + 1]       = function(GB, N, Team, MM) Calc_SDMap(GB, N, Team, MM); end;
      [ORD_SeekSingleModel + 1] = function(GB, N, Team, MM) Calc_FollowMap(GB, N, Team, MM); end;
      [ORD_SeekSpot + 1]        = function(GB, N, Team, MM) Calc_SpotMap(GB, N, Team, MM); end;
      [ORD_SeekEdge + 1]        = function(GB, N, Team, MM) Calc_EdgeMap(GB, N, Team, MM); end;
      [ORD_SeekTeam + 1]        = function(GB, N, Team, MM) Calc_TeamMap(GB, N, Team, MM); end;
      [ORD_SeekNearestEdge + 1] = function(GB, N, Team, MM) Calc_NearestEdgeMap(GB, N, MM); end;
    };
    (switch[O + 1] or switch.default)(GB, N, Team, MM);
    return;
  end;

  CalculateHotMap(GB, RepMap, Team, MM, O);
  return RepMap;
end;

function GetHotMap_XY(GB, X, Y, MM)
  return GetHotMap(GB, X + (Y * (XMax + 1)), MM, ORD_SeekSpot);
end;


function SelectPurgePartsMode(Mek, GB)
  local MaxMode = MaxSeparableMode(Mek);
  if (MaxMode < 1) then
    return;
  end;

  local FindParts;
  local Separable_ModeNum;
  local function CheckPartAlongTrack(P)

    local function CheckParts(P)
      local CurrentDamage = GearCurrentDamage(P);
      local MaxDamage     = GearMaxDamage(P);
      local CurrentArmor  = GearCurrentArmor(P);
      local MaxArmor      = GearMaxArmor(P);

      local it = false;
      local switch = {
        default              = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = true; end;
        [GG_Module + 1]      = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = (CurrentDamage <= math.floor((MaxDamage * 90) / 100)); end;
        [GG_Mecha + 1]       = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_Character + 1]   = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_Cockpit + 1]     = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_Weapon + 1]      = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = true; end;
        [GG_Ammo + 1]        = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = (AmmoPresent(P) <= AmmoSpent(P)); end;
        [GG_MoveSys + 1]     = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_Holder + 1]      = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = true; end;
        [GG_Sensor + 1]      = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_Support + 1]     = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_Shield + 1]      = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = (CurrentArmor <= math.floor((MaxArmor * 90) / 100)); end;
        [GG_ExArmor + 1]     = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = (CurrentArmor <= math.floor((MaxArmor * 90) / 100)); end;
        [GG_Scene + 1]       = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_Swag + 1]        = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_Prop + 1]        = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_MetaTerrain + 1] = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_Electronics + 1] = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_Usable + 1]      = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_RepairFuel + 1]  = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_Consumable + 1]  = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_Modifier + 1]    = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = false; end;
        [GG_WeaponAddOn + 1] = function(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor)    it = true; end;
      };
      (switch[Mek_G(P) + 1] or switch.default)(CurrentDamage, MaxDamage, CurrentArmor, MaxArmor);

      return it;
    end;

    local function CheckPartsAlongTrack(P)
      while (nil ~= P) do
        local P_Next = Mek_Next(P);
        if NotDestroyed(P) then
          if not CheckParts(P) then
            return false;
          end;

          if (GG_Cockpit == Mek_G(P)) then
            if not CheckPartsAlongTrack(Mek_InvCom(P)) then
              return false;
            end;
          else
            if not CheckPartsAlongTrack(Mek_SubCom(P)) then
              return false;
            end;
            if not CheckPartsAlongTrack(Mek_InvCom(P)) then
              return false;
            end;
          end;
        end;
        P = P_Next;
      end;
      return true;
    end;

    while (nil ~= P) do
      local P_Next = Mek_Next(P);
      if NotDestroyed(P) then
        if ("" ~= IsSeparable(P, Separable_ModeNum)) then
          FindParts = true;
          if not CheckParts(P) then
            return false;
          end;
          if not CheckPartsAlongTrack(Mek_SubCom(P)) then
            return false;
          end;
          if not CheckPartsAlongTrack(Mek_InvCom(P)) then
            return false;
          end;
        else
          if (GG_Cockpit == Mek_G(P)) then
            if not CheckPartAlongTrack(Mek_InvCom(P)) then
              return false;
            end;
          else
            if not CheckPartAlongTrack(Mek_SubCom(P)) then
              return false;
            end;
            if not CheckPartAlongTrack(Mek_InvCom(P)) then
              return false;
            end;
          end;
        end;
      end;
      P = P_Next;
    end;
    return true;
  end;

  local SelectMode = 0;
  local t;
  for t = 1, MaxMode, 1 do
    if (0 <= SeparateWait(Mek, t)) then
      FindParts = false;
      Separable_ModeNum = t;
      if CheckPartAlongTrack(Mek_SubCom(Mek)) then
        if FindParts then
          SelectMode = t;
        end;
      end;
    end;
  end;

  if (SelectMode < 1) or (MaxMode < SelectMode) then
    return;
  end;

  g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PurgeParts;
  g_QRL_SystemVariable["ExecQueue_Type_PurgeParts"] = SelectMode;
  return;
end;

function SelectFastestFormMode(Mek, GB)
  local MaxForm = MaxTransformableMode(Mek);
  if (MaxForm < 1) then
    return;
  end;
  local OldForm = Transform_CurrentForm(Mek);
  if (OldForm < 1) then
    return;
  end;
  if not CheckConversionSystem(Mek) then
    return;
  end;

  local MaxSpeed = 0;
  local NewForm = 0;

  local i;
  for i = 1, MaxForm, 1 do
    local WaitTime = TransformWait(Mek, OldForm, i);
    if ((0 < WaitTime) or (OldForm == i)) then
      local FM = TransformGS(Mek, i);
      local j;
      for j = 1, NumMoveMode, 1 do
        local FS = FormSpeedLimit[FM][j];
        if (MaxSpeed < FS) then
          MaxSpeed = FS;
          NewForm = i;
        elseif (MaxSpeed == FS) then
          if (1 == math.random(1,2)) then
            MaxSpeed = FS;
            NewForm = i;
          end;
        end;
      end;
    end;
  end;

  if ((0 < NewForm) and (OldForm ~= NewForm)) then
    g_QRL_SystemVariable["ExecQueue_Type"]                = c_ExecQueue_Type_Transformation;
    g_QRL_SystemVariable["ExecQueue_Type_Transformation"] = NewForm;
  end;
  return;
end;

function SelectHeavyFormMode(Mek, GB)
  local FormVolume = {
    [GS_Battroid + 1]     = 50,
    [GS_Zoanoid + 1]      = 20,
    [GS_GroundHugger + 1] = 20,
    [GS_Arachnoid + 1]    = 20,
    [GS_AeroFighter + 1]  = 20,
    [GS_Ornithoid + 1]    = 20,
    [GS_Gerwalk + 1]      = 50,
    [GS_HoverFighter + 1] = 20,
    [GS_GroundCar + 1]    = 20
  };
  local MaxForm = MaxTransformableMode(Mek);
  if (MaxForm < 1) then
    return;
  end;
  local OldForm = Transform_CurrentForm(Mek);
  if (OldForm < 1) then
    return;
  end;
  if not CheckConversionSystem(Mek) then
    return;
  end;

  local MaxVolume = 0;
  local NewForm = 0;

  for i = 1, MaxForm, 1 do
    local WaitTime = TransformWait(Mek, OldForm, i);
    if ((0 < WaitTime) or (OldForm == i)) then
      local FM = TransformGS(Mek, i);
      local FV = FormVolume[FM + 1];
      if (math.random(1,100) < FV) then
        NewForm = i;
        break;
      end;
    end;
  end;

  if ((0 < NewForm) and (OldForm ~= NewForm)) then
    g_QRL_SystemVariable["ExecQueue_Type"]                = c_ExecQueue_Type_Transformation;
    g_QRL_SystemVariable["ExecQueue_Type_Transformation"] = NewForm;
  end;
  return;
end;

function SelectMoveMode(Mek, GB)
  local T;
  local MM = 0;
  local MaxSpeed = 0;
  for T = 1, NumMoveMode, 1 do
    if (MaxSpeed < BaseMoveRate_withMode(Mek, T)) and MoveLegal_withMode(Mek, T, NAV_NormSpeed, GB_ComTime(GB)) then
      if not ((nil ~= GB) and (Mek_Scale(Mek) < GB_Scale(GB)) and (MM_Fly == T) and (0 < JumpTime(Mek))) then
        MM = T;
        MaxSpeed = BaseMoveRate_withMode(Mek, T);
      end;
    end;
  end;
  if (0 ~= MM) then
    Mek_SetNAtt_Action_MoveMode(Mek, MM);
  end;
  return;
end;


function AttackTargetOfOppurtunity(GB, Mek)
  if (GB_ComTime(GB) < Mek_NAttValue_EpisodeData(Mek, NAS_InitRecharge)) then
    return;
  end;

  local Weapon = nil;
  local BestWeight = -10000;
  local function SeekFarWeapon(Part)
    while (nil ~= Part) do
      if (GG_Module == Mek_G(Part)) or (GG_Weapon == Mek_G(Part)) or (GG_Ammo == Mek_G(Part)) then
        if NeedAmmo(Part) then
          g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"] = g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"] + 1;
          g_QRL_SystemVariable["ExecQueue_Reload_Queue_Weapon"][g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"]] = Part;
          g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ammo"][g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"]] = nil;
        end;
        if ReadyToFire(GB, Mek, Part, true, true, true) then
          if (nil == Weapon) then
            Weapon = Part;
          elseif WeaponRange(GB, Weapon) < WeaponRange(GB, Part) then
            Weapon = Part;
          end;
        end;
      end;
      SeekFarWeapon(Mek_SubCom(Part));
      SeekFarWeapon(Mek_InvCom(Part));
      Part = Mek_Next(Part);
    end;
    return;
  end;
  SeekFarWeapon(Mek_SubCom(Mek));
  SeekFarWeapon(Mek_InvCom(Mek));

  if (nil ~= Weapon) then
    local Target = nil;
    local TL = GB_Meks(GB);

    while (nil ~= TL) do
      if (NotDestroyed(TL) and GearActive(TL) and MekCanSeeTarget(GB, Mek, TL) and OnTheMap_Mek(TL)) then
        if AreEnemies_MM(GB, Mek, TL) then
          if RangeArcCheck_Mek(GB, Mek, Weapon, TL) then
            if (nil == Target) then
              Target = TL;
            elseif (Range_MM(GB, TL, Mek) < Range_MM(GB, Target, Mek)) then
              Target = TL;
            end;
          end;
        end;
      end;
      TL = Mek_Next(TL);
    end;

    if (nil ~= Target) then
      local function SelectBestWeapon(GB, Mek, Target)
        if Destroyed(Mek) then
          return nil;
        end;
        if Destroyed(Target) then
          return nil;
        end;

        local Weapon = nil;
        local BestWeight = -10000;

        local function SeekBigWeapon(Part_arg)
          local Part = Part_arg;
          while (nil ~= Part) do
            if (GG_Module == Mek_G(Part)) or (GG_Weapon == Mek_G(Part)) or (GG_Ammo == Mek_G(Part)) then
              if NeedAmmo(Part) then
                g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"] = g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"] + 1;
                g_QRL_SystemVariable["ExecQueue_Reload_Queue_Weapon"][g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"]] = Part;
                g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ammo"][g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"]] = nil;
              end;
              if ReadyToFire(GB, Mek, Part, true, true, true) and RangeArcCheck_Mek(GB, Mek, Part, Target) and SafeToFire(GB, Mek, Part, Target) then
                if (nil == Weapon) then
                  Weapon = Part;
                  BestWeight = WGoodness(GB, Part, Target);
                else
                  local Weight = WGoodness(GB, Part, Target);
                  if (BestWeight < Weight) then
                    Weapon = Part;
                    BestWeight = Weight;
                  end;
                end;
              end;
            end;
            SeekBigWeapon(Mek_SubCom(Part));
            SeekBigWeapon(Mek_InvCom(Part));
            Part = Mek_Next(Part);
          end;
          return;
        end;

        SeekBigWeapon(Mek_SubCom(Mek));
        SeekBigWeapon(Mek_InvCom(Mek));
        return Weapon;
      end;
      Weapon = SelectBestWeapon(GB, Mek, Target);
      if (nil ~= Weapon) then
        g_QRL_SystemVariable["ExecQueue_Attack_Mode_AIAttacker"] = true;
        g_QRL_SystemVariable["ExecQueue_Attack_Weapon"] = Weapon;
        g_QRL_SystemVariable["ExecQueue_Attack_Target"] = Target;
        g_QRL_SystemVariable["ExecQueue_Attack_AtOp"] = 0;
      end;
    end;
  end;
  return;
end;


function Wander(Mek, GB)
  local P_X, P_Y, P_Z = GearCurrentLocation(Mek);
  local CD = Mek_NAttValue_Location(Mek, NAS_D);
  local P2_X = P_X + AngDir_X[CD + 1];
  local P2_Y = P_Y + AngDir_Y[CD + 1];

  if OnTheMap_XY(P2_X, P2_Y) and (1 ~= math.random(1,5)) and not IsBlocked_for_HotMap(Mek, GB, P2_X, P2_Y) then
    g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
    g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_FullSpeed;
  else
    if (1 == math.random(1,2)) then
      g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
      g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_TurnRight;
    else
      g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
      g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_TurnLeft;
    end;
  end;

  return;
end;

function XMoveTowardsGoal(GB, Mek, HM, OptMax, OptMin)
  local function ThisMoveIsOkay(MAct, X, Y)
    return MoveLegal_CurrentMode(Mek, MAct, GB_ComTime(GB)) and not IsBlocked_for_HotMap(Mek, GB, X, Y);
  end;

  local P_X, P_Y, P_Z = GearCurrentLocation(Mek);
  local CD = Mek_NAttValue_Location(Mek, NAS_D);
  local P2_X = P_X + AngDir_X[CD + 1];
  local P2_Y = P_Y + AngDir_Y[CD + 1];
  if (HotMap[HM][P_X][P_Y] < OptMin) then
    local P3_X = P_X + AngDir_X[(CD + 4) % 8 + 1];
    local P3_Y = P_Y + AngDir_Y[(CD + 4) % 8 + 1];
    if OnTheMap_XY(P3_X, P3_Y) and (HotMap[HM][P_X][P_Y] < HotMap[HM][P3_X][P3_Y]) and ThisMoveIsOkay(NAV_Reverse, P3_X, P3_Y) then
      g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
      g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_Reverse;
      return true;

    elseif OnTheMap_XY(P2_X, P2_Y) and (HotMap[HM][P_X][P_Y] < HotMap[HM][P2_X][P2_Y]) and ThisMoveIsOkay(NAV_NormSpeed, P2_X, P2_Y) then
      g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
      g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_FullSpeed;
      return true;

    else
      local D = -1;
      local Best = HotMap[HM][P_X][P_Y];
      local T;
      for T = 0, 7, 1 do
        local P4_X = P_X + AngDir_X[T + 1];
        local P4_Y = P_Y + AngDir_Y[T + 1];
        if OnTheMap_XY(P4_X, P4_Y) then
          if (Best < HotMap[HM][P4_X][P4_Y]) and (ColdMap[HM][P4_X][P4_Y] < 1) and not IsBlocked_for_HotMap(Mek, GB, P4_X, P4_Y) then
            Best = HotMap[HM][P4_X][P4_Y];
            D = T;
          end;
        end;
      end;

      if (-1 ~= D) then
        if (CD ~= D) then
          local Best_Action = NAV_TurnRight;
          for T = 1, 4, 1 do
            if (((CD + T) % 8) == D) then
              Best_Action = NAV_TurnRight;
            elseif (((CD + 8 - T) % 8) == D) then
              Best_Action = NAV_TurnLeft;
            end;
          end;
          g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
          g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = Best_Action;

        else
          g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
          g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_FullSpeed;
        end;
        return true;

      else
        if (1 == math.random(1,2)) then
          g_QRL_SystemVariable["ExecQueue_Type"] = c_ExecQueue_Type_GearUp;
        end;
        return false;
      end;
    end;

  elseif (HotMap[HM][P_X][P_Y] < OptMax) and ((math.random(1,15) < HotMap[HM][P_X][P_Y]) or IsInCover_for_HotMap(GB, Mek)) then
    local D = -1;
    local Best = HotMap[HM][P_X][P_Y];
    local T;
    for T = 0, 7, 1 do
      local P3_X = P_X + AngDir_X[T + 1];
      local P3_Y = P_Y + AngDir_Y[T + 1];
      if OnTheMap_XY(P3_X, P3_Y) then
        if (HotMap[HM][P3_X][P3_Y] < Best) then
          Best = HotMap[HM][P3_X][P3_Y];
          D = T;
        end;
      end;
    end;

    if (-1 ~= D) then
      if (CD ~= D) then
        local Best_Action = NAV_TurnRight;
        for T = 1, 4, 1 do
          if (((CD + T) % 8) == D) then
            Best_Action = NAV_TurnRight;
          elseif (((CD + 8 - T) % 8 ) == D) then
            Best_Action = NAV_TurnLeft;
          end;
        end;
        g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
        g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = Best_Action;
      else
        g_QRL_SystemVariable["ExecQueue_WaitAMinute"] = ReactionTime(Mek);
      end;
    else
      if (1 == math.random(1,2)) then
        g_QRL_SystemVariable["ExecQueue_Type"] = c_ExecQueue_Type_GearUp;
      end;
      g_QRL_SystemVariable["ExecQueue_WaitAMinute"] = ReactionTime(Mek);
    end;
    return true;

  elseif OnTheMap_XY(P2_X, P2_Y) and (HotMap[HM][P2_X][P2_Y] < HotMap[HM][P_X][P_Y]) and (HotMap[HM][P_X][P_Y] < math.random(1,4)) and not IsBlocked_for_HotMap(Mek, GB, P2_X, P2_Y) then
    if MoveLegal_CurrentMode(Mek, NAV_FullSpeed, GB_ComTime(GB)) then
      g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
      g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_FullSpeed;
    elseif MoveLegal_CurrentMode(Mek, NAV_NormSpeed, GB_ComTime(GB)) then
      g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
      g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_NormSpeed;
    else
      return false;
    end;
    return true;

  else
    local D = -1;
    local Best = HotMap[HM][P_X][P_Y];
    local T;
    for T = 0, 7, 1 do
      local P3_X = P_X + AngDir_X[T + 1];
      local P3_Y = P_Y + AngDir_Y[T + 1];
      if OnTheMap_XY(P3_X, P3_Y) then
        if (HotMap[HM][P3_X][P3_Y] < Best) and (ColdMap[HM][P3_X][P3_Y] < 1) and not IsBlocked_for_HotMap(Mek, GB, P3_X, P3_Y) then
          Best = HotMap[HM][P3_X][P3_Y];
          D = T;
        end;
      end;
    end;

    if (-1 ~= D) then
      if (CD ~= D) then
        local Best_Action = NAV_TurnRight;
        for T = 1, 4, 1 do
          if (((CD + T) % 8) == D) then
            Best_Action = NAV_TurnRight;
          elseif (((CD + 8 - T) % 8) == D) then
            Best_Action = NAV_TurnLeft;
          end;
        end;
        g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
        g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = Best_Action;

      else
        if IsBlocked_for_HotMap(Mek, GB, P2_X, P2_Y) then
          return false;
        elseif (math.floor(OptMax * 3 / 2) < HotMap[HM][P_X][P_Y]) and MoveLegal_CurrentMode(Mek, NAV_FullSpeed, GB_ComTime(GB)) then
          g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
          g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_FullSpeed;
        elseif MoveLegal_CurrentMode(Mek, NAV_NormSpeed, GB_ComTime(GB)) then
          g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
          g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_NormSpeed;
        else
          return false;
        end;
      end;
      return true;

    else
      if (1 == math.random(1,2)) then
        g_QRL_SystemVariable["ExecQueue_Type"] = c_ExecQueue_Type_GearUp;
      end;
      return false;
    end;
  end;
end;

function MoveTowardsGoal(GB, Mek, HM)
  if not XMoveTowardsGoal(GB, Mek, HM, 0, 0) then
    Wander(Mek, GB);
  end;
  return;
end;

function MillAround(GB, Mek)
  if (1 == math.random(1, 3)) then
    g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
    g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_Stop;
  elseif (1 == math.random(1,3)) then
    local P_X, P_Y, P_Z = GearCurrentLocation(Mek);
    local D = Mek_NAttValue_Location(Mek, NAS_D);
    local P2_X = P_X + AngDir_X[D + 1];
    local P2_Y = P_Y + AngDir_Y[D + 1];
    if OnTheMap_XY(P2_X, P2_Y) then
      if IsBlocked_for_HotMap(Mek, GB, P2_X, P2_Y) or DoorPresent(GB, P2_X, P2_Y) then
        g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
        g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_Stop;
      else
        g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
        g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_NormSpeed;
      end;
    end;
  else
    if (1 == math.random(1,2)) then
      g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
      g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_TurnRight;
    else
      g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
      g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_TurnLeft;
    end;
  end;
  return;
end;

function FleeFromGoal(GB, Mek, HM)
  local P_X, P_Y, P_Z = GearCurrentLocation(Mek);

  local CD = Mek_NAttValue_Location(Mek, NAS_D);
  local P2_X = P_X + AngDir_X[CD + 1];
  local P2_Y = P_Y + AngDir_Y[CD + 1];

  if OnTheMap_XY(P2_X, P2_Y) and (HotMap[HM][P_X][P_Y] < HotMap[HM][P2_X][P2_Y]) and (math.random(1,8) < HotMap[HM][P_X][P_Y]) and not IsBlocked_for_HotMap(Mek, GB, P2_X, P2_Y) then
    g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
    g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_NormSpeed;

  else
    local Best = HotMap[HM][P_X][P_Y];
    local D = -1;
    local t;
    for t = 0, 7, 1 do
      local P3_X = P_X + AngDir_X[T + 1];
      local P3_Y = P_Y + AngDir_Y[T + 1];
      if OnTheMap_XY(P3_X, P3_Y) then
        if (Best < HotMap[HM][P3_X][P3_Y]) and (ColdMap[HM][P3_X][P3_Y] < 1) then
          Best = HotMap[HM][P3_X][P3_Y];
          D = t;
        end;
      end;
    end;

    if (-1 ~= D) then
      if (CD ~= D) then
        local Best = NAV_TurnRight;
        local t;
        for t = 1, 4, 1 do
          if (((CD + t) % 8) == D) then
            Best = NAV_TurnRight;
          elseif (((CD + 8 - t) % 8) == D) then
            Best = NAV_TurnLeft;
          end;
        end;
        g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
        g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = Best;

      else
        g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
        g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_NormSpeed;
      end;
    else
      MillAround(GB, Mek);
    end;
  end;

  return;
end;

function HotMoveMode(Mek)
  return Mek_NAttValue_Action(Mek, NAS_MoveMode);
end;

function LancemateUsefulAction(Mek, GB)

  local function SelectRepairTarget(GB, Mek, Skill)
    local T = GB_Meks(GB);
    local BTar = nil;
    local Best = 0;

    while (nil ~= T) do
      if NotDestroyed(T) then
        if AreAllies_MM(GB, Mek, T) then
          local Dmg = TotalRepairableDamage(T, Skill);
          if (Best < Dmg) then
            BTar = T;
            Best = Dmg;
          end;
        end;
      end;
      T = Mek_Next(T);
    end;
    return BTar;
  end;

  local function SelectSocialTarget(GB, NPC, MustBeSexy)
    local M = GB_Meks(GB);
    local Team = Mek_NAttValue_Location(NPC, NAS_Team);

    local function IsGoodSocTarget()
      if (0 == Mek_NAttValue_Personal(NPC, NAS_CID)) or (Team == Mek_NAttValue_Location(M, NAS_Team)) or (NAV_DefPlayerTeam == Mek_NAttValue_Location(M, NAS_Team)) then
        return false;
      elseif MustBeSexy then
        return (GearActive(M) and (not AreEnemies_MM(GB, NPC, M)) and IsSexy(NPC, M));
      else
        return (GearActive(M) and (not AreEnemies_MM(GB, NPC, M)));
      end;
    end;

    local N = 0;
    while (nil ~= M) do
      if NotDestroyed(M) then
        if IsGoodSocTarget() then
          N = N + 1;
        end;
      end;
      M = Mek_Next(M);
    end;

    local Target = nil;
    if (0 < N) then
      M = GB_Meks(GB);
      N = math.random(1,N);
      while (nil ~= M) do
        if NotDestroyed(M) then
          if IsGoodSocTarget() then
            N = N - 1;
            if (-1 == N) then
              Target = M;
            end;
          end;
        end;
        M = Mek_Next(M);
      end;
    end;
    return Target;
  end;


  local CORD = Mek_NAttValue_EpisodeData(Mek, NAS_ContinuousOrders);
  if (CORD < 0) then
    local Target = Mek_NAttValue_EpisodeData(Mek, NAS_ATarget);
    local TGear = LocateMekByUID(GB, Target);
    local NPC = LocatePilot(Mek);
    local MekRepairFuel = 0;
    local PilotRepairFuel = 0;
    if (nil ~= Mek) and (Mek ~= NPC) then
      if (nil ~= SeekGear(Mek, GG_RepairFuel, (- CORD))) then
        MekRepairFuel = 1;
      end;
    end;
    if (nil ~= NPC) then
      if (nil ~= SeekGear(NPC, GG_RepairFuel, (- CORD))) then
        PilotRepairFuel = 1;
      end;
    end;
    local TotalRepairFuel = MekRepairFuel + PilotRepairFuel;

    if (nil == TGear) or (TotalRepairableDamage(TGear, (- CORD)) < 1) or (TotalRepairFuel <= 0) or (CharCurrentMental(Mek) < 1) then
      Mek_SetNAtt_EpisodeData(Mek, NAS_ContinuousOrders, 0);

    elseif OnTheMap_Mek(TGear) then
      if (3 < Range_MM(GB, Mek, TGear)) then
        local HM = GetHotMap(GB, Target, HotMoveMode(Mek), ORD_SeekSingleModel);
        MoveTowardsGoal(GB, Mek, HM);
      else
        g_QRL_SystemVariable["ExecQueue_Type"]               = c_ExecQueue_Type_Repair;
        g_QRL_SystemVariable["ExecQueue_Type_Repair_Target"] = TGear;
        g_QRL_SystemVariable["ExecQueue_Type_Repair_Limit"]  = -1;
        g_QRL_SystemVariable["ExecQueue_Type_Repair_Skill"]  = - CORD;
      end;

    else
      g_QRL_SystemVariable["ExecQueue_Type"]               = c_ExecQueue_Type_Repair;
      g_QRL_SystemVariable["ExecQueue_Type_Repair_Target"] = TGear;
      g_QRL_SystemVariable["ExecQueue_Type_Repair_Limit"]  = -1;
      g_QRL_SystemVariable["ExecQueue_Type_Repair_Skill"]  = - CORD;
    end;

  elseif (CORD_Flirt == CORD) then
    local Target = Mek_NAttValue_EpisodeData(Mek, NAS_ATarget);
    local TGear = LocateMekByUID(GB, Target);

    if (nil == TGear) or AreEnemies_MM(GB, Mek, TGear) or (Destroyed(TGear)) then
      Mek_SetNAtt_EpisodeData(Mek, NAS_ContinuousOrders, 0);

    elseif OnTheMap_Mek(TGear) then
      if (3 < Range_MM(GB, Mek, TGear)) then
        local HM = GetHotMap(GB, Target, HotMoveMode(Mek), ORD_SeekSingleModel);
        if not XMoveTowardsGoal(GB, Mek, HM, 0, 0) then
          Mek_SetNAtt_EpisodeData(Mek, NAS_ContinuousOrders, 0);
        end;
      else
        NPC_Flirtation(GB, Mek, TGear);
        g_QRL_SystemVariable["ExecQueue_WaitAMinute"] = ReactionTime(Mek) * 5;
        Mek_SetNAtt_EpisodeData(Mek, NAS_ContinuousOrders, 0);
      end;

    else
      Mek_SetNAtt_EpisodeData(Mek, NAS_ContinuousOrders, 0);
    end;

  elseif (CORD_Chat == CORD) then
    local Target = Mek_NAttValue_EpisodeData(Mek, NAS_ATarget);
    local TGear = LocateMekByUID(GB, Target);

    if (nil == TGear) or AreEnemies_MM(GB, Mek, TGear) or (Destroyed(TGear)) then
      Mek_SetNAtt_EpisodeData(Mek, NAS_ContinuousOrders, 0);

    elseif OnTheMap_Mek(TGear) then
      if (3 < Range_MM(GB, Mek, TGear)) then
        local HM = GetHotMap(GB, Target, HotMoveMode(Mek), ORD_SeekSingleModel);
        if not XMoveTowardsGoal(GB, Mek, HM, 0, 0) then
          Mek_SetNAtt_EpisodeData(Mek, NAS_ContinuousOrders, 0);
        end;
      else
        NPC_Chatting(GB, Mek, TGear);
        g_QRL_SystemVariable["ExecQueue_WaitAMinute"] = ReactionTime(Mek) * 5;
        Mek_SetNAtt_EpisodeData(Mek, NAS_ContinuousOrders, 0);
      end;

    else
      Mek_SetNAtt_EpisodeData(Mek, NAS_ContinuousOrders, 0);
    end;

  else
    local NPC = LocatePilot(Mek);

    local Target = 0;
    local CORD = 0;
    if (0 < CharCurrentMental(NPC)) then -- BUG? Origin: if (0 < CharCurrentMental(Mek)) then
      local Num_AI_Repair = 5;
      local AI_Repair_List = { 16, 20, 23, 15, 22 };
      local t = 1;
      while (t <= Num_AI_Repair) and (0 == Target) do
        local MekRepairFuel = 0;
        local PilotRepairFuel = 0;
        if (nil ~= Mek) and (Mek ~= NPC) then
          if (nil ~= SeekGear(Mek, GG_RepairFuel, AI_Repair_List[t])) then
            MekRepairFuel = 1;
          end;
        end;
        if (nil ~= NPC) then
          if (nil ~= SeekGear(NPC, GG_RepairFuel, AI_Repair_List[t])) then
            PilotRepairFuel = 1;
          end;
        end;
        local TotalRepairFuel = MekRepairFuel + PilotRepairFuel;

        if (0 < Mek_NAttValue_Skill(NPC, AI_Repair_List[t])) and (0 < TotalRepairFuel) then
          local TGear = SelectRepairTarget(GB, Mek, AI_Repair_List[t]);
          if (nil ~= TGear) then
            Target = Mek_NAttValue_EpisodeData(TGear, NAS_UID);
            CORD = - AI_Repair_List[t];
          end;
        end;
        t = t + 1;
      end;
    end;

    if (0 == CORD) and (math.random(1,10) < Mek_NAttValue_Skill(NPC, 27)) and (1 == math.random(1,3)) and IsSafeArea(GB) then
      local TGear = SelectSocialTarget(GB, NPC, true);
      if (nil ~= TGear) then
        Target = Mek_NAttValue_EpisodeData(TGear, NAS_UID);
        CORD = CORD_Flirt;
      end;
    end;
    if (0 == CORD) and (math.random(1,10) < Mek_NAttValue_Skill(NPC, 19)) and (1 == math.random(1, 3)) and IsSafeArea(GB) then
      local TGear = SelectSocialTarget(GB, NPC, false);
      if (nil ~= TGear) then
        Target = Mek_NAttValue_EpisodeData(TGear, NAS_UID);
        CORD = CORD_Chat;
      end;
    end;

    if (0 ~= CORD) then
      Mek_SetNAtt_EpisodeData(Mek, NAS_ContinuousOrders, CORD);
      Mek_SetNAtt_EpisodeData(Mek, NAS_ATarget, Target);
    else
      local HM = GetHotMap(GB, NAV_DefPlayerTeam, HotMoveMode(Mek), ORD_SeekTeam);
      if not XMoveTowardsGoal(GB, Mek, HM, 5, 10) then
        Wander(Mek, GB);
      end;
    end;
  end;
  return;
end;


function Seek_And_Destroy(Mek, GB)
  if (1 == math.random(1,3)) then
    SelectMoveMode(Mek, GB);
  end;
  local HM = GetHotMap(GB, Mek_NAttValue_Location(Mek, NAS_Team), HotMoveMode(Mek), ORD_SeekEnemy);

  local N1 = 0;
  local N2 = 0;
  local D1 = 1;
  local D2 = 1;
  local function GetOptimumRange()

    local function CheckOptimumRange(Part)
      while (nil ~= Part) do
        if NotDestroyed(Part) then
          if NeedAmmo(Part) then
            g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"] = g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"] + 1;
            g_QRL_SystemVariable["ExecQueue_Reload_Queue_Weapon"][g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"]] = Part;
            g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ammo"][g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"]] = nil;
          end;
          if ReadyToFire(GB, Mek, Part, true, true, true) then
            if (GG_Module == Mek_G(Part)) then
              local Dmg = WeaponDC(Part, 0);
              D1 = D1 + math.floor(Dmg / 2);
            elseif (GG_Weapon == Mek_G(Part)) then
              local Dmg = WeaponDC(Part, 0);
              local Rng = WeaponRange(GB, Part);
              if (Rng < 2) then
                D1 = D1 + math.floor(Dmg / 2);
                D2 = D2 + Dmg * 6;
              elseif (Rng < 18) then
                N1 = N1 + (Rng * 2 * Dmg);
                N2 = N2 + math.floor(Rng * Dmg / 3);
                D1 = D1 + Dmg;
                D2 = D2 + Dmg;
              else
                N1 = N1 + (Rng * 2 * Dmg);
                D1 = D1 + Dmg;
                N2 = N2 + (Rng * Dmg);
                D2 = D2 + Dmg;
              end;
            elseif (GG_Ammo == Mek_G(Part)) then
              local Dmg = WeaponDC(Part, 0);
              D1 = D1 + math.floor(Dmg / 2);
            end;
          end;
          CheckOptimumRange(Mek_SubCom(Part));
          CheckOptimumRange(Mek_InvCom(Part));
        end;
        Part = Mek_Next(Part);
      end;
      return;
    end;

    local NPC = LocatePilot(Mek);

    if (nil ~= NPC) and (0 ~= Mek_NAttValue_Personal(NPC, NAS_OptMax)) then
      N1 = Mek_NAttValue_Personal(NPC, NAS_OptMax);
      N2 = Mek_NAttValue_Personal(NPC, NAS_OptMin);
    else
      CheckOptimumRange(Mek_SubCom(Mek));
    end;
    return;
  end;

  GetOptimumRange();
  if not XMoveTowardsGoal(GB, Mek, HM, math.floor(N1 / D1), math.floor(N2 / D2)) then
    if (NAV_LancemateTeam == Mek_NAttValue_Location(Mek, NAS_Team)) then
      LancemateUsefulAction(Mek, GB);
    else
      Wander(Mek, GB);
    end;
  else
    if (Mek_NAttValue_EpisodeData(Mek, NAS_ChatterRecharge) < GB_ComTime(GB)) and (1 == math.random(1,50)) then
      NPC_CombatTaunt(GB, Mek, "CHAT_ATTACK");
    end;
  end;

  AttackTargetOfOppurtunity(GB, Mek);

  if (1 == math.random(1,10)) then
    local function CheckToFire(Mek,GB)
      local Weapon;
      local function SeekFarWeapon(Part)
        while (nil ~= Part) do
          if (GG_Module == Mek_G(Part)) or (GG_Weapon == Mek_G(Part)) or (GG_Ammo == Mek_G(Part)) then
            if NeedAmmo(Part) then
              g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"] = g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"] + 1;
              g_QRL_SystemVariable["ExecQueue_Reload_Queue_Weapon"][g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"]] = Part;
              g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ammo"][g_QRL_SystemVariable["ExecQueue_Reload_Queue_Ptr"]] = nil;
            end;
            if ReadyToFire(GB, Mek, Part, false, true, false) then
              if (nil == Weapon) then
                Weapon = Part;
              elseif (WeaponRange(GB, Weapon) < WeaponRange(GB, Part)) then
                Weapon = Part;
              end;
            end;
          end;
          SeekFarWeapon(Mek_SubCom(Part));
          SeekFarWeapon(Mek_InvCom(Part));
          Part = Mek_Next(Part);
        end;
        return;
      end;

      Weapon = nil;
      SeekFarWeapon(Mek_SubCom(Mek));
      SeekFarWeapon(Mek_InvCom(Mek));
      if (nil == Weapon) then
        return false;
      end;

      local Target = nil;
      local TL = GB_Meks(GB);

      while (nil ~= TL) do
        if (NotDestroyed(TL) and GearActive(TL) and MekCanSeeTarget(GB, Mek, TL) and OnTheMap_Mek(TL)) then
          if AreEnemies_MM(GB, Mek, TL) then
            if RangeCheck_Mek(GB, Mek, Weapon, TL) then
              Target = TL;
              break;
            end;
          end;
        end;
        TL = Mek_Next(TL);
      end;

      if (nil == Target) then
        return false;
      end;
      return true;
    end;

    if CheckToFire(Mek, GB) then
      SelectHeavyFormMode(Mek, GB);
    else
      SelectPurgePartsMode(Mek, GB);
      SelectFastestFormMode(Mek, GB);
    end;
  end;
  return;
end;


function SetNewOrders(GB, Mek)
  local TG = LocateTeam_GB(GB, Mek_NAttValue_Location(Mek, NAS_Team));

  if (nil ~= TG) then
    Mek_SetNAtt_EpisodeData(Mek, NAS_Orders, TeamOrders(TG));
  else
    Mek_SetNAtt_EpisodeData(Mek, NAS_Orders, NAV_SeekAndDestroy);
  end;
  return;
end;


function GOTO_SPOT(Mek, GB)
  local X = Mek_NAttValue_Location(Mek, NAS_X);
  local Y = Mek_NAttValue_Location(Mek, NAS_Y);
  local GX = Mek_NAttValue_Location(Mek, NAS_GX);
  local GY = Mek_NAttValue_Location(Mek, NAS_GY);

  if (1 == math.random(1,3)) then
    SelectPurgePartsMode(Mek, GB);
    SelectFastestFormMode(Mek, GB);
    SelectMoveMode(Mek, GB);
  end;

  if (GX == X) and (GY == Y) then
    SetNewOrders(GB, Mek);
  else
    local HM = GetHotMap_XY(GB, GX, GY, HotMoveMode(Mek));
    MoveTowardsGoal(GB, Mek, HM);

    AttackTargetOfOppurtunity(GB, Mek);
  end;

  return;
end;

function GOTO_EDGE(Mek, GB)
  local Edge = Mek_NAttValue_EpisodeData(Mek, NAS_ATarget);

  if (1 == math.random(1,2)) then
    SelectPurgePartsMode(Mek, GB);
    SelectFastestFormMode(Mek, GB);
    SelectMoveMode(Mek, GB);
  end;

  local HM = GetHotMap(GB, Edge, HotMoveMode(Mek), ORD_SeekEdge);
  MoveTowardsGoal(GB, Mek, HM);

  AttackTargetOfOppurtunity(GB, Mek);

  return;
end;

function PASSIVE(Mek, GB)
  local HM = GetHotMap(GB, Mek_NAttValue_Location(Mek, NAS_Team), HotMoveMode(Mek), ORD_SeekEnemy);
  FleeFromGoal(GB, Mek, HM);
  return;
end;

function RUNAWAY(Mek, GB)
  if ForwardMoveBlocked_for_HotMap(Mek, GB) then
    SelectPurgePartsMode(Mek, GB);
    SelectFastestFormMode(Mek, GB);
    SelectMoveMode(Mek, GB);

    if (1 == math.random(1,2)) then
      g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
      g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_TurnRight;
    else
      g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
      g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_TurnLeft;
    end;
  else
    g_QRL_SystemVariable["ExecQueue_Type"]            = c_ExecQueue_Type_PrepAction;
    g_QRL_SystemVariable["ExecQueue_Type_PrepAction"] = NAV_FullSpeed;
  end;

  return;
end;

function FOLLOW(Mek, GB)
  local UID = Mek_NAttValue_EpisodeData(Mek, NAS_ATarget);
  local HM = GetHotMap(GB, UID, HotMoveMode(Mek), ORD_SeekSingleModel);
  MoveTowardsGoal(GB, Mek, HM);

  AttackTargetOfOppurtunity(GB, Mek);

  return;
end;

function ShouldEject(Mek, GB)
  local Dmg = PercentDamaged(Mek);
  local PrevDmg = (100 - Mek_NAttValue_EpisodeData(Mek, NAS_PrevDamage));
  Mek_SetNAtt_EpisodeData(Mek, NAS_PrevDamage, (100 - Dmg));

  if AreEnemies_TT(GB, Mek_NAttValue_Location(Mek, NAS_Team), NAV_DefPlayerTeam) and (Dmg < 75) and (Dmg < PrevDmg) then
    local Intimidation = TeamSkill(GB, NAV_DefPlayerTeam, 28);
    if (0 == BaseMoveRate_CurrentMode(Mek)) then
      Dmg = (Dmg - RollStep(Intimidation) - RollStep(Intimidation));
    end;
    return Dmg < (math.random(1,45) + RollStep(Intimidation) - RollStep(SkillValue(Mek,28)));
  elseif AreAllies_TT(GB, Mek_NAttValue_Location(Mek, NAS_Team), NAV_DefPlayerTeam) and (Dmg < 75) and (Dmg < PrevDmg) then
    local Intimidation = TeamSkill(GB, NAV_DefPlayerTeam, 39);
    if (0 == BaseMoveRate_CurrentMode(Mek)) then
      Dmg = Dmg - 25;
    end;
    return Dmg < (math.random(1,60) - RollStep(Intimidation));
  else
    return false;
  end;
end;

-- [ End of File ]
