/*
   This file is released into the public domain with no copyright.
*/

#ifndef ZLIB_H
#define ZLIB_H

#include "miniz.h"
#include <stdint.h>
#include <stddef.h>
#define OF(args)  args

#define Z_BINARY   0
#define Z_TEXT     1
#define Z_ASCII    Z_TEXT   /* for compatibility with 1.2.2 and earlier */
#define Z_UNKNOWN  2

#ifndef z_off_t
#  define z_off_t long
#endif

#ifndef ZEXPORT
#  define ZEXPORT MINIZ_EXPORT
#endif

typedef uint32_t z_crc_t;
typedef size_t z_size_t;
#define z_off64_t int64_t

const z_crc_t* ZEXPORT get_crc_table();

#endif // ZLIB_H
