// Copyright (C) Mocchi (mocchi_2003@yahoo.co.jp)
// License: Boost Software License   See LICENSE.txt for the full license.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Drawing;
using System.Windows.Forms;

static class Program{
	/// ==============
	///    {
	/// ==============
	/// <summary>
	/// OXgɂāAȌd𒲂ׁAdĂ閼OɂĂ͘AԂӂ蒼B
	/// </summary>
	/// <param name="nameList">OXg</param>
	/// <param name="renamableBegin">AԂӂ蒼Ώۂ̊JnCfbNX</param>
	/// <param name="renamableEnd">AԂӂ蒼Ώۂ̏ICfbNX</param>
	/// <returns></returns>
	static public int[] ResolveDuplicateName(string[] nameList, int renamableBegin, int renamableEnd) {
		int begin = 0, end = nameList.Length;

		// [1] ȌdJEg
		// Key:̘AԂc܂܂̖OA Value:dJEg
		var orgNameDuplicateCount = new Dictionary<string, int>();
		for (int i = begin; i < end; ++i) {
			var name = nameList[i];
			if (string.IsNullOrEmpty(name)) continue;
			int cnt = 0;
			if (!orgNameDuplicateCount.TryGetValue(name, out cnt)) {
				orgNameDuplicateCount.Add(name, 1);
			} else {
				orgNameDuplicateCount[name] = cnt + 1;
			}
		}

		// [2] O疖̘AԕOA̘AԂOOɘAԂ̍ől擾
		// [3] ̘AԕOÕXg쐬
		// Key:̘AԂOOA Value:Ăԍ̍ől 
		var wnNameMaxNumber = new Dictionary<string, int>();
		var wnNames = new string[end - begin];
		for (int i = begin; i < end; ++i) {
			var nameWithoutNumber = "";
			var name = nameList[i];
			if (string.IsNullOrEmpty(name)) continue;
			int suffixNumber = -1;
			var lastPeriodIndex = name.LastIndexOf('.');
			if (lastPeriodIndex > 0) {
				nameWithoutNumber = name.Substring(0, lastPeriodIndex);
				var suffix = name.Substring(lastPeriodIndex + 1);
				int num;
				if (int.TryParse(suffix, out num) && num >= 0) {
					suffixNumber = num;
				}
			} else {
				nameWithoutNumber = name;
				suffixNumber = -1;
			}
			wnNames[i - begin] = nameWithoutNumber;
			int lastMaxNumber = -1;
			if (!wnNameMaxNumber.TryGetValue(nameWithoutNumber, out lastMaxNumber)) {
				wnNameMaxNumber.Add(nameWithoutNumber, suffixNumber);
			} else {
				if (lastMaxNumber == -1 && suffixNumber == -1) suffixNumber = 0;
				if (lastMaxNumber < suffixNumber) wnNameMaxNumber[nameWithoutNumber] = suffixNumber;
			}
		}

		// [4] dĂ閼OɘAԂӂ蒼ďdB
		// [5] AԂӂ蒼vfCfbNXL^B
		var resolved = new List<int>();
		if (renamableBegin < begin) renamableBegin = begin;
		if (renamableEnd > end) renamableEnd = end;
		for (int i = renamableBegin; i < renamableEnd; ++i) {
			var name = nameList[i];
			if (string.IsNullOrEmpty(name)) continue;
			if (name[name.Length - 1] == '.') name = name.Substring(0, name.Length - 1);
			bool nameNumberless = (name == wnNames[i - begin]);

			// ɘAԂĂȂȌꍇ́AAԂĂ̂Əd肷B
			// ɘAԂĂ閼Ȍꍇ́AdĂȂΖOύXsvB
			if (!nameNumberless && orgNameDuplicateCount[name] == 1) continue;

			var nameWithoutNumber = wnNames[i - begin];
			int maxNumber;
			if (!wnNameMaxNumber.TryGetValue(nameWithoutNumber, out maxNumber)) continue;
			if (nameNumberless && maxNumber == -1) continue;
			nameList[i] = string.Format("{0}.{1}", nameWithoutNumber, maxNumber + 1);
			resolved.Add(i);
			wnNameMaxNumber[nameWithoutNumber] = maxNumber + 1;
		}
		return resolved.ToArray();
	}

	/// ==============
	///     gp
	/// ==============
	[STAThread]
	static void Main() {
		var form1 = new Form();
		var label1 = new Label();
		var listView1 = new ListView();
		var button1 = new Button();
		var textBox1 = new TextBox();
		#region ʃCAEg
		form1.Size = new Size(350, 450);
		label1.Text = "_uNbNŃl[";
		label1.Width = 160;
		label1.Dock = System.Windows.Forms.DockStyle.Bottom;
		textBox1.ReadOnly = false;
		textBox1.AutoSize = false;
		textBox1.Width = 160;
		textBox1.Height = 370;
		textBox1.Multiline = true;
		textBox1.Dock = System.Windows.Forms.DockStyle.Fill;
		listView1.Width = 160;
		listView1.Height = 370;
		listView1.View = View.List;
		listView1.LabelEdit = true;
		listView1.Dock = System.Windows.Forms.DockStyle.Fill;
		button1.Text = "NbNō̃Xgɒǉ";
		button1.Dock = System.Windows.Forms.DockStyle.Left;
		button1.Width = 160;
		var tableLayoutPanel1 = new TableLayoutPanel();
		tableLayoutPanel1.ColumnCount = 2;
		tableLayoutPanel1.RowCount = 2;
		tableLayoutPanel1.Controls.Add(label1, 0, 0);
		tableLayoutPanel1.Controls.Add(button1, 1, 0);
		tableLayoutPanel1.Controls.Add(listView1, 0, 1);
		tableLayoutPanel1.Controls.Add(textBox1, 1, 1);
		tableLayoutPanel1.Dock = System.Windows.Forms.DockStyle.Fill;
		form1.Controls.Add(tableLayoutPanel1);
		#endregion

		// vfĂ
		var listViewItems = new string[] {
			"Item.1", "Item.2", "Hello", "World"
		};
		foreach (var itm in listViewItems) {
			listView1.Items.Add(itm);
		}
		textBox1.Lines = new string[] { "Item.1", "Hello", "Item.2", "Item.3", "Item" };

		Func<string[]> GetNameList = () => {
			var lines = new List<string>();
			foreach (ListViewItem itm in listView1.Items) {
				lines.Add(itm.Text);
			}
			return lines.ToArray();
		};

		// Xgvf_uNbNɕҏW\ɂB
		listView1.DoubleClick += (object sender, EventArgs e) => {
			var cnt = listView1.SelectedIndices.Count;
			if (cnt == 0) return;
			var itm = listView1.SelectedItems[cnt - 1];
			itm.BeginEdit();
		};
		// XgvfҏWIɖOd`FbNAdĂƂ͘AԂӂ蒼B
		listView1.AfterLabelEdit += (object sender, LabelEditEventArgs e) => {
			e.CancelEdit = true;
			if (e.Label == null) return;
			var nameList = GetNameList();
			nameList[e.Item] = e.Label;
			var resolvedIndices = ResolveDuplicateName(nameList, e.Item, e.Item+1);
			if (resolvedIndices.Length == 0) {
				e.CancelEdit = false;
			} else {
				foreach (var idx in resolvedIndices) {
					listView1.Items[idx].Text = nameList[idx];
				}
			}
		};

		// ẼeLXg{bNX̓eXgɈꊇŒǉB
		// ǉvfdĂƂ͘AԂӂ蒼B
		button1.Click += (object sender, EventArgs e) =>{
			int prevCount = listView1.Items.Count;
			foreach(var line in textBox1.Lines) {
				listView1.Items.Add(line);
			}

			var nameList = GetNameList();

			var resolvedIndices = ResolveDuplicateName(nameList, prevCount, nameList.Length);
			foreach (var idx in resolvedIndices) {
				listView1.Items[idx].Text = nameList[idx];
			}
		};
		Application.Run(form1);
	}
}

