/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 *  Copyright (C) 2008-2010 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *	RX610 UARTpVAI/OW[
 */
#include <kernel.h>
#include <sil.h>
#include "frk_rx62n.h"
#include "target_serial.h"

/*
 *  SIOhCȍ
 */
void
sio_initialize(intptr_t exinf)
{
	rx600_uart_initialize();
}

static const uint8_t baudrate_setting[] =
{
	UART_BAUDRATE0 ,
	UART_BAUDRATE1 ,
	UART_BAUDRATE2
};

static const uint8_t tx_intno[] = 
{
	INT_SCI0_TEI , 
	INT_SCI1_TEI , 
	INT_SCI2_TEI
};

static const uint8_t rx_intno[] = 
{
	INT_SCI0_RXI , 
	INT_SCI1_RXI , 
	INT_SCI2_RXI
};


/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
sio_opn_por(ID siopid, intptr_t exinf)
{
	SIOPCB  *p_siopcb = NULL;
	ER      ercd;
	
	/*
	 *  VAI/O݂}XND
	 */
	ercd = dis_int(tx_intno[siopid - 1]);
	assert(ercd == E_OK);
	ercd = dis_int(rx_intno[siopid - 1]);
	assert(ercd == E_OK);
	
	p_siopcb = 
		rx600_uart_opn_por(siopid , exinf , baudrate_setting[siopid - 1] , UART_CLKSRC);

	/*
	 *  VAI/O݂}XND
	 */
	ercd = ena_int(tx_intno[siopid - 1]);
	assert(ercd == E_OK);
	ercd = ena_int(rx_intno[siopid - 1]);
	assert(ercd == E_OK);

	return(p_siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
sio_cls_por(SIOPCB *p_siopcb)
{
	ER        ercd;

	/*
	 *  foCXˑ̃N[YD
	 */
	rx600_uart_cls_por(p_siopcb);
	
	/*
	 *  VAI/O݂}XND
	 */
	ercd = dis_int(INTNO_SIO_TX);
	assert(ercd == E_OK);
	ercd = dis_int(INTNO_SIO_RX);
	assert(ercd == E_OK);
}

/*
 *  SIO̊݃nh
 */
void sio_tx_isr(intptr_t exinf)
{
	rx600_uart_tx_isr(exinf);
}

/*
 *  SIO̊݃nh
 */
void sio_rx_isr(intptr_t exinf)
{
	rx600_uart_rx_isr(exinf);
}

/*
 *  VAI/O|[gւ̕M
 */
bool_t
sio_snd_chr(SIOPCB *siopcb, char c)
{
	return(rx600_uart_snd_chr(siopcb, c));
}

/*
 *  VAI/O|[g̕M
 */
int_t
sio_rcv_chr(SIOPCB *siopcb)
{
	return(rx600_uart_rcv_chr(siopcb));
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
sio_ena_cbr(SIOPCB *siopcb, uint_t cbrtn)
{
	rx600_uart_ena_cbr(siopcb, cbrtn);
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
sio_dis_cbr(SIOPCB *siopcb, uint_t cbrtn)
{
	rx600_uart_dis_cbr(siopcb, cbrtn);
}

/*
 *  VAI/O|[g̑M\R[obN
 */
void
rx600_uart_irdy_snd(intptr_t exinf)
{
	/* ʕisyssvc\serial.cjɂsio_irdy_snd֐Ăяo*/
	sio_irdy_snd(exinf);
}

/*
 *  VAI/O|[g̎MʒmR[obN
 */
void
rx600_uart_irdy_rcv(intptr_t exinf)
{
	/* ʕisyssvc\serial.cjɂsio_irdy_rcv֐Ăяo*/
	sio_irdy_rcv(exinf);
}

