/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

#ifndef TOPPERS_TARGET_CONFIG_H
#define TOPPERS_TARGET_CONFIG_H

/*
 * ^[QbgˑW[iCQ-STARMpj
 *
 * J[l̃^[Qbgˑ̃CN[ht@CDkernel_impl.h̃^[
 * Qbgˑ̈ʒutƂȂD
 */

/*
 * ^[QbgVXẽn[hEFA̒`
 */
#include "cq_starm.h"

/*
 *  g[XOɊւݒ
 */
#ifdef TOPPERS_ENABLE_TRACE
#include "logtrace/trace_config.h"
#endif /* TOPPERS_ENABLE_TRACE */

/*
 *  ftHg̔^XNReLXgp̃X^bN̈̒`
 *  8bytePʂŎ擾D 
 */
#define DEFAULT_ISTKSZ			(0x1000/8U)		/* 4KByte */

/*
 *  ԑ҂̂߂̒`i{SIL̃^[Qbgˑj
 */
#define SIL_DLY_TIM1    162
#define SIL_DLY_TIM2    100


/*
 * CQ-STARMpIDLE̒`
 *
 * TXyhOpenOCDfobOc[gȂȂ̑Ή
 * WFIŃTXyhĂvOɑ΂āCtbVROM
 * ݂oȂȂ邽߁CIDELύXD
 */
#define TOPPERS_CUSTOM_IDEL
#define toppers_asm_custom_idle		\
	msr		basepri, r0;			\
	msr		basepri, r1;



#ifndef TOPPERS_MACRO_ONLY

/*
 *  ^[QbgVXeˑ̏
 */
extern void	target_initialize(void);

/*
 *  ^[QbgVXȅI
 *
 *  VXeI鎞ɎgD
 */
extern void	target_exit(void) NoReturn;

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  `bvˑW[iARM-Mpj
 */
#include "arm_m_gcc/prc_config.h"

#endif /* TOPPERS_TARGET_CONFIG_H */
