/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008-2010 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *		vZbTˑW[iRX600V[Ypj
 *
 *  ̃CN[ht@ĆCtarget_config.hi܂́CCN
 *  [ht@Cĵ݂CN[hD̃t@C
 *  ڃCN[hĂ͂ȂȂD
 */

#ifndef TOPPERS_PRC_CONFIG_H
#define TOPPERS_PRC_CONFIG_H

#ifndef TOPPERS_MACRO_ONLY

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#include "prc_insn.h"
#include "interrupt.h"


/*
 *  ^XNReLXgp̃X^bNl
 */

#define TOPPERS_ISTKPT( istk, istksz ) (( STK_T * )(( char * )( istk ) + ( istksz )))


/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	void	*sp;		/* X^bN|C^ */
	FP		pc;			/* vOJE^ */
} TSKCTXB;


/*
 *  ݔ񐔂ۑϐ
 */
extern uint16_t intnest;


/*
 *  CPUbNԂł̊ݗDx}XN
 *
 *  TIPM_LOCḰCCPUbNԂł̊ݗDx}XNCȂ킿CJ[l
 *  ǗÔׂ̂Ă̊ݗv}XNlɒ`D
 *
 *  TMIN_INTPRIύX邱ƂŊǗO݂̗L肷D
 *  ႦTMIN_INTPRI-6ɐݒ肷ƁCx7݂̊J[lǗO
 *  ȂDTMIN_INTPRI-7ɐݒ肷ƁCNMIȊOɃJ[lǗO݂̊
 *  ݂ȂƂɂȂȉꍇɂ-7ɐݒ肷邱Ƃ𐄏jD
 */
#ifndef TIPM_LOCK
#define TIPM_LOCK	TMIN_INTPRI
#endif /* TIPM_LOCK */


/*
 *  TOPPERSWݏf̎
 */
/*
 *  ReLXg̎Q
 *
 *  RXł́C݂̖߂悪^XNǂ𔻒f邽߂ intnest
 *  gpĂDpăReLXg𔻒fD
 */
Inline bool_t
sense_context( void )
{
	/*  lXgJE^0Ȃ^XNReLXg  */
	return ( intnest > 0U );
}


/*
 *  CPUbNtÔ߂̕ϐ
 *
 *  ̕ϐ́CCPUbNԂ̎̂ݏĂ悢̂ƂD
 */
#if TIPM_LOCK != -7
extern bool_t	lock_flag;		/* CPUbNtO̒lێϐ */
extern uint32_t	saved_ipl;		/* ݗDxxۑϐ */
#endif	/* TIPM_LOCK != -7	*/

#endif /* TOPPERS_MACRO_ONLY */


/*
 *  ݗDx}XN̊O\Ɠ\̕ϊ
 *
 *  RX610ł́CvZbTXe[^X[hWX^iPSWj̉
 *  24`26rbgڂ3rbgɊݗDxxiIPLjuĂD
 *  J[lǗO݂ꍇIPLgpsD
 *  J[l͊ݗDx}XNi-1A̒ljŊǗ
 *  邽IPLƂ̕ϊKvƂȂD
 */
#define IPL_TO_IPM( ipl )	(-(( PRI )(( ipl ) >> 24U )))		/* IPLIPM	*/
#define IPM_TO_IPL( ipm )	((( uint32_t )(-( ipm ))) << 24U )	/* IPMIPL	*/


/*
 *  CPUbNԂł̊ݗDx}XNIPL
 */
#define IPL_LOCK		( IPM_TO_IPL( TIPM_LOCK ) )

/*
 *  TIPM_ENAALLiݗDx}XNSjIPL
 */
#define IPL_ENAALL		( IPM_TO_IPL( TIPM_ENAALL ) )


#ifndef TOPPERS_MACRO_ONLY

/*
 *  ݗṽx & `e[u
 *  (ev[gt@Cɂo)
 */
typedef struct cfg_int_info {
	PRI		intpri;
	ATR		intatr;
} CFG_INT_INFO;

extern const CFG_INT_INFO cfg_int_table[];


/*
 *  ݔԍ͈̔͂̔
 *
 *  ݔԍLȒlɃ`FbN邽,
 *  RtBM[^o̓e[uQƂ.
 */
#define VALID_INTNO( intno )	\
 				( cfg_int_table[( intno )].intpri > 0 )
#define VALID_INTNO_DISINT( intno )	VALID_INTNO( intno )
#define VALID_INTNO_CFGINT( intno )	VALID_INTNO( intno )


/*
 *  ݐ䃌WX^֘A̒`
 */
#define	IRQ_POSEDGE			( 0x08U )
#define	IRQ_NEGEDGE			( 0x04U )
#define	IRQ_BOTHEDGE		( 0x0CU )
#define	IRQ_LOWLEVEL		( 0x00U )


/*
 *  CPUbNԂւ̈ڍs
 *
 *  IPMin[hEFÅݗDx}XNjCsaved_iipmɕۑCJ[
 *  lǗÔׂ̂Ă̊ݗv}XNliTIPM_LOCKj
 *  ɐݒ肷D܂Clock_flagTRUEɂD
 *
 *  IPMCŏTIPM_LOCKƓ荂ꍇɂ́C
 *  saved_iipmɕۑ݂̂ŁCTIPM_LOCKɂ͐ݒ肵ȂD́Cf
 *  ̊ݗDx}XNCTIPM_LOCKƓ荂xɐݒ
 *  ĂԂɂD
 *
 *  ̊֐́CCPUbNԁilock_flagTRUȄԁjŌĂ΂邱Ƃ
 *  Ȃ̂Ƒz肵ĂD
 */
Inline void
x_lock_cpu( void )
{
#if TIPM_LOCK == -7
	disint();
#else	/* TIPM_LOCK == -7	*/
	uint32_t	ipl;

	/*
	 *  current_ipl()̕Ԃl𒼐saved_iplɕۑCꎞϐipl
	 *  pĂ̂́Ccurrent_ipl()Ă񂾒Ɋ݂C
	 *  Nꂽݏsaved_iplύX\邽߂
	 *  D
	 */
	ipl = current_ipl();
	if( IPL_LOCK > ipl ){
		set_ipl( IPL_LOCK );
	}

	saved_ipl = ipl;
	lock_flag = true;
#endif	/* TIPM_LOCK == -7	*/
}

#define t_lock_cpu()	x_lock_cpu()
#define i_lock_cpu()	x_lock_cpu()


/*
 *  CPUbNԂ̉
 *
 *  lock_flagFALSEɂCIPMin[hEFÅݗDx}XNjC
 *  saved_iipmɕۑlɖ߂D
 *
 *  ̊֐́CCPUbNԁilock_flagtruȅԁjł̂݌Ă΂
 *  ̂Ƒz肵ĂD
 */
Inline void
x_unlock_cpu( void )
{
#if TIPM_LOCK == -7
	enaint();
#else	/* TIPM_LOCK == -7	*/
	lock_flag = false;
	set_ipl( saved_ipl );
#endif	/* TIPM_LOCK == -7	*/
}

#define t_unlock_cpu()	x_unlock_cpu()
#define i_unlock_cpu()	x_unlock_cpu()


/*
 *  CPUbNԂ̎Q
 */
Inline bool_t
x_sense_lock( void )
{
#if TIPM_LOCK == -7
	return (( bool_t )(( current_psw() & PSW_I_MASK) == 0 ));
#else	/* TIPM_LOCK == -7	*/
	return lock_flag;
#endif	/* TIPM_LOCK == -7	*/
}

#define t_sense_lock()	x_sense_lock()
#define i_sense_lock()	x_sense_lock()


/*
 * if́jݗDx}XN̐ݒ
 *
 *  CPUbNtONAĂ鎞́Cn[hEFÅݗDx}
 *  XNݒ肷DCPUbNtOZbgĂ鎞́Csaved_iipm
 *  ݒ肵CɁCn[hEFÅݗDx}XNCݒ肵悤
 *  if́jݗDx}XNTIPM_LOCK̍ɐݒ肷D
 */
Inline void
x_set_ipm( PRI intpri )
{
	uint32_t	ipl = IPM_TO_IPL( intpri );
#if TIPM_LOCK == -7
	set_ipl(ipl);
#else	/* TIPM_LOCK == -7	*/
	if( !lock_flag ){
		set_ipl(ipl);
	}
	else {
		saved_ipl = ipl;
		set_ipl(ipl > IPL_LOCK ? ipl : IPL_LOCK);
    }
#endif	/* TIPM_LOCK == -7	*/
}

#define t_set_ipm( intpri )	x_set_ipm( intpri )
#define i_set_ipm( intpri )	x_set_ipm( intpri )


/*
 * if́jݗDx}XN̎Q
 *
 *  CPUbNtONAĂ鎞̓n[hEFÅݗDx}
 *  XNCZbgĂ鎞saved_iipmQƂD
 */
Inline PRI
x_get_ipm( void )
{
	uint32_t	ipl;
#if TIPM_LOCK == -7
	ipl = current_ipl();
#else	/* TIPM_LOCK == -7	*/
	if (!lock_flag) {
		ipl = current_ipl();
	}
	else {
		ipl = saved_ipl;
	}
#endif	/* TIPM_LOCK == -7	*/
	return IPL_TO_IPM( ipl );
}

#define t_get_ipm()		x_get_ipm()
#define i_get_ipm()		x_get_ipm()


/*
 *  ݗv֎~tÕZbg
 *
 *  ݑݒ肳ĂȂݗvCɑ΂Ċݗv֎~
 *  tOZbg悤Ƃꍇɂ́CFALSEԂD
 */
Inline bool_t
x_disable_int( INTNO intno )
{
	/*
	 *  x`0łꍇCFG_INTĂȂ
	 */
	if( cfg_int_table[intno].intpri == 0 ){
		return ( false );
	}

	*ier_reg_addr[intno].addr &= ( ~ier_reg_addr[intno].offset );

	return ( true );
}

#define t_disable_int( intno )	x_disable_int( intno )
#define i_disable_int( intno )	x_disable_int( intno )


/*
 *  ݗv֎~tÕNA
 *
 *  ݑݒ肳ĂȂݗvCɑ΂Ċݗv֎~
 *  tONA悤Ƃꍇɂ́CFALSEԂD
 */
Inline bool_t
x_enable_int( INTNO intno )
{
	/*
	 *  x`0łꍇCFG_INTĂȂ
	 */
	if( cfg_int_table[intno].intpri == 0 ){
		return ( false );
	}

	*ier_reg_addr[intno].addr |= ier_reg_addr[intno].offset;

	return ( true );
}

#define t_enable_int( intno )	x_enable_int( intno )
#define i_enable_int( intno )	x_enable_int( intno )


/*
 *  ݗṽNA
 */
Inline void
x_clear_int( INTNO intno )
{
	*IR_REG(intno) = 0U;
}

#define t_clear_int( intno )	x_clear_int( intno )
#define i_clear_int( intno )	x_clear_int( intno )


/*
 *  ݗṽ`FbN
 */
Inline bool_t
x_probe_int( INTNO intno )
{
	/*
	 *  ݗvWX^0 or 1łȂ,
	 *  ̂܂܂̒lԂ.
	 */
	return ( *IR_REG(intno) );
}

#define t_probe_int( intno )	x_probe_int( intno )
#define i_probe_int( intno )	x_probe_int( intno )


/*
 *  ݗvC̑̐ݒ
 */
extern void	x_config_int( INTNO intno, ATR intatr, PRI intpri );


/*
 *  ݃nh̓ŕKvIRC
 *
 */
Inline void
i_begin_int( INTNO intno )
{
	volatile uint8_t	reg;

	/*
	 *  xo݂̊ɑ΂Ă͊݃Xe[^X
	 *  tONA.
	 */
	if( ( cfg_int_table[intno].intatr & TA_LOWLEVEL ) > 0 ){
		if( *IR_REG(intno) > 0U ){
			/*
			 *  Ȍ݂ꍇ, IRQ[qHighɖ߂Ă
			 *  ƂmF|LڂĂ邪, ȗ.
			 */
		//	*ir_reg_addr[intno] = 0U;

			/*
			 *  n[hEFA}jA0ɂȂƂ
			 *  mF|Lڂ邽, WX^lǂݏo.
			 */
		//	reg = *ir_reg_addr[intno];
		}
	}
}


/*
 *  ݃nh̏oŕKvIRC
 *
 */
Inline void
i_end_int( INTNO intno )
{
	/* ɍsׂ͂Ȃ */
}


/*
 *  ōD揇ʃ^XNւ̃fBXpb`iprc_support.a30j
 *
 *  dispatch́C^XNReLXgĂяoꂽT[rXR[
 *  ĂяôׂŁC^XNReLXgECPUbNԁEfBXpb
 *  `ԁEif́jݗDx}XNSԂŌĂяo
 *  ΂ȂȂD
 */
extern void	dispatch( void );

/*
 *  fBXpb`̓Jniprc_support.a30j
 *
 *  start_dispatch́CJ[lNɌĂяôׂŁCׂĂ̊
 *  ݂֎~ԁiS݃bNԂƓ̏ԁjŌĂяoȂ
 *  ȂȂD
 */
extern void	start_dispatch( void ) NoReturn;

/*
 *  ݂̃ReLXĝĂăfBXpb`iprc_support.a30j
 *
 *  exit_and_dispatch́Cext_tskĂяôׂŁC^XNReL
 *  XgECPUbNԁEfBXpb`ԁEif́jݗD
 *  x}XNSԂŌĂяoȂ΂ȂȂD
 */
#define _kernel_exit_and_dispatch();	\
	_exit_and_dispatch();		\
	ercd = E_SYS;

extern void	_exit_and_dispatch( void ) NoReturn;

/*
 *  J[l̏Ǐďoiprc_support.a30j
 *
 *  call_exit_kerneĺCJ[l̏IɌĂяôׂŁC^XN
 *  ReLXgɐ؂芷āCJ[l̏Iiexit_kerneljĂяo
 *  D
 */
extern void call_exit_kernel( void ) NoReturn;

/*
 *  ^XNReLXg̏
 *
 *  ^XNx~ԂsłԂɈڍs鎞ɌĂ΂D̎_
 *  ŃX^bN̈gĂ͂ȂȂD
 *
 *  activate_contextCCC֐ł͂Ȃ}N`ƂĂ̂́C
 *  ̎_łTCB`ĂȂ߂łD
 */
extern void	start_r( void );

#define activate_context( p_tcb )														\
{																						\
	{																					\
																						\
		/*  X^bN|C^l̐ݒ  */											\
		( p_tcb )->tskctxb.sp = ( void * )((( uint32_t ) ( p_tcb )->p_tinib->stk ) + 	\
								( p_tcb )->p_tinib->stksz );							\
		/* NԒn̐ݒ */															\
		( p_tcb )->tskctxb.pc = ( FP ) start_r;											\
	}																					\
}


/*
 *  calltex͎gpȂ
 */
#define OMIT_CALLTEX


/*
 *  ݃nh̐ݒ
 *
 *  RX610ROMɊ݃xN^zu邽߁C{֐͋֐ŎD
 */
Inline void
x_define_inh( INHNO inhno, FP inthdr )
{
}


/*
 *  CPUOnh̐ݒ
 *
 *  RX610ROMɗOxN^zu邽߁C{֐͋֐ŎD
 */
Inline void
x_define_exc( EXCNO excno, FP exchdr )
{
}


/*
 *  /Onh̓̐}N
 *
 *  ev[gt@Cɂ萶邽ߋ}NƂD
 */
#define HDR_ENTRY(hdr, intexc_num , tobejmp)

/*
 *  ݃nh̓̐}N
 */
#define _INT_ENTRY(inhno, inthdr)				_kernel_##inthdr##_##inhno##_entry
#define INT_ENTRY(inhno, inthdr)				_INT_ENTRY(inhno , inthdr)

#define _INTHDR_ENTRY(inhno, inhno_num ,inthdr)	\
		extern _kernel_##inthdr##_##inhno##_entry(void);
#define INTHDR_ENTRY(inhno, inhno_num ,inthdr)	_INTHDR_ENTRY(inhno, inhno_num ,inthdr)


/*
 *  CPUOnh̓̐}N
 */
#define _EXC_ENTRY(excno , exchdr)					_kernel_##exchdr##_##excno##_entry
#define EXC_ENTRY(excno , exchdr)					_EXC_ENTRY(excno , exchdr)

#define _EXCHDR_ENTRY(excno , excno_num , exchdr)	\
		extern _kernel_##exchdr##_##excno##_entry(void);
#define EXCHDR_ENTRY(excno , excno_num , exchdr)	_EXCHDR_ENTRY(excno , excno_num , exchdr)


/*
 *  CPUO̔̃ReLXg̎Q
 *
 *  CPUO̔̃ReLXgC^XNReLXg̎FALSEC
 *  łȂtrueԂD
 */
Inline bool_t
exc_sense_context( void *p_excinf )
{
	/* 
	 *  lXgJE^1Ȃ^XNReLXg
	 */
	return( intnest > 1U );
}


/*
 *  CPUO p_excinf  PSW ̒l擾邽߂̃ItZbgl
 *  EXCNO + ACC + FPSW + R1`R15 + PC
 */
#define EXC_GET_PSW_OFFSET	(4+8+4+60+4)

/*
 *  CPUO̔IPL̎Q
 */
Inline uint32_t
exc_get_ipl(void *p_excinf)
{
	return((*((uint32_t *)((uintptr_t)p_excinf+EXC_GET_PSW_OFFSET)))
			& PSW_IPL_MASK);
}

Inline bool_t
exc_sense_i(void *p_excinf)
{
	return((*(((uint32_t *)((uintptr_t)p_excinf+EXC_GET_PSW_OFFSET)))
			 & PSW_I_MASK) != 0u);
}


/*
 *  CPUO̔̃ReLXgƊ݂̃}XNԂ̎Q
 *
 *  CPUO̔̃VXeԂCJ[lsłȂC^XNR
 *  eLXgłCS݃bNԂłȂCCPUbNԂłȂCi
 *  f́jݗDx}XNSԂł鎞trueCłȂ
 *  FALSEԂiCPUOJ[lǗO̊ݏŔꍇ
 *  ɂFALSEԂjD
 *  
 *  J[lsłȂ (TIPM_LOCK== -7) ItO == 1
 *                         (else)           IPL < IPL_LOCK
 *  ^XNReLXgł遨intnest == 0
 *  S݃bNłȂ ItO == 1
 *  ݗDx}XNSIPL == 0
 *  
 *  
 */
Inline bool_t
exc_sense_intmask(void *p_excinf)
{
	return((!exc_sense_context(p_excinf))
			&& exc_sense_i(p_excinf)
			&& (exc_get_ipl(p_excinf) == IPL_ENAALL));
}

/*
 *  CPUO̔̃ReLXgƊ݁^CPUbNԂ̎Q
 *
 *  CPUO̔̃VXeԂCJ[lsłȂC^XNR
 *  eLXgłCS݃bNԂłȂCCPUbNԂłȂ
 *  trueCłȂfalseԂiCPUOJ[lǗO̊ݏ
 *  ŔꍇɂfalseԂjD
 *  
 *  J[lsłȂ (TIPM_LOCK== -7) ItO == 1
 *                         (else)           IPL < TIPM_LOCK
 *  ^XNReLXgł遨intnest < 1 
 *  S݃bNłȂ ItO == 1
 *  CPUbNԂłȂ(TIPM_LOCK== -7) ItO == 1
 *                         (else)           IPL < TIPM_LOCK
 */
Inline bool_t
exc_sense_unlock(void *p_excinf)
{
#if TIPM_LOCK == -7
	return((!exc_sense_context(p_excinf))
			&& exc_sense_i(p_excinf));
#else
	return((!exc_sense_context(p_excinf))
			&& exc_sense_i(p_excinf)
			&& exc_get_ipl(p_excinf) < IPL_LOCK);
#endif
}

Inline void
idle_loop(void)
{
	t_unlock_cpu();
	t_lock_cpu();
}

/*
 *  vZbTˑ̏
 */
extern void	prc_initialize( void );

/*
 *  vZbTˑ̏I
 */
extern void	prc_terminate( void );


#ifndef OMIT_DEFAULT_INT_HANDLER
/*
 *  o^݂̊ꍇɌĂяo
 */
void default_int_handler( void );
#endif /* OMIT_DEFAULT_INT_HANDLER */

#ifndef OMIT_DEFAULT_EXC_HANDLER
/*
 *  o^̗OꍇɌĂяo
 */
void default_exc_handler( void );
#endif /* OMIT_DEFAULT_EXC_HANDLER */


#endif /* TOPPERS_MACRO_ONLY */

#endif /* TOPPERS_PRC_CONFIG_H */

