/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008-2010 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *		vZbTˑW[iRX600V[Ypj
 */

#include "kernel_impl.h"


/*
 *  ݔ񐔂ۑϐ
 */
uint16_t	intnest;

/*
 *  CPUbNtÔ߂̕ϐ
 */
#if TIPM_LOCK != -7
bool_t		lock_flag;		/* CPUbNtO̒lێϐ */
uint32_t	saved_ipl;		/* ݗDxxۑϐ */
#endif	/* TIPM_LOCK != -7	*/


/*
 *  vZbTˑ̏
 */
void
prc_initialize( void )
{
	/*
	 *  ݔ񐔂̏
	 *
	 *  X^[gAbv͑S݃bN & ^XNReLXg
	 *  ɂē삷邽, ^XNReLXgɋU.
	 */
	intnest = 1U;

#if TIPM_LOCK != -7
	/*
	 *  CPUbNtÔ߂̕ϐ̏
	 */
	lock_flag = true;
	saved_ipl = IPL_ENAALL;
#endif	/* TIPM_LOCK != -7	*/
}


/*
 *  vZbTˑ̏I
 */
void
prc_terminate( void )
{
	/*
	 *  ɕKvȏ͂Ȃ
	 */
}


/*
 *  CPUO̔󋵂̃Oo
 *
 *  CPUOnh̒CCPUO|C^ip_excinfjƂ
 *  ČĂяoƂŁCCPUO̔󋵂VXeOɏo͂D
 */
#ifdef SUPPORT_XLOG_SYS
void
xlog_sys( void *p_excinf )
{
	syslog(LOG_ERROR , "r1 = %u") , *((uint32_t*)((intptr_t)p_excinf + 14));
	syslog(LOG_ERROR , "r2 = %u") , *((uint32_t*)((intptr_t)p_excinf + 15));
	syslog(LOG_ERROR , "r3 = %u") , *((uint32_t*)((intptr_t)p_excinf + 16));
	syslog(LOG_ERROR , "r4 = %u") , *((uint32_t*)((intptr_t)p_excinf + 17));
	syslog(LOG_ERROR , "r5 = %u") , *((uint32_t*)((intptr_t)p_excinf + 18));
	syslog(LOG_ERROR , "r6 = %u") , *((uint32_t*)((intptr_t)p_excinf + 1));
	syslog(LOG_ERROR , "r7 = %u") , *((uint32_t*)((intptr_t)p_excinf + 2));
	syslog(LOG_ERROR , "r8 = %u") , *((uint32_t*)((intptr_t)p_excinf + 3));
	syslog(LOG_ERROR , "r9 = %u") , *((uint32_t*)((intptr_t)p_excinf + 4));
	syslog(LOG_ERROR , "r10 = %u") , *((uint32_t*)((intptr_t)p_excinf + 5));
	syslog(LOG_ERROR , "r11 = %u") , *((uint32_t*)((intptr_t)p_excinf + 6));
	syslog(LOG_ERROR , "r12 = %u") , *((uint32_t*)((intptr_t)p_excinf + 7));
	syslog(LOG_ERROR , "r13 = %u") , *((uint32_t*)((intptr_t)p_excinf + 8));
	syslog(LOG_ERROR , "r14 = %u") , *((uint32_t*)((intptr_t)p_excinf + 12));
	syslog(LOG_ERROR , "r15 = %u") , *((uint32_t*)((intptr_t)p_excinf + 13));
	syslog(LOG_ERROR , "fpsw = %u") , *((uint32_t*)((intptr_t)p_excinf + 11));
	syslog(LOG_ERROR , "acclo = %u") , *((uint32_t*)((intptr_t)p_excinf + 10));
	syslog(LOG_ERROR , "acchi = %u") , *((uint32_t*)((intptr_t)p_excinf + 9));
	syslog(LOG_ERROR , "pc = %x") , *((uint32_t*)((intptr_t)p_excinf + 19));
	syslog(LOG_ERROR , "psw = %x") , *((uint32_t*)((intptr_t)p_excinf + 20));
}
#endif /* SUPPORT_XLOG_SYS */


/*
 *  ݗvC̑̐ݒ
 *
 *  ASPJ[lł̗pz肵āCp[^G[̓AT[VŃ`Fb
 *  NĂDcfg_intT[rXR[݂ꍇɂ́CG[Ԃ悤
 *  ɂׂł낤D
 */
void
x_config_int( INTNO intno, ATR intatr, PRI intpri )
{
	uint8_t		irq_offset;
	uint8_t		irq_val;

	//assert( VALID_INTNO_CFGINT(intno) );

	assert( ( -7 <= intpri ) && ( intpri <= TMAX_INTPRI ) );
#if TIPM_LOCK != -7
	if( intatr == TA_NONKERNEL ){
		assert( intpri < TMIN_INTPRI );
 	}
	else{
		assert( TMIN_INTPRI <= intpri ); 
	}
#endif

	/*
	 *  ݂̃}XN
	 *
	 *  ݂󂯕t܂܁CxgK^GbWgK̐ݒC
	 *  ݗDx̐ݒŝ͊댯Ȃ߁Cݑɂ炸C
	 *  U}XND
	 */
	( void )x_disable_int( intno );

	/*
	 *  xgK/GbWgK̐ݒ
	 *
	 *  IRQ̂݃T|[g
	 */
	if( INTNO_IRQ( intno ) != 0U ){
		irq_offset = INTNO_IRQ_OFFSET( intno );

		if( ( intatr & TA_POSEDGE ) != 0U ){
			irq_val = IRQ_POSEDGE;
		}
		else if( ( intatr & TA_NEGEDGE ) != 0U ){
			irq_val = IRQ_NEGEDGE;
		}
		else if( ( intatr & TA_BOTHEDGE ) != 0U ){
			irq_val = IRQ_BOTHEDGE;
		}
		else if( ( intatr & TA_LOWLEVEL ) != 0U ){
			irq_val = IRQ_LOWLEVEL;
		}
		else{
			/*
			 *  RtBM[^ɂă`FbNĂ邽,
			 *  ւ邱Ƃ͂肦Ȃ.
			 */
			irq_val = 0U;
		}

		*irqcr_reg_addr[irq_offset] = irq_val;
	}

	/*
	 *  ݃x̐ݒ
	 *
	 *  ݔԍɑΉIPRlݒ肷.
	 */
	*ipr_reg_addr[intno] = cfg_int_table[intno].intpri;

	/*
	 *  ݂̃}XN
 	 */
	if( ( intatr & TA_ENAINT ) != 0U ){
		( void )x_enable_int( intno );
	}
}


#ifndef OMIT_DEFAULT_INT_HANDLER
/*
 *  o^݂̊ꍇɌĂяo
 */
void
default_int_handler( void )
{
}
#endif /* OMIT_DEFAULT_INT_HANDLER */

#ifndef OMIT_DEFAULT_EXC_HANDLER
/*
 *  o^̗OꍇɌĂяo
 */
void
default_exc_handler( void )
{
}
#endif /* OMIT_DEFAULT_EXC_HANDLER */

