/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *  vZbTˑW[ AZuꕔiARM-Mpj
 */

#define TOPPERS_MACRO_ONLY
#define UINT_C(val)		(val)		/* uint_t^̒萔}N */
#define ULONG_C(val)	(val)		/* ulong_t^̒萔}N */
#define CAST(type, val)	(val)		/* ^LXgs}N */

#include "kernel_impl.h"
#include "arm_m.h"


	.text

/*
 *  OQ
 */
	.global		intnest

/*
 *  CPUOGg
 *
 *  ݃GgƏ̓e͓CO̎ނقȂ邽߁C
 *  ĂD
 */
	.align 2
	.syntax unified
	.code 16
	.global exc_entry
	.type exc_entry, function
exc_entry:
	/*
	 *  O/݂ƁCɃANeBuȃX^bNɃXN
	 *  b`WX^ۑD
	 *  ̓eɉāCCPUOnhւ̏ƂāCbasepri ̒lƁC
	 *  EXC_RETURN̏ĕۑDbasepri̒ĺCCPUO
	 *  ^[ɊݗDx}XN̒lɖ߂߂ɂpD
	 *
	 *   -----------
	 *  | EXC_RETURN|  
	 *   -----------
	 *  |  basepri  |  
	 *   -----------
	 *  |    R0     |  
	 *   -----------
	 *  |    R1     |
	 *   -----------
	 *  |    R2     |
	 *   -----------
	 *  |    R3     |
	 *   -----------
	 *  |    R12    |
	 *   -----------
	 *  |    LR     |
	 *   -----------
	 *  |    PC     |
	 *   -----------
	 *  |   xPSR    |
	 *   -----------
	 *
	 */

	/*
	 *  ݔ̊ݗDx}XNX^bNɕۑ邽ߎ擾
	 */
	mrs   r2, basepri			/* baepri̒l擾 */
	push  {r2}					/* ݔ̊ݗDx}XNς */
	push  {lr}					/* EXC_RETURN ς			  */ 
	mov   r0, sp				/* CPUOnhւ̈ƂȂ */
	
	ldr   r1 , =lock_flag		/* CPUbNtOۑ */
	ldr   r1 , [r1]
	push  {r1}
	
	/*
	 *  ʏ
	 */
exc_entry_2:
	mrs   r3, ipsr               /* nhAhX擾 */
	ldr   r1, =_kernel_exc_tbl
	ldr   r2, [r1, r3, lsl #2]
	
#ifdef LOG_EXC_ENTER
	push  {r0, r2, r3}
	mov   r0, r3                 /* Oԍp[^  */
	bl    log_exc_enter          /* log_exc_enterĂяo */
	pop   {r0, r2, r3}
#endif /* LOG_EXC_ENTER */

#ifdef LOG_EXC_LEAVE
	push  { r3 }                   /* OԍX^bN    */
#endif /* LOG_EXC_LEAVE */

	/*
	 *  CPUOnȟĂяo
	 */
	blx   r2
	
	/* CPUbNtOɖ߂ */
	pop   {r0}
	ldr   r1 , =lock_flag
	str   r0 , [r1]
	
#ifdef LOG_EXC_LEAVE
	pop   { r0 }                   /* Oԍ        */
	bl    log_exc_leave          /* log_exc_leaveĂяo */
#endif /* LOG_EXC_LEAVE */
	
	b     ret_exc


/*
 *  ݃Gg
 */
	.align 2
	.syntax unified
	.code 16
	.global int_entry
	.type int_entry, function
int_entry:
	/*
	 *	ݔ̊ݗDx}XNX^bNɕۑ邽ߎ擾
	 */
	mrs   r2, basepri			  /* baepri̒l擾 */
	push  {r2}					 /* ݔ̊ݗDx}XNς */
	push  {lr}					 /* EXC_RETURN ς			  */ 
	mov   r0, sp				 /* `݂̊ꍇ̏Ƃ */
	
	/*
	 *	ʏ
	 */
int_entry_2:
	/* ݃lXg̉Z */
	ldr r1 , =intnest
	ldr r3 , [r1]
	add r3 , #1
	str r3 , [r1]
	
	mrs   r3, ipsr				 /* nhAhX擾 */
	ldr   r1, =_kernel_exc_tbl
	ldr   r2, [r1, r3, lsl #2]

#ifdef LOG_INH_ENTER
	push  {r0,r2,r3}
	mov   r0, r3                 /* Oԍp[^  */
	bl    log_inh_enter          /* log_exc_enterĂяo */
	pop   { r0,r2,r3 }
	push  { r3 }                   /* OԍX^bN    */
#endif /* LOG_INH_ENTER */

#ifdef LOG_INH_LEAVE
	push  { r3 }                   /* OԍX^bN    */
#endif /* LOG_INT_LEAVE */

	/*
	 *  CPUOnȟĂяo
	 */
	blx   r2
	
#ifdef LOG_INH_LEAVE
	pop   { r0 }                   /* Oԍ        */
	bl    log_inh_leave          /* log_exc_leaveĂяo */
#endif /* LOG_INH_LEAVE */

/*
 *  /Oo
 *
 *  ret_exc/ret_int́CCPUO/݃nh߂Ɏs
 *  [`łD
 */
ret_exc:
ret_int:
	/*
	 *  ݃bNԂƂD̎_ł́CCPUbNԂɂ͂ȂȂ
	 * ibaseprilock_flagsaved_iipm͍XVȂjD
	 *
	 *  ݃bNԂƂ̂́C߂̃ReLXg̃`FbNƁC
	 *  ߂悪^XNReLXgłꍇ̃^[Ag~bN
	 *  ɍs߂łDbsepriCPUbN̒lɂ邱ƂłAg~b
	 *  Nȃ`FbNƕA͉\ł邪C݂烊^[ĂC
	 *  basepri ̐ݒe͌ɖ߂Ȃ߁Cgp邱ƂłȂD 
	 *  CFAULTMASḰC݂̃^[ɂāC'0'ɃN
	 *  AD
	 */
	cpsid f
	
	/*
	 *  ߂̃ReLXg̔
	 * 
	 *  intnest0ǂŔf
	 *  
	 */
	/* ݃lXǧZ */
	ldr r1 , =intnest
	ldr r3 , [r1]
	add r3 , #-1
	str r3 , [r1]
	
	cmp   r3 , #0
	beq   ret_int_2
	
	/*
	 *  iڂ݂̊̏o
	 */
ret_int_1:
	/*
	 *  ɂ͊݃bNԁiFAULTMASKZbgjꂽԂŗD
	 *  Thread[h̃^[ɂ莩IɊ݃bNԂɂȂD
	 *  ݗDx}XN͊ݑOɏԂɖ߂D
	 */ 
	pop		{ r2 }
	pop		{ r1 }
	msr   basepri, r1			  /* ݗDx}XNݑOɏԂ */
	bx	  r2					  /* ^[ */
	
ret_int_2:
	ldr   r0, =reqflg             /* reqflgfalseȂ炻̂܂ܖ߂ */
	ldr   r1, [r0]
	cmp   r1 , #0
	beq    ret_int_1           /* falseȂret_int_1           */
ret_int_3:
	mov   r1, #0                   /* reqflgfalse */
	str   r1, [r0]
	
	/*
	 *  CPUbNԂɈڍsD
	 *
	 *  J[l̊Ǘ݂̊֎~悤basepriݒ肵C
	 *  lock_flagXVD
	 *  ̎_CPUbNԂƂ̂́Cdispatcher֕򂷂鎞
	 *  CPUbNԂɂȂĂKv邽߂łD
     *  ȂC̏̌CThread[hւ̈ڍssȂ߁C
     *  bN(FAULTMASK"1")͕ێD
	 */
	ldr   r1, =IIPM_LOCK		  /* CPUbN */ 
	msr   basepri, r1
	mov   r1, #0x01 			  /* lock_flag  true */
	ldr   r0, =lock_flag 
	str   r1, [r0]
	
	/*
	 *  lroDxfBXpb`̍ۂɂg߁C
	 *  X^bN|C^͑삵ȂD
	 */
	
	ldr   r2 , [sp]
	
	/*
	 *  Thread[hֈڍsD
	 *
	 *  dispatchercall_texrnĂяoꍇ́CThread[hłK
	 *  v邽߁CPSPX^bNɃ_~[̗Ot[uāC
	 *  [IɊ݃nh烊^[D
	 *  ^[ƓFAULTMASKIɃNACJ[lǗO
	 *  ݂D
	 */
	ldr   r0, =ret_int_4		  /* PC   */
	ldr   r1, =EPSR_T			  /* xPSR(Trbg'1'łKv) */
	stmfd sp!, {r0-r1}			  /* _~[t[X^bNɐς	*/
	sub   sp, #(EXC_FRAME_SIZE - (4*2)) /* r0-r3,r12,lr̓e͐ݒ肷KvȂ */
	bx	  r2					  /* Thread[hֈڍs */
    
ret_int_4:
	bl    search_schedtsk		/* ݒŋNꂽ^XNs */
	bl    run_task
ret_int_r:
	svc   0 				   /* SVČĂяo */
	
/*
 *  xfBXpb`̕AɈꎞIɊ
 *  ReLXgɈڍs邽߂SVCR[nh
 */

	.align	2
	.thumb
	.thumb_func
	.globl kernel_svc_handler
kernel_svc_handler:
	/*
	 *  ݏ̃^[ɂCCPUbNԂɈڍs
	 *  D
	 */
	cpsid f 								/* ݃bNԂ */
	ldr		r2 , [ sp , #(EXC_FRAME_SIZE) ]	/* lrX^bN擾	*/
	add		sp, #EXC_FRAME_SIZE + 8			/* X^bN̂Ă	*/
	mov		r0, #0
	ldr		r1, =lock_flag					/* CPUbNԂ */
	str		r0, [r1]
	msr		basepri , r0 
	bx		r2								/* ^[	  */

/*
 *  fBXpb`̓Jn
 */
	.align	2
	.thumb
	.thumb_func
	.globl start_dispatch
start_dispatch:
	/*
	 *  ̃[`́CJ[lNɁCׂĂ݂̊֎~
	 * i݃bNԂƓjŌĂяoD܂C݃[hi
	 *  ^XNReLXgƓjŌĂяo邱Ƃz肵ĂD
	 *
	 *  prc_initializeŁClock_flagtrueɁCsaved_iipmIIPM_ENAALL
	 *  Ă邽߁CJ[lǗO݂̊邱ƂŁC
	 *  CPUbNԁEif́jݗDx}XNSԂɂȂD
	 *  ܂Ctask_initializedisdspfalseɏĂ邽߁CfB
	 *  Xpb`ԂɂȂĂD
	 */
	ldr   r0,=istkpt              /* MSP   */
	ldr   r1,[r0]                 /* start_dispatchĂяoɌĂяop */
	msr   msp, r1                 /* gpĂ邽ߏ             */
	ldr   r1, =IIPM_LOCK          /* J[lǗ݂̊֎~ */
	msr   basepri, r1 
	cpsie f                       /* J[lǗO݂̊ */
	b	  dispatcher

/*
 *  J[l̏Ǐďo
 *
 *  X^bN^XNReLXgpɐ؂ւD
 *  
 */
	.text
	.syntax unified
	.code 16
	.globl call_exit_kernel
	.type call_exit_kernel, function
call_exit_kernel:
	b     exit_kernel       /* J[l̏IĂ */


/*
 *  ԑ҂
 */
	.text
	.syntax unified
	.code 16
	.globl sil_dly_nse
	.type sil_dly_nse, function
sil_dly_nse:
	sub   r0, r0, #SIL_DLY_TIM1
	cmp   r0, #0
	bgt   sil_dly_nse1
	mov   pc, lr
sil_dly_nse1:
	sub   r0, r0, #SIL_DLY_TIM2
	cmp   r0, #0
	bgt   sil_dly_nse1
	mov   pc, lr
