/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2009 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2010 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2010-2011 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

/*
 *		J[l̏ƏI
 */

#include "task.h"
#include "t_stddef.h"
#include "kernel_impl.h"
#include <sil.h>

/*
 *  g[XO}ÑftHg`
 */
#ifndef LOG_KER_ENTER
#define LOG_KER_ENTER()
#endif /* LOG_KER_ENTER */

#ifndef LOG_KER_LEAVE
#define LOG_KER_LEAVE()
#endif /* LOG_KER_LEAVE */

#ifndef LOG_EXT_KER_ENTER
#define LOG_EXT_KER_ENTER()
#endif /* LOG_EXT_KER_ENTER */

#ifndef LOG_EXT_KER_LEAVE
#define LOG_EXT_KER_LEAVE(ercd)
#endif /* LOG_EXT_KER_LEAVE */


/*
 *  J[lԃtO
 *
 *  X^[gAbv[`ŁCfalsei0jɏ邱Ƃ҂
 *  D
 */
bool_t	kerflg = false;


/*
 *  J[l̋N
 *    NMISĂ݂̊}XNꂽ(S݃bNԂɑ)ŌĂяoD
 */
void
sta_ker(void)
{
	target_initialize();
	
	initialize_object();
	
	call_inirtn();
	
	/*
	 *  J[l̓JnD
	 */	
	kerflg = true;
	
	/* fBXpb`NC^XN̓Jn */
	LOG_KER_ENTER();
	start_dispatch();
	assert(false);
}


/*
 *  J[l̏I
 */
ER
ext_ker(void)
{
	SIL_PRE_LOC;
	
	LOG_EXT_KER_ENTER();
	
	/*
	 *  ݃bNԂɈڍs
	 */
	SIL_LOC_INT();
	
	/*
	 *  J[l̏I
	 */
	LOG_KER_LEAVE();
	kerflg = false;
	
	/*
	 *  J[l̏Ǐďo
	 *
	 *  ^XNReLXgɐ؂芷āCexit_kernelĂяoD
	 */
	call_exit_kernel();
	
	/*
	 *  SIL_UNL_INTĂяoCɓB邱Ƃ͂ȂD
	 *  Lq̂SIL_PRE_LOCŐ錾ϐꍇɁC
	 *  RpCo͂x}邽߂łD
	 */
	SIL_UNL_INT();
	LOG_EXT_KER_LEAVE(E_SYS)
	
	return E_SYS;
}


/*
 *  J[l̏I
 */
void
exit_kernel(void)
{
	/*
	 *  I[`̎s
	 */
	call_terrtn();
	
	/*
	 *  ^[Qbgˑ̏I
	 */
	target_exit();
	assert(false);
}

