#include"Header.h"
#include"resource.h"

LPSTR lpStrParam[4];

LRESULT CALLBACK WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	WAVEFORMATEX fmt;
	static HWAVEOUT hWaveOut;

	static WAVEHDR whdrChunkBuffer[BufferNumber];
	static WAVEHDR whdrBuffer;

	HDC hdc;
	PAINTSTRUCT ps;

	static OPENFILENAME ofn = { 0 };
	static TCHAR strFile[MAX_PATH], strCustom[256] = TEXT("Before files\0*.*\0\0");


	switch (uMsg){
	case WM_CREATE:
		WindowInit(((LPCREATESTRUCT)(lParam))->hInstance, hWnd);
		return 0;
	case WM_COMMAND:
		if (LOWORD(wParam) == COMBOBOX_ID1){
			switch (HIWORD(wParam)){
			case CBN_CLOSEUP:
				MSG("COMBOBOX_ID1")
					break;
			}
		}
		if (LOWORD(wParam) == COMBOBOX_ID2){
			switch (HIWORD(wParam)){
			case CBN_CLOSEUP:
				MSG("COMBOBOX_ID2")
					break;
			}
		}
		switch (LOWORD(wParam)){
		case BUTTON_ID1:
			waveOutPrepareHeader(hWaveOut, &whdrChunkBuffer[0], sizeof(WAVEHDR));
			waveOutWrite(hWaveOut, &whdrChunkBuffer[0], sizeof(WAVEHDR));
			break;
		case BUTTON_ID2:
			waveOutReset(hWaveOut);
			break;
		case BUTTON_ID3:
			waveOutPause(hWaveOut);
			break;
		case BUTTON_ID4:
			waveOutRestart(hWaveOut);
			break;
		case BUTTON_ID5:
			memcpy(&whdrChunkBuffer[0].lpData, &whdrBuffer.lpData, sizeof(LPSTR));
			whdrChunkBuffer[0].dwBufferLength = (DWORD)(sizeof(LPSTR));
			whdrChunkBuffer[0].dwBytesRecorded;
			whdrChunkBuffer[0].dwFlags;
			whdrChunkBuffer[0].dwLoops;
			whdrChunkBuffer[0].dwUser;
			whdrChunkBuffer[0].lpNext;
			whdrChunkBuffer[0].reserved;
			break;
		case BUTTON_ID6:
			break;
		case BUTTON_ID7:
			break;
		case BUTTON_ID8:
			break;
		case BUTTON_ID9:
			break;
		case BUTTON_ID10:
			break;
		case BUTTON_ID11:
			break;
		case BUTTON_ID12:
			break;
		case BUTTON_ID13:
			PostMessage(hWnd, WM_DESTROY, wParam, lParam);
			break;
		case IDM_OPEN:
			ofn.lStructSize = sizeof (OPENFILENAME);
			ofn.hwndOwner = hWnd;
			ofn.lpstrFilter = TEXT("WAVE t@C (*.wav)\0*.wav\0")
							  TEXT("ׂẴt@C (*.*)\0*.*\0\0");
			ofn.lpstrCustomFilter = strCustom;
			ofn.nMaxCustFilter = 256;
			ofn.nFilterIndex = 0;
			ofn.lpstrFile = strFile;
			ofn.nMaxFile = MAX_PATH;
			ofn.Flags = OFN_FILEMUSTEXIST;
			if (GetOpenFileName(&ofn) != 0){
				LoadWaveFile(strFile, &fmt, &whdrBuffer);
				waveOutOpen(&hWaveOut, WAVE_MAPPER, &fmt, 0, 0, CALLBACK_NULL);
			}
			break;
		case IDM_CLOSE:
			PostMessage(hWnd, WM_DESTROY, wParam, lParam);
			break;
		case IDM_FUNC:
			MSG("IDM_FUNC")
				break;
		}
		return 0;
	case MM_WOM_DONE:
		return 0;
	case MM_WOM_OPEN:
		return 0;
	case MM_WOM_CLOSE:
		return 0;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		SetBkMode(hdc, TRANSPARENT);
		SelectObject(hdc, GetStockObject(BLACK_BRUSH));
		Rectangle(hdc, 110, 10, 1250, 280);
		Rectangle(hdc, 110, 290, 1250, 570);
		TextOut(hdc, 110, 585, TEXT("CompMethod"), 10);
		TextOut(hdc, 110, 625, TEXT("StrAlgorithm"), 12);
		TextOut(hdc, 420, 585, TEXT("L.VOLUME:"), strlen(TEXT("L.VOLUME:")));
		TextOut(hdc, 420, 625, TEXT("R.VOLUME:"), strlen(TEXT("R.VOLUME:")));
		TextOut(hdc, 630, 585, TEXT("RATIO   :"), strlen(TEXT("RATIO   :")));
		TextOut(hdc, 630, 625, TEXT("TIME    :"), strlen(TEXT("TIME    :")));

		TextOut(hdc, 560, 585, lpStrParam[0], strlen(lpStrParam[0]));
		TextOut(hdc, 560, 625, lpStrParam[1], strlen(lpStrParam[1]));
		TextOut(hdc, 760, 585, lpStrParam[2], strlen(lpStrParam[2]));
		TextOut(hdc, 760, 625, lpStrParam[3], strlen(lpStrParam[3]));
		EndPaint(hWnd, &ps);
		return 0;
	case WM_DESTROY:
		CloseWaveFile(hWaveOut, whdrChunkBuffer);
		CloseWaveFile(hWaveOut, &whdrBuffer);
		PostQuitMessage(0);
		return 0;
	}
	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR lpCmdLine, int nCmdShow)
{
	WNDCLASS wc;
	MSG msg;
	HWND hWnd;
	static HWND combo, label;
	static TCHAR strText[1024];

	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = WindowProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)GetStockObject(GRAY_BRUSH);
	wc.lpszMenuName = MAKEINTRESOURCE(IDR_MENU);
	wc.lpszClassName = TEXT("CLASS");
	if (!RegisterClass(&wc)){
		MSG("NX̓o^s")
			return -1;
	}

	hWnd = CreateWindow(
		TEXT("CLASS"), TEXT("WaveTracer"),
		WS_OVERLAPPEDWINDOW ^ WS_MAXIMIZEBOX ^ WS_THICKFRAME | WS_VISIBLE,
		CW_USEDEFAULT, CW_USEDEFAULT,
		1280, 720,
		NULL, NULL, hInstance, NULL
		);
	if (hWnd == NULL){
		MSG("EBhE쐬s");
		return -1;
	}

	BOOL bRet;
	while ((bRet = GetMessage(&msg, NULL, 0, 0)) != 0){
		if (bRet == -1) break;
		DispatchMessage(&msg);
	}
	UnregisterClass("CLASS", hInstance);
	return (int)msg.wParam;
}

int LoadWaveFile(PCTSTR filename, WAVEFORMATEX *pwfe, WAVEHDR *pwhdr)
{
	HANDLE fh = CreateFile(filename, GENERIC_READ, 0, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (fh == INVALID_HANDLE_VALUE)
	{
		MSG(TEXT("t@C[hĂ܂"));
		return false;
	}
	DWORD file_size = GetFileSize(fh, NULL);
	BYTE *pMem = (BYTE*)malloc(file_size);
	DWORD read_size;
	ReadFile(fh, pMem, file_size, &read_size, NULL);
	CloseHandle(fh);

	char str[4];
	memcpy(str, pMem + 8, 4);
	if (strncmp(str, "WAVE", 4))
	{
		free(pMem);
		MSG(TEXT("WAVEt@Cw肵ĉ"));
		return false;
	}

	DWORD fmt_size = *(DWORD*)(pMem + 16);
	memset(pwfe, 0, sizeof(WAVEFORMATEX));
	memcpy(pwfe, pMem + 20, fmt_size);		// tH[}bgRs[

	if (pwfe->wFormatTag != WAVE_FORMAT_PCM)
	{
		free(pMem);
		MSG(TEXT("PCM`WAVEt@Cw肵ĉ"));
		return false;
	}

	DWORD offset = 0;
	DWORD data_size = 0;
	DWORD fact_size = 0;
	DWORD cue_size = 0;
	DWORD plst_size = 0;
	DWORD list_size = 0;
	DWORD labl_size = 0;
	DWORD note_size = 0;
	DWORD ltxt_size = 0;
	DWORD smpl_size = 0;
	DWORD inst_size = 0;
	int flag = 1;

	while (flag != 0){
		memcpy(str, pMem + 20 + fmt_size + offset, sizeof(DWORD));
		int state = chartoint(str);
		switch (state){
		case'data':
			data_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			flag = 0; break;
		case'DATA':
			data_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			flag = 0; break;
		case'fact':
			fact_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + fact_size; break;
		case'FACT':
			fact_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + fact_size; break;
		case'cue ':
			cue_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + cue_size;  break;
		case'CUE ':
			cue_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + cue_size; break;
		case'plst':
			plst_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + plst_size; break;
		case'PLST':
			plst_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + plst_size; break;
		case'list':
			list_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + list_size; break;
		case'LIST':
			list_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + list_size; break;
		case'labl':
			labl_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + labl_size; break;
		case'LABL':
			labl_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + labl_size; break;
		case'note':
			note_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + note_size; break;
		case'NOTE':
			note_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + note_size; break;
		case'ltxt':
			ltxt_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + ltxt_size; break;
		case'LTXT':
			ltxt_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + ltxt_size; break;
		case'smpl':
			smpl_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + smpl_size; break;
		case'SMPL':
			smpl_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + smpl_size; break;
		case'inst':
			inst_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + inst_size; break;
		case'INST':
			inst_size = *(DWORD*)(pMem + 20 + fmt_size + offset + 4);
			offset += 8 + inst_size; break;
		}
	}

	// g`f[^Rs[
	BYTE *pWave = (BYTE*)malloc(data_size);
	memcpy(pWave, pMem + 20 + offset + 8, data_size);
	free(pMem);

	memset(pwhdr, 0, sizeof(WAVEHDR));
	pwhdr->lpData = (LPSTR)pWave;
	pwhdr->dwBufferLength = data_size;
	pwhdr->dwFlags = WHDR_BEGINLOOP | WHDR_ENDLOOP;
	pwhdr->dwLoops = 1;
	pwhdr->dwUser = STOP;
	return true;
}

int CloseWaveFile(HWAVEOUT hWaveOut, WAVEHDR *lpwhdr)
{
	waveOutReset(hWaveOut);
	waveOutUnprepareHeader(hWaveOut, lpwhdr, sizeof(WAVEHDR));
	waveOutClose(hWaveOut);
	return 0;
}

int WindowInit(HINSTANCE hInstance, HWND hWnd){
	static OPENFILENAME ofn = { 0 };
	static TCHAR strFile[MAX_PATH], strCustom[256] = TEXT("Before files\0*.*\0\0");

	CreateWindow(
		TEXT("BUTTON"), TEXT("PLAY"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 0, 100, 50,
		hWnd, (HMENU)BUTTON_ID1, hInstance, NULL
		);
	CreateWindow(
		TEXT("BUTTON"), TEXT("STOP"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 50, 100, 50,
		hWnd, (HMENU)BUTTON_ID2, hInstance, NULL
		);
	CreateWindow(
		TEXT("BUTTON"), TEXT("PAUSE"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 100, 100, 50,
		hWnd, (HMENU)BUTTON_ID3, hInstance, NULL
		);
	CreateWindow(
		TEXT("BUTTON"), TEXT("RESTART"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 150, 100, 50,
		hWnd, (HMENU)BUTTON_ID4, hInstance, NULL
		);
	CreateWindow(
		TEXT("BUTTON"), TEXT("BUTTON"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 200, 100, 50,
		hWnd, (HMENU)BUTTON_ID5, hInstance, NULL
		);
	CreateWindow(
		TEXT("BUTTON"), TEXT("BUTTON"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 250, 100, 50,
		hWnd, (HMENU)BUTTON_ID6, hInstance, NULL
		);
	CreateWindow(
		TEXT("BUTTON"), TEXT("BUTTON"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 300, 100, 50,
		hWnd, (HMENU)BUTTON_ID7, hInstance, NULL
		);
	CreateWindow(
		TEXT("BUTTON"), TEXT("BUTTON"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 350, 100, 50,
		hWnd, (HMENU)BUTTON_ID8, hInstance, NULL
		);
	CreateWindow(
		TEXT("BUTTON"), TEXT("BUTTON"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 400, 100, 50,
		hWnd, (HMENU)BUTTON_ID9, hInstance, NULL
		);
	CreateWindow(
		TEXT("BUTTON"), TEXT("BUTTON"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 450, 100, 50,
		hWnd, (HMENU)BUTTON_ID10, hInstance, NULL
		);
	CreateWindow(
		TEXT("BUTTON"), TEXT("BUTTON"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 500, 100, 50,
		hWnd, (HMENU)BUTTON_ID11, hInstance, NULL
		);
	CreateWindow(
		TEXT("BUTTON"), TEXT("BUTTON"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 550, 100, 50,
		hWnd, (HMENU)BUTTON_ID12, hInstance, NULL
		);
	CreateWindow(
		TEXT("BUTTON"), TEXT("EXIT"),
		WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
		0, 600, 100, 60,
		hWnd, (HMENU)BUTTON_ID13, hInstance, NULL
		);
	CreateWindow(
		TEXT("COMBOBOX"), NULL,
		WS_CHILD | WS_VISIBLE | WS_VSCROLL | CBS_DROPDOWNLIST,
		210, 580, 200, 100,
		hWnd, (HMENU)COMBOBOX_ID1, hInstance, NULL
		);
	SendMessage(GetDlgItem(hWnd, COMBOBOX_ID1), CB_ADDSTRING, 0, (LPARAM)TEXT("Method"));
	SendMessage(GetDlgItem(hWnd, COMBOBOX_ID1), CB_ADDSTRING, 0, (LPARAM)TEXT("Method"));
	SendMessage(GetDlgItem(hWnd, COMBOBOX_ID1), CB_ADDSTRING, 0, (LPARAM)TEXT("Method"));
	SendMessage(GetDlgItem(hWnd, COMBOBOX_ID1), CB_ADDSTRING, 0, (LPARAM)TEXT("Method"));
	CreateWindow(
		TEXT("COMBOBOX"), NULL,
		WS_CHILD | WS_VISIBLE | WS_VSCROLL | CBS_DROPDOWNLIST,
		210, 620, 200, 100,
		hWnd, (HMENU)COMBOBOX_ID2, hInstance, NULL
		);
	SendMessage(GetDlgItem(hWnd, COMBOBOX_ID2), CB_ADDSTRING, 0, (LPARAM)TEXT("Method"));
	SendMessage(GetDlgItem(hWnd, COMBOBOX_ID2), CB_ADDSTRING, 0, (LPARAM)TEXT("Method"));
	SendMessage(GetDlgItem(hWnd, COMBOBOX_ID2), CB_ADDSTRING, 0, (LPARAM)TEXT("Method"));
	SendMessage(GetDlgItem(hWnd, COMBOBOX_ID2), CB_ADDSTRING, 0, (LPARAM)TEXT("Method"));

	ofn.lStructSize = sizeof (OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFilter = TEXT("WAVE t@C (*.wav)\0*.wav\0")
		TEXT("ׂẴt@C (*.*)\0*.*\0\0");
	ofn.lpstrCustomFilter = strCustom;
	ofn.nMaxCustFilter = 256;
	ofn.nFilterIndex = 0;
	ofn.lpstrFile = strFile;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_FILEMUSTEXIST;
	return 0;
}