/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2007,2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: test_task1.c 1232 2008-08-09 13:30:32Z ertl-hiro $
 */

/* 
 *		^XNǗW[̃eXg(1)
 *
 * yeXg̖ړIz
 *
 *  make_runnablemake_non_runnableԗIɃeXgD
 *
 * yeXgځz
 *
 *	(A) sԂ̃^XNDx̃^XNsłԂɂ
 *		(A-1) fBXpb`ۗԂł͂Ȃꍇ
 *		(A-2) fBXpb`ۗԂ̏ꍇ
 *	(B) sԂ̃^XNƓDx̃^XNsłԂɂ
 *		IDx̃^XN̖̒ɓ邱ƂmF
 *	(C) sԂ̃^XNႢDx̃^XNsłԂɂ
 *		IDx̃^XN̖̒ɓ邱ƂmF
 *	(D) słԂ̃^XNȂԂŁC^XNsłԂɂ
 *		Ȉꍇ́CfBXpb`ۗԂł͂Ȃ
 *	(E) fBXpb`ۗԂŁCsԂɂȂׂs\ԃ^X
 *		NDx̃^XNCsłԂɂ
 *	(F) fBXpb`ۗԂŁCsԂɂȂׂs\ԃ^X
 *		NƓDx̃^XNCsłԂɂ
 *	(G) fBXpb`ۗԂŁCsԂɂȂׂs\ԃ^X
 *		NႢDx̃^XNCsłԂɂ
 *	(H) sԂ̃^XNCsłԂłȂ
 *		(H-1) słԂ̃^XNȂȂꍇ
 *		(H-2) Dx̃^XNȂȂꍇ
 *		(H-3) Dx̃^XNȂȂȂꍇ
 *	(I) s\Ԃ̃^XNCsłԂłȂ
 *		(I-1) Dx̃^XNȂȂꍇ
 *		(I-2) Dx̃^XNȂȂȂꍇ
 *	(J) fBXpb`ۗԂŁCsԂɂȂׂs\ԂƂȂ
 *		Ă^XNCsłԂłȂ
 *		(J-1) Dx̃^XNȂȂꍇ
 *		(J-2) Dx̃^XNȂȂȂꍇ
 *	(K) fBXpb`ۗԂŁCs\ԂɂȂׂsԂ̃^
 *		XNCsłԂłȂ
 *		IfBXpb`ۗł́CsԂ̃^XNsłԂłȂ
 *		Ȃ悤ȑJڂNƂłȂ߁C̏󋵂͋NȂD
 *
 * ygp\[Xz
 *
 *	TASK1: Dx^XNCC^XNCŏN
 *	TASK2: Dx^XN
 *	TASK3: Dx^XN
 *	TASK4: Dx^XN
 *	TASK5: Dx^XN
 *	TASK6: Dx^XN
 *	ALM1:  A[nh
 *
 * yeXgV[PXz
 *
 *	== TASK1iDxFj==
 *	1:	act_tsk(TASK2)					... (A-1)
 *	== TASK2iDxFj==
 *	2:	slp_tsk()						... (H-2)
 *	== TASK1ij==
 *	3:	act_tsk(TASK3)					... (B)
 *	4:	act_tsk(TASK4)					... (B)
 *	5:	slp_tsk()						... (H-3)
 *	== TASK3iDxFj==
 *	6:	slp_tsk()						... (H-3)
 *	== TASK4iDxFj==
 *	7:	wup_tsk(TASK1)
 *	8:	slp_tsk()						... (H-3)
 *	== TASK1ij==
 *	9:	act_tsk(TASK5)					... (C)
 *	10:	act_tsk(TASK6)					... (C)
 *	11:	sus_tsk(TASK6)					... (I-2)
 *	12:	sus_tsk(TASK5)					... (I-1)
 *	13:	rsm_tsk(TASK5)					... (C)
 *	14:	rsm_tsk(TASK6)					... (C)
 *	15:	slp_tsk()						... (H-2)
 *	== TASK5iDxFj==
 *	16:	slp_tsk()						... (H-3)
 *	== TASK6iDxFj==
 *	17:	dis_dsp()
 *	18:	wup_tsk(TASK1)					... (A-2)
 *	19:	wup_tsk(TASK2)					... (E)
 *	20:	sus_tsk(TASK2)					... (J-1)
 *	21:	wup_tsk(TASK3)					... (F)
 *	22:	wup_tsk(TASK4)					... (F)
 *	23:	sus_tsk(TASK1)					... (J-2)
 *	24:	ena_dsp()
 *	== TASK3ij==
 *	25:	slp_tsk()						... (H-3)
 *	== TASK4ij==
 *	26:	slp_tsk()						... (H-2)
 *	== TASK6ij==
 *	27:	dis_dsp()
 *	28:	rsm_tsk(TASK1)					... (A-2)
 *	29:	wup_tsk(TASK5)					... (G)
 *	30:	ena_dsp()
 *	== TASK1ij==
 *	31:	slp_tsk()						... (H-2)
 *	== TASK6ij==
 *	32:	slp_tsk()						... (H-3)
 *	== TASK5ij==
 *	33:	sus_tsk(LOGTASK)
 *	34:	sta_alm(ALM1, 10)
 *	35:	slp_tsk()						... (H-1)
 *	== ALM1 ==
 *	36:	iget_tid(&tskid)
 *		assert(tskid == TSK_NONE)
 *	37:	iwup_tsk(TASK1)					... (D)
 *	38:	RETURN
 *	== TASK1ij==
 *	39:	rsm_tsk(LOGTASK)
 *	40: END
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_task1.h"

void
alarm1_handler(intptr_t exinf)
{
	ER		ercd;
	ID		tskid;

	check_point(36);
	ercd = iget_tid(&tskid);
	check_ercd(ercd, E_OK);
	check_assert(tskid == TSK_NONE);

	check_point(37);
	ercd = iwup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(38);
	return;

	check_point(0);
}

void
task1(intptr_t exinf)
{
	ER		ercd;

	check_point(1);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(3);
	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(4);
	ercd = act_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(5);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(9);
	ercd = act_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(10);
	ercd = act_tsk(TASK6);
	check_ercd(ercd, E_OK);

	check_point(11);
	ercd = sus_tsk(TASK6);
	check_ercd(ercd, E_OK);

	check_point(12);
	ercd = sus_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(13);
	ercd = rsm_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(14);
	ercd = rsm_tsk(TASK6);
	check_ercd(ercd, E_OK);

	check_point(15);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(31);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(39);
	ercd = rsm_tsk(LOGTASK);
	check_ercd(ercd, E_OK);

	check_finish(40);

	check_point(0);
}

void
task2(intptr_t exinf)
{
	ER		ercd;

	check_point(2);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task3(intptr_t exinf)
{
	ER		ercd;

	check_point(6);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(25);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task4(intptr_t exinf)
{
	ER		ercd;

	check_point(7);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(8);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(26);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task5(intptr_t exinf)
{
	ER		ercd;

	check_point(16);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(33);
	ercd = sus_tsk(LOGTASK);
	check_ercd(ercd, E_OK);

	check_point(34);
	ercd = sta_alm(ALM1, 10);
	check_ercd(ercd, E_OK);

	check_point(35);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task6(intptr_t exinf)
{
	ER		ercd;

	check_point(17);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(18);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(19);
	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(20);
	ercd = sus_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(21);
	ercd = wup_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(22);
	ercd = wup_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(23);
	ercd = sus_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(24);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(27);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(28);
	ercd = rsm_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(29);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(30);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(32);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}
