/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: test_sem1.c 1390 2008-11-23 14:24:08Z ertl-hiro $
 */

/* 
 *		Z}tH@\̃eXg(1)
 *
 * yeXg̖ړIz
 *
 *  sig_semCwai_semCCRE_SEMԗIɃeXgD
 *  CCRE_SEM̃G[̃eXg͏D
 *
 * yeXgځz
 *
 *	(A) sig_sem̐ÓIG[̃eXg
 *		(A-1) ^XNReLXǧďo
 *		(A-2) CPUbNԂ̌ďo
 *		(A-3) semidsij
 *		(A-4) semidsi傫j
 *	(B) sig_semɂZ}tH҂Ԃ̃^XN҂
 *		(B-1) ҂ꂽ^XNɐ؂芷
 *		(B-2) fBXpb`ۗԂŁC؂芷Ȃ
 *		(B-3) ҂ꂽ^XN҂ԂŁC؂芷Ȃ
 *		(B-4) ҂ꂽ^XNDxႭC؂芷Ȃ
 *	(C) sig_semɂZ}tH̎1
 *		(C-1) Z}tH̎01ɂȂ
 *		(C-2) Z}tH̎12ɂȂ
 *	(D) sig_semE_QOVRG[ƂȂ
 *		(D-1) Z}tH̍ő厑1̎
 *		(D-2) Z}tH̍ő厑2̎
 *	(E) wai_sem̐ÓIG[̃eXg
 *		(E-1) ^XNReLXǧďo
 *		(E-2) CPUbNԂ̌ďo
 *		(E-3) fBXpb`֎~Ԃ̌ďo
 *		(E-4) ݗDx}XNSłȂԂ̌ďo
 *		(E-5) semidsij
 *		(E-6) semidsi傫j
 *	(F) wai_semɂZ}tH̎1
 *		(F-1) Z}tH̎10ɂȂ
 *		(F-2) Z}tH̎21ɂȂ
 *	(G) wai_semɂZ}tH҂ԂɂȂ
 *		(G-1) TA_TNULL̃Z}tHŁC҂Ă^XNȂꍇ
 *		(G-2) TA_TNULL̃Z}tHŁC҂Ă^XNꍇ
 *		(G-3) TA_TPRĨZ}tHŁC҂Ă^XNȂꍇ
 *		(G-4) TA_TPRĨZ}tHŁCDx^XN҂Ăꍇ
 *		(G-5) TA_TPRĨZ}tHŁCDx^XN҂Ăꍇ
 *		(G-6) TA_TPRĨZ}tHŁCDxႢ^XN҂Ăꍇ
 *	(H) Z}tH҂Ԃ
 *	(I) Z}tH҂Ԃ̊ԂɃZ}tH
 *	(J) Z}tH̎̏lݒ肳
 *		(J-1) Z}tH̎̏l0
 *		(J-2) Z}tH̎̏l1
 *		(J-3) Z}tH̎̏l2
 *
 * ygp\[Xz
 *
 *	TASK1: Dx^XNCTA_ACT
 *	TASK2: Dx^XN
 *	TASK3: Dx^XN
 *	TASK4: Dx^XN
 *	TASK5: Dx^XN
 *	ALM1:  A[nh
 *  SEM1:  TA_NULLC1Cő厑1
 *  SEM2:  TA_NULLC2Cő厑2
 *  SEM3:  TA_TPRIC0Cő厑1
 *
 * yeXgV[PXz
 *
 *	== TASK1iDxFj==
 *  1:	ref_sem(SEM1, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 1)			... (J-2)
 *  	ref_sem(SEM2, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 2)			... (J-3)
 *  	ref_sem(SEM3, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 0)			... (J-1)
 *	2:	loc_cpu()
 *		sig_sem(SEM1) -> E_CTX				... (A-2)
 *		wai_sem(SEM1) -> E_CTX				... (E-2)
 *		unl_cpu()
 *		dis_dsp()
 *		wai_sem(SEM1) -> E_CTX				... (E-3)
 *		ena_dsp()
 *		chg_ipm(TMAX_INTPRI)
 *		wai_sem(SEM1) -> E_CTX				... (E-4)
 *		chg_ipm(TIPM_ENAALL)
 *		sig_sem(0) -> E_ID					... (A-3)
 *		wai_sem(0) -> E_ID					... (E-5)
 *		sig_sem(TNUM_SEMID+1) -> E_ID		... (A-4)
 *		wai_sem(TNUM_SEMID+1) -> E_ID		... (E-6)
 *	3:	act_tsk(TASK3)
 *	4:	slp_tsk()
 *	== TASK3iDxFj==
 *	5:	wai_sem(SEM1)						... (F-1)
 *  6:	ref_sem(SEM1, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 0)
 *	7:	sta_alm(ALM1, 10)
 *	8:	wai_sem(SEM1)						... (G-1)
 *	== ALM1 ==
 *	9:	sig_sem(SEM1) -> E_CTX				... (A-1)
 *		wai_sem(SEM1) -> E_CTX				... (E-1)
 *	10:	iwup_tsk(TASK1)
 *	11:	RETURN
 *	== TASK1ij==
 *	12:	act_tsk(TASK2)
 *	== TASK2iDxFj==
 *	13:	wai_sem(SEM1)						... (G-2)
 *	== TASK1ij==
 *  14:	ref_sem(SEM1, &rsem)
 *		assert(rsem.wtskid == TASK3)
 *		assert(rsem.semcnt == 0)
 *	15:	sig_sem(SEM1)						... (B-4)
 *	16:	sig_sem(SEM1)						... (B-1)
 *	== TASK2ij==
 *	17:	wai_sem(SEM1)						... (G-1)
 *	== TASK1ij==
 *	18: dis_dsp()
 *	19:	sig_sem(SEM1)						... (B-2)
 *	20:	ena_dsp()
 *	== TASK2ij==
 *	21:	wai_sem(SEM1)						... (G-1)
 *	== TASK1ij==
 *	22: sus_tsk(TASK2)
 *	23:	sig_sem(SEM1)						... (B-3)
 *	24: sig_sem(SEM1)						... (C-1)
 *	25: sig_sem(SEM1) -> E_QOVR				... (D-1)
 *  26:	ref_sem(SEM1, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 1)
 *	27:	rsm_tsk(TASK2)
 *	== TASK2ij==
 *	28:	wai_sem(SEM2)						... (F-2)
 *  29:	ref_sem(SEM2, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 1)
 *	30:	wai_sem(SEM2)						... (F-1)
 *	31: wai_sem(SEM2)						... (G-1)
 *	== TASK1ij==
 *	32:	sig_sem(SEM2)						... (B-1)
 *	== TASK2ij==
 *	33:	wai_sem(SEM3)						... (G-3)
 *	== TASK1ij==
 *	34:	sig_sem(SEM2)						... (C-1)
 *	35:	sig_sem(SEM2)						... (C-2)
 *  36:	ref_sem(SEM2, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 2)
 *	37:	sig_sem(SEM2) -> E_QOVR				... (D-2)
 *  38:	ref_sem(SEM2, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 2)
 *	39:	MISSING
 *	40:	tslp_tsk(10) -> E_TMOUT
 *	== TASK3ij==
 *	41:	wai_sem(SEM3)						... (G-4)
 *	== TASK1ij==
 *	42:	act_tsk(TASK4)
 *	43:	act_tsk(TASK5)
 *	44:	rot_rdq(TPRI_SELF)
 *	== TASK4iDxFj==
 *	45:	wai_sem(SEM3)						... (G-6)
 *	== TASK5iDxFj==
 *	46:	wai_sem(SEM3)						... (G-5)
 *	== TASK1ij==
 *	47:	sig_sem(SEM3)						... (B-1)
 *	== TASK2ij==
 *	48:	wai_sem(SEM1)
 *		wai_sem(SEM1) -> E_RLWAI
 *	== TASK1ij==
 *	49:	sig_sem(SEM3)						... (B-4)
 *	50:	tslp_tsk(10) -> E_TMOUT
 *	== TASK4ij==
 *	51:	ext_tsk() -> noreturn
 *	== TASK1ij==
 *	52:	sig_sem(SEM3)						... (B-4)
 *	53:	tslp_tsk(10) -> E_TMOUT
 *	== TASK5ij==
 *	54:	ext_tsk() -> noreturn
 *	== TASK1ij==
 *	55:	sig_sem(SEM3)						... (B-4)
 *	56:	tslp_tsk(10) -> E_TMOUT
 *	== TASK3ij==
 *	57:	ext_tsk() -> noreturn
 *	== TASK1ij==
 *	58: rel_wai(TASK2)						... (H)
 *	== TASK2ij==
 *	59:	wai_sem(SEM1) -> E_DLT
 *	== TASK1ij==
 *	60: ini_sem(SEM1)						... (I)
 *	== TASK2ij==
 *	61: ext_tsk() -> noreturn
 *	== TASK1ij==
 *	62: END
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_sem1.h"

void
alarm1_handler(intptr_t exinf)
{
	ER		ercd;

	check_point(9);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_CTX);

	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_CTX);

	check_point(10);
	ercd = iwup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(11);
	return;

	check_point(0);
}

void
task1(intptr_t exinf)
{
	ER		ercd;
	T_RSEM	rsem;

	check_point(1);
	ercd = ref_sem(SEM1, &rsem);
	check_ercd(ercd, E_OK);
	check_assert(rsem.wtskid == TSK_NONE);
	check_assert(rsem.semcnt == 1);

	ercd = ref_sem(SEM2, &rsem);
	check_ercd(ercd, E_OK);
	check_assert(rsem.wtskid == TSK_NONE);
	check_assert(rsem.semcnt == 2);

	ercd = ref_sem(SEM3, &rsem);
	check_ercd(ercd, E_OK);
	check_assert(rsem.wtskid == TSK_NONE);
	check_assert(rsem.semcnt == 0);

	check_point(2);
	ercd = loc_cpu();
	check_ercd(ercd, E_OK);

	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_CTX);

	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_CTX);

	ercd = unl_cpu();
	check_ercd(ercd, E_OK);

	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_CTX);

	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	ercd = chg_ipm(TMAX_INTPRI);
	check_ercd(ercd, E_OK);

	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_CTX);

	ercd = chg_ipm(TIPM_ENAALL);
	check_ercd(ercd, E_OK);

	ercd = sig_sem(0);
	check_ercd(ercd, E_ID);

	ercd = wai_sem(0);
	check_ercd(ercd, E_ID);

	ercd = sig_sem(TNUM_SEMID+1);
	check_ercd(ercd, E_ID);

	ercd = wai_sem(TNUM_SEMID+1);
	check_ercd(ercd, E_ID);

	check_point(3);
	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(4);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(12);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(14);
	ercd = ref_sem(SEM1, &rsem);
	check_ercd(ercd, E_OK);
	check_assert(rsem.wtskid == TASK3);
	check_assert(rsem.semcnt == 0);

	check_point(15);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(16);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(18);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(19);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(20);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(22);
	ercd = sus_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(23);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(24);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(25);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_QOVR);

	check_point(26);
	ercd = ref_sem(SEM1, &rsem);
	check_ercd(ercd, E_OK);
	check_assert(rsem.wtskid == TSK_NONE);
	check_assert(rsem.semcnt == 1);

	check_point(27);
	ercd = rsm_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(32);
	ercd = sig_sem(SEM2);
	check_ercd(ercd, E_OK);

	check_point(34);
	ercd = sig_sem(SEM2);
	check_ercd(ercd, E_OK);

	check_point(35);
	ercd = sig_sem(SEM2);
	check_ercd(ercd, E_OK);

	check_point(36);
	ercd = ref_sem(SEM2, &rsem);
	check_ercd(ercd, E_OK);
	check_assert(rsem.wtskid == TSK_NONE);
	check_assert(rsem.semcnt == 2);

	check_point(37);
	ercd = sig_sem(SEM2);
	check_ercd(ercd, E_QOVR);

	check_point(38);
	ercd = ref_sem(SEM2, &rsem);
	check_ercd(ercd, E_OK);
	check_assert(rsem.wtskid == TSK_NONE);
	check_assert(rsem.semcnt == 2);

	check_point(39);

	check_point(40);
	ercd = tslp_tsk(10);
	check_ercd(ercd, E_TMOUT);

	check_point(42);
	ercd = act_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(43);
	ercd = act_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(44);
	ercd = rot_rdq(TPRI_SELF);
	check_ercd(ercd, E_OK);

	check_point(47);
	ercd = sig_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(49);
	ercd = sig_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(50);
	ercd = tslp_tsk(10);
	check_ercd(ercd, E_TMOUT);

	check_point(52);
	ercd = sig_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(53);
	ercd = tslp_tsk(10);
	check_ercd(ercd, E_TMOUT);

	check_point(55);
	ercd = sig_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(56);
	ercd = tslp_tsk(10);
	check_ercd(ercd, E_TMOUT);

	check_point(58);
	ercd = rel_wai(TASK2);
	check_ercd(ercd, E_OK);

	check_point(60);
	ercd = ini_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_finish(62);

	check_point(0);
}

void
task2(intptr_t exinf)
{
	ER		ercd;
	T_RSEM	rsem;

	check_point(13);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(17);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(21);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(28);
	ercd = wai_sem(SEM2);
	check_ercd(ercd, E_OK);

	check_point(29);
	ercd = ref_sem(SEM2, &rsem);
	check_ercd(ercd, E_OK);
	check_assert(rsem.wtskid == TSK_NONE);
	check_assert(rsem.semcnt == 1);

	check_point(30);
	ercd = wai_sem(SEM2);
	check_ercd(ercd, E_OK);

	check_point(31);
	ercd = wai_sem(SEM2);
	check_ercd(ercd, E_OK);

	check_point(33);
	ercd = wai_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(48);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_OK);

	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_RLWAI);

	check_point(59);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_DLT);

	check_point(61);
	ercd = ext_tsk();

	check_point(0);
}

void
task3(intptr_t exinf)
{
	ER		ercd;
	T_RSEM	rsem;

	check_point(5);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(6);
	ercd = ref_sem(SEM1, &rsem);
	check_ercd(ercd, E_OK);
	check_assert(rsem.wtskid == TSK_NONE);
	check_assert(rsem.semcnt == 0);

	check_point(7);
	ercd = sta_alm(ALM1, 10);
	check_ercd(ercd, E_OK);

	check_point(8);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(41);
	ercd = wai_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(57);
	ercd = ext_tsk();

	check_point(0);
}

void
task4(intptr_t exinf)
{
	ER		ercd;

	check_point(45);
	ercd = wai_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(51);
	ercd = ext_tsk();

	check_point(0);
}

void
task5(intptr_t exinf)
{
	ER		ercd;

	check_point(46);
	ercd = wai_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(54);
	ercd = ext_tsk();

	check_point(0);
}
