/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2007,2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: test_cpuexc7.c 818 2008-03-18 12:56:15Z hiro $
 */

/* 
 *		CPUÕeXg(7)
 *
 * yeXg̖ړIz
 *
 *  ݗDx}XNTIPM_ENAALLCfBXpb`֎~ԁC^XNO
 *  ԂŔCPUOɂVXeԂ̃eXgD^XNOɂ
 *  胊Jo[ł邱ƂeXgD
 *
 * yeXgځz
 *
 *  CݗDx}XNTIPM_ENAALLCfBXpb`֎~ԁC^
 *  XNOԂŔCPUOɂāC
 *
 *	(A) CPUOnhsJnCPUbNtOωȂ
 *	(B) CPUOnhsJnɊݗDx}XNωȂ
 *		ICPUOnhŊݗDx}XNǂ߂Ȃ߁CeXg
 *		ȂD
 *	(C) CPUOnhsJnɃfBXpb`֎~tOωȂ
 *	(D) CPUOnhsJnɃ^XNO֎~tOωȂ
 *	(E) CPUOnh^[CPUbNtOɖ߂邱
 *	(F) CPUOnh^[ɊݗDx}XNɖ߂邱
 *	(G) CPUOnh^[ɃfBXpb`֎~tOωȂ
 *	(H) CPUOnh^[Ƀ^XNO֎~tOωȂ
 *	(I) xsns_xpnfalseԂ
 *	(J) xsns_dpntrueԂ
 *	(L) ^XNOɂ郊Jo[ł邱
 *
 * ygp\[Xz
 *
 *	TASK1: TA_ACTCDxC^XNO[`o^
 *	CPUEXC1: TA_NULL
 *
 * yeXgV[PXz
 *
 *	== TASK1iDxC1ځj==
 *	1:	Ԃ̃`FbN
 *		dis_dsp()
 *		ena_tex()
 *	2:	Ԃ̃`FbN
 *		RAISE_CPU_EXCEPTION
 *	== CPUEXC1 ==
 *	3:	Ԃ̃`FbN				... (A),(C),(D)
 *		xsns_xpn() == false			... (I)
 *		xsns_dpn() == true			... (J)
 *	4:	iras_tex(TASK1, 1U)
 *		iloc_cpu()
 *		^[
 *	== TASK1̃^XNO[` ==
 *	5:	Ԃ̃`FbN				... (E),(F),(G),(H)
 *	6:	act_tsk(TASK1)				... (L)
 *	7:	ext_tsk()					... (L)
 *	== TASK1iDxC2ځj==
 *	8:	Ԃ̃`FbN				... (L)
 *	9:	eXgI
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_cpuexc.h"

int_t	task1_count = 0;

void
task1(intptr_t exinf)
{
	ER		ercd;

	switch (++task1_count) {
	case 1:
		check_point(1);
		check_state(false, false, TIPM_ENAALL, false, false, true);
		ercd = dis_dsp();
		check_ercd(ercd, E_OK);
		ercd = ena_tex();
		check_ercd(ercd, E_OK);

		check_point(2);
		check_state(false, false, TIPM_ENAALL, true, true, false);
		RAISE_CPU_EXCEPTION;

		check_point(0);
		break;

	case 2:
		check_point(8);
		check_state(false, false, TIPM_ENAALL, false, false, true);

		check_finish(9);
		break;

	default:
		check_point(0);
		break;
	}
}

void
tex_task1(TEXPTN texptn, intptr_t exinf)
{
	ER		ercd;

	check_point(5);
	check_state(false, false, TIPM_ENAALL, true, true, true);

	check_point(6);
	ercd = act_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(7);
	ercd = ext_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task2(intptr_t exinf)
{
	check_point(0);
}

void
alarm1_handler(intptr_t exinf)
{
	check_point(0);
}

void
cpuexc_handler(void *p_excinf)
{
	ER		ercd;

	check_point(3);
	check_state_i(true, false, true, true, false);
	check_assert(xsns_xpn(p_excinf) == false);
	check_assert(xsns_dpn(p_excinf) == true);

	check_point(4);
	ercd = iras_tex(TASK1, 1U);
	check_ercd(ercd, E_OK);
	ercd = iloc_cpu();
	check_ercd(ercd, E_OK);
}
