/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: target_serial.c 888 2008-04-11 11:16:50Z hiro $
 */

/*
 *		VAI/OfoCXiSIOjhCoiDVE68K/40pj
 */

#include <kernel.h>
#include <t_syslog.h>
#include "dve68k.h"
#include "pdic/upd72001/upd72001.h"
#include "target_serial.h"

/*
 *  SIOhCȍ
 */
void
sio_initialize(intptr_t exinf)
{
	upd72001_initialize();
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
sio_opn_por(ID siopid, intptr_t exinf)
{
	SIOPCB	*p_siopcb;
	bool_t	opnflg;
	ER		ercd;

	/*
	 *  I[v|[g邩opnflgɓǂłD
	 */
	opnflg = upd72001_openflag();

	/*
	 *  foCXˑ̃I[vD
	 */
	p_siopcb = upd72001_opn_por(siopid, exinf);

	/*
	 *  VAI/Õ݂}XND
	 */
	if (!opnflg) {
		ercd = ena_int(INTNO_SIO);
		assert(ercd == E_OK);
	}
	return(p_siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
sio_cls_por(SIOPCB *p_siopcb)
{
	ER		ercd;

	/*
	 *  foCXˑ̃N[YD
	 */
	upd72001_cls_por(p_siopcb);

	/*
	 *  VAI/O݂}XND
	 */
	if (!upd72001_openflag()) {
		ercd = dis_int(INTNO_SIO);
		assert(ercd == E_OK);
	}
}

/*
 *  SIO̊݃T[rX[`
 */
void
sio_isr(intptr_t exinf)
{
	upd72001_isr();
}

/*
 *  VAI/O|[gւ̕M
 */
bool_t
sio_snd_chr(SIOPCB *siopcb, char_t c)
{
	return(upd72001_snd_chr(siopcb, c));
}

/*
 *  VAI/O|[g̕M
 */
int_t
sio_rcv_chr(SIOPCB *siopcb)
{
	return(upd72001_rcv_chr(siopcb));
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
sio_ena_cbr(SIOPCB *siopcb, uint_t cbrtn)
{
	upd72001_ena_cbr(siopcb, cbrtn);
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
sio_dis_cbr(SIOPCB *siopcb, uint_t cbrtn)
{
	upd72001_dis_cbr(siopcb, cbrtn);
}

/*
 *  VAI/O|[g̑M\R[obN
 */
void
upd72001_irdy_snd(intptr_t exinf)
{
	sio_irdy_snd(exinf);
}

/*
 *  VAI/O|[g̎MʒmR[obN
 */
void
upd72001_irdy_rcv(intptr_t exinf)
{
	sio_irdy_rcv(exinf);
}
