/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: target_config.h 887 2008-04-11 11:16:07Z hiro $
 */

/*
 *		^[QbgˑW[iDVE-68K/40pj
 *
 *  J[l̃^[Qbgˑ̃CN[ht@CDkernel_impl.h̃^[
 *  Qbgˑ̈ʒutƂȂD
 */

#ifndef TOPPERS_TARGET_CONFIG_H
#define TOPPERS_TARGET_CONFIG_H

/*
 *  ^[QbgVXẽn[hEFA̒`
 */
#include "dve68k.h"

/*
 *  g[XOɊւݒ
 */
#ifdef TOPPERS_ENABLE_TRACE
#include "logtrace/trace_config.h"
#endif /* TOPPERS_ENABLE_TRACE */

/*
 *  ASPJ[l쎞̃}bvƊ֘A`
 *
 *	00000000 - 0000ffff		ROMj^^X^u[NGAi64KBj
 *	00010000 - 000fffff		R[ḧi1MBj
 *	00100000 -				f[^̈i3MBj
 *			 - 003fffff		ftHg̔^XNReLXgp̃X^bN̈
 */

/*
 *  ftHg̔^XNReLXgp̃X^bN̈̒`
 */
#define DEFAULT_ISTKSZ		0x2000U
#define DEFAULT_ISTK		(void *)(0x00400000U - DEFAULT_ISTKSZ)

#ifndef TOPPERS_MACRO_ONLY

/*
 *  vZbTʂ̂߂̕ϐi}`vZbTΉj
 */
extern uint_t	board_id;		/* {[hID */
extern void		*board_addr;	/* [J̐擪AhX */

/*
 *  ݔԍ͈̔͂̔
 *
 *  rbgp^[߂̂eՂɂ邽߂ɁC8͌ԂɂȂĂD
 */
#define VALID_INTNO(intno)	(1U <= (intno) && (intno) <= 31U && (intno) != 8U)
#define VALID_INTNO_DISINT(intno)	VALID_INTNO(intno)
#define VALID_INTNO_CFGINT(intno)	VALID_INTNO(intno)

/*
 *  ݗv𑀍삷邽߂̃rbgp^[߂}N
 *
 *  VtgZ̒xvZbTŁCɗ]Tꍇɂ́C\
 *  `Ŏ悢낤D\ȂCݔԍ8Ԃɂ
 *  Kv͂ȂD
 */
#define DGA_INT_BITPAT(intno)	(1U << (32U - (intno)))

/*
 *  xgK^GbWgKݒł邩̔p萔
 */
#define DGA_INT_TRG_CONF	(0xe0000000U)	/* ɂݒł */
#define DGA_INT_TRG_LEVEL	(0x108f00feU)	/* xgKɌŒ */
#define DGA_INT_TRG_EDGE	(0x0e70ff00U)	/* GbWgKɌŒ */

/*
 *  ݑݒ肳Ă邩𔻕ʂ邽߂̕ϐikernel_cfg.cj
 */
extern const uint32_t	bitpat_cfgint;

/*
 *  ݗv֎~tÕZbg
 *
 *  ݑݒ肳ĂȂݗvCɑ΂Ċݗv֎~
 *  tOZbg悤Ƃꍇɂ́CfalseԂD
 */
Inline bool_t
x_disable_int(INTNO intno)
{
	uint32_t	bitpat = DGA_INT_BITPAT(intno);

	if ((bitpat_cfgint & bitpat) == 0U) {
		return(false);
	}
	dga_bit_and((void *) TADR_DGA_CSR21, ~bitpat);
	return(true);
}

#define t_disable_int(intno)	x_disable_int(intno)
#define i_disable_int(intno)	x_disable_int(intno)

/*
 *  ݗv֎~tÕNA
 *
 *  ݑݒ肳ĂȂݗvCɑ΂Ċݗv֎~
 *  tONA悤Ƃꍇɂ́CfalseԂD
 */
Inline bool_t
x_enable_int(INTNO intno)
{
	uint32_t	bitpat = DGA_INT_BITPAT(intno);

	if ((bitpat_cfgint & bitpat) == 0U) {
		return(false);
	}
	dga_bit_or((void *) TADR_DGA_CSR21, bitpat);
	return(true);
}

#define t_enable_int(intno)		x_enable_int(intno)
#define i_enable_int(intno)		x_enable_int(intno)

/*
 *  ݗṽNA
 */
Inline void
x_clear_int(INTNO intno)
{
	dga_write((void *) TADR_DGA_CSR23, DGA_INT_BITPAT(intno));
}

#define t_clear_int(intno)		x_clear_int(intno)
#define i_clear_int(intno)		x_clear_int(intno)

/*
 *  ݗṽ`FbN
 */
Inline bool_t
x_probe_int(INTNO intno)
{
	return((dga_read((void *) TADR_DGA_CSR20) & DGA_INT_BITPAT(intno)) != 0U);
}

#define t_probe_int(intno)		x_probe_int(intno)
#define i_probe_int(intno)		x_probe_int(intno)

/*
 *  ݗvC̑̐ݒ
 *
 *  DVE-68K/40IRCł́CݗvC̊ݗDxNMIw肷
 *  Ƃł߁C-7^NMIɐݒ肳邱ƂƂi^[Qbg
 *  `̊gjD
 */
extern void	x_config_int(INTNO intno, ATR intatr, PRI intpri);

/*
 *  ݃nh̓ŕKvIRC
 *
 *  GbWgK̏ꍇɂ́CݗvNADGbWgKx
 *  gKݒłꍇC݂̐ݒlɃNAĂD
 *  xgK̏ꍇNAčxȂCœKŏ
 *  Ƃ҂āCNAȂƂƂĂD
 */
Inline void
i_begin_int(INTNO intno)
{
	if ((DGA_INT_BITPAT(intno) & (DGA_INT_TRG_CONF | DGA_INT_TRG_EDGE))
																!= 0U) {
		i_clear_int(intno);
	}
}

/*
 *  ݃nh̏oŕKvIRC
 *
 *  DVE-68K/40ł͕KvIRC͂ȂD
 */
Inline void
i_end_int(INTNO intno)
{
}

#endif /* TOPPERS_MACRO_ONLY */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ^[QbgVXeˑ̏
 */
extern void	target_initialize(void);

/*
 *  ^[QbgVXȅI
 *
 *  VXeI鎞ɎgD
 */
extern void	target_exit(void) NoReturn;

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ԑ҂̂߂̒`i{SIL̃^[Qbgˑj
 */
#define SIL_DLY_TIM1	420
#define SIL_DLY_TIM2	90

/*
 *  vZbTˑW[iM68040pj
 */
#include "m68k_gcc/prc_config.h"

#endif /* TOPPERS_TARGET_CONFIG_H */
