/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: target_config.c 885 2008-04-11 11:14:50Z hiro $
 */

/*
 *		^[QbgˑW[iDVE68K/40pj
 */

#include "kernel_impl.h"
#include <sil.h>

/*
 *  vZbTʂ̂߂̕ϐi}`vZbTΉj
 */
uint_t	board_id;			/* {[hID */
void	*board_addr;		/* [J̐擪AhX */

/*
 *  ^[Qbgˑ̏
 */
void
target_initialize(void)
{
	/*
	 *  vZbTˑ̏
	 */
	prc_initialize();

	/*
	 *  vZbTʂ̂߂̕ϐ̏
	 */
	board_id = ((uint_t)(sil_rew_mem((void *) TADR_BOARD_REG0)) & 0x1fU);
	board_addr = (void *)(board_id << 24);

	/*
	 *  ݊֘Ȁ
	 *
	 *  ݑݒ肳Ă邩𔻕ʂ邽߂̕ϐD
	 *  ܂CׂĂ݂̊}XNENAC݃xNgݒ肷
	 *  D
	 */
	dga_write((void *) TADR_DGA_CSR21, 0U);
	dga_write((void *) TADR_DGA_CSR23, ~0U);
	dga_write((void *) TADR_DGA_CSR19, (TVEC_G0I << 24) | (TVEC_G1I << 16)
										| (TVEC_SWI << 8) | TVEC_SPRI);

	/*
	 *  A{[g݂̐ݒiNMIj
	 *
	 *  A{[g݂GbWgKC݃xNMIɐݒ肵C}XN
	 *  D
	 */
	x_config_int(TINTNO_ABT, TA_EDGE, TIRQ_NMI);

	/*
	 *  ̈̐ݒ
	 *
	 *  [JVMEoXł̐擪AhXƃTCYi16MBjCA
	 *  NZX󂯕t悤ɐݒ肷D܂CVMEoXgAhX
	 *  ANZX󂯕t悤ɂɐݒ肷D
	 */
	dga_write((void *) TADR_DGA_CSR4, (uint32_t) board_addr | 0x00ffU);
	dga_write((void *) TADR_DGA_CSR5, 0x0000012fU);

	/*
	 *  C^tF[XWX^iIFRj̐ݒ
	 *
	 *  C^tF[XWX^̃x[XAhXݒ肷D܂CC^
	 *  tF[XWX^0̃T[rXNGXgtONADC^tF[
	 *  XWX^3Ƀ{[hIDԍݒD
	 */
	dga_write((void *) TADR_DGA_CSR3, (board_id << 4) | 0x3U);
	dga_write((void *) TADR_DGA_IFR0, 0x80000000U);
	dga_write((void *) TADR_DGA_IFR3, board_id);

	/*
	 *  Ehr[hɐݒi}`vZbTΉj
	 */
	dga_write((void *) TADR_DGA_CSR1,
						(dga_read((void *) TADR_DGA_CSR1) & 0xffeffcffU)
									| (1U << 20) | ((board_id % 4) << 8));
}

/*
 *  ^[Qbgˑ̏I
 */
void
target_exit(void)
{
	/*
	 *  vZbTˑ̏I
	 */
	prc_terminate();

	/*
	 *  ׂĂ݂̊}XNENAD
	 */
	dga_write((void *) TADR_DGA_CSR21, 0U);
	dga_write((void *) TADR_DGA_CSR23, ~0U);

	/*
	 *  Jˑ̏I
	 */
	dve68k_exit();
}

/*
 *  VXeO̒჌xo͂̂߂̕o
 */
void
target_fput_log(char_t c)
{
	if (c == '\n') {
		dve68k_putc('\r');
	}
	dve68k_putc(c);
}

/*
 *  ݗvC̑̐ݒ
 *
 *  ASPJ[lł̗pz肵āCp[^G[̓AT[VŃ`Fb
 *  NĂDcfg_intT[rXR[݂ꍇɂ́CG[Ԃ悤
 *  ɂׂł낤D
 */
void
x_config_int(INTNO intno, ATR intatr, PRI intpri)
{
	uint32_t	bitpat = DGA_INT_BITPAT(intno);

	assert(VALID_INTNO_CFGINT(intno));
	assert(TIRQ_NMI <= intpri && intpri <= TIRQ_LEVEL1);

	/*
	 *  ݂̃}XN
	 *
	 *  ݂󂯕t܂܁CxgK^GbWgK̐ݒC
	 *  ݗDx̐ݒŝ͊댯Ȃ߁Cݑɂ炸C
	 *  U}XND
	 */
	(void) x_disable_int(intno);

	/*
	 *  xgK^GbWgK̐ݒ
	 */
	if ((bitpat & DGA_INT_TRG_CONF) != 0U) {
		/*
		 *  ɂݒłꍇ
		 */
		if ((intatr & TA_EDGE) != 0U) {
			dga_bit_or((void *) TADR_DGA_CSR18, (1U << (24 - (intno))));
			x_clear_int(intno);
		}
		else {
			dga_bit_and((void *) TADR_DGA_CSR18, ~(1U << (24 - (intno))));
		}
	}
	else if ((bitpat & DGA_INT_TRG_EDGE) != 0U) {
		/*
		 *  GbWgKɌŒ肳Ăꍇ
		 */
		assert((intatr & TA_EDGE) != 0U);
		x_clear_int(intno);
	}
	else {
		/*
		 *  xgKɌŒ肳Ăꍇ
		 */
		assert((intatr & TA_EDGE) == 0U);
	}

	/*
	 *  ݗDx̐ݒ
	 */
	dga_set_ilv((void *)(TADR_DGA_CSR24 + (intno - 1) / 8 * 4),
				(uint_t)(((32 - intno) % 8) * 4), (uint_t)(7 + intpri));

	/*
	 *  ݂̃}XNiKvȏꍇj
 	 */
	if ((intatr & TA_ENAINT) != 0U) {
		(void) x_enable_int(intno);
	}
}
