/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */


/*
 *   M16C UARTp ȈSIOhCo
 */

#include <sil.h>
#include <kernel.h>
#include <t_syslog.h>
#include "target_syssvc.h"
#include "m16c_uart.h"

/* M䃌WX^0 */
#define CRS			UINT_C(0x04)
#define TXEPT		UINT_C(0x08)
#define CRD			UINT_C(0x10)
#define NCH			UINT_C(0x20)
#define CKPOL		UINT_C(0x40)
#define UFORM		UINT_C(0x80)

/* M䃌WX^1 */

#define TE			UINT_C(0x01)
#define TI			UINT_C(0x02)
#define RE			UINT_C(0x04)
#define RI			UINT_C(0x08)
#define IRS			UINT_C(0x10)
#define RRM			UINT_C(0x20)
#define LCH			UINT_C(0x40)
#define SCLKSTPB	UINT_C(0x80)

/* M[hWX^ */
#define NO_USE		UINT_C(0x00)
#define SYNC		UINT_C(0x01)
#define IIC			UINT_C(0x10)
#define ASYNC_7BIT	UINT_C(0x04)
#define ASYNC_8BIT	UINT_C(0x05)
#define ASYNC_9BIT	UINT_C(0x06)
#define CKDIR		UINT_C(0x08)
#define STPS		UINT_C(0x10)
#define ODDEVEN		UINT_C(0x20)
#define PARITY		UINT_C(0x40)
#define IOPOL		UINT_C(0x80)

/* UARTMobt@ */
#define RXDATA		UINT_C(0x00ff)
#define ABT			UINT_C(0x0400)
#define OER			UINT_C(0x1000)
#define FER			UINT_C(0x2000)
#define PER			UINT_C(0x4000)
#define SUM			UINT_C(0x8000)

/*
 *  VAI/O|[gubN̒`
 */
typedef struct sio_port_initialization_block {
	volatile uint8_t	*ctlreg0 , *ctlreg1;	/* M䃌WX^0,1 */
	volatile uint8_t	*modereg;				/* M[hWX^ */
	volatile uint8_t	*baudratereg;			/* ]xWX^ */
	volatile uint16_t	*txbufreg;				/* Mobt@ */
	volatile uint16_t	*rxbufreg;				/* Mobt@ */
	uint8_t		tx_intno;						/* M荞ݔԍ */
	uint8_t		rx_intno;						/* M荞ݔԍ */
} SIOPINIB;

/*
 *  VAI/O|[gǗubN̒`
 */
struct sio_port_control_block {
	const SIOPINIB	*p_siopinib; 				/* VAI/O|[gubN */
	intptr_t 	exinf;			 				/* g */
	bool_t		openflag;						/* I[vς݃tO */
	bool_t		sendflag;						/* M݃Cl[utO */
	bool_t		getready;						/* M */
	bool_t		putready;						/* 𑗐Mł */
	bool_t		is_initialized; 				/* foCXς݃tO */
};

/*
 *  VAI/O|[gǗubÑGA
 */
static SIOPCB	siopcb_table[TNUM_SIOP];

/* WX^e[u */
static const SIOPINIB siopinib_table[TNUM_SIOP] =
{
	{
		(volatile uint8_t *)UART0_UC0_ADDR ,
		(volatile uint8_t *)UART0_UC1_ADDR ,
		(volatile uint8_t *)UART0_MODE_ADDR ,
		(volatile uint8_t *)UART0_BAUD_ADDR ,
		(volatile uint16_t *)UART0_TXBUF_ADDR ,
		(volatile uint16_t *)UART0_RXBUF_ADDR  ,
		UART0_TXINTNO ,
		UART0_RXINTNO ,
	} ,			/* UART0 */
#if TNUM_SIOP > 1
	{
		(volatile uint8_t *)UART1_UC0_ADDR ,
		(volatile uint8_t *)UART1_UC1_ADDR ,
		(volatile uint8_t *)UART1_MODE_ADDR ,
		(volatile uint8_t *)UART1_BAUD_ADDR ,
		(volatile uint16_t *)UART1_TXBUF_ADDR ,
		(volatile uint16_t *)UART1_RXBUF_ADDR ,
		UART1_TXINTNO ,
		UART1_RXINTNO	,
	} ,			/* UART1 */
#endif
#if TNUM_SIOP > 2
	{
		(volatile uint8_t *)UART2_UC0_ADDR ,
		(volatile uint8_t *)UART2_UC1_ADDR ,
		(volatile uint8_t *)UART2_MODE_ADDR ,
		(volatile uint8_t *)UART2_BAUD_ADDR ,
		(volatile uint16_t *)UART2_TXBUF_ADDR ,
		(volatile uint16_t *)UART2_RXBUF_ADDR ,
		UART2_TXINTNO , 
		UART2_RXINTNO	,
	} ,			/* UART2 */
#endif
#if TNUM_SIOP > 3
	{
		(volatile uint8_t *)UART3_UC0_ADDR ,
		(volatile uint8_t *)UART3_UC1_ADDR ,
		(volatile uint8_t *)UART3_MODE_ADDR ,
		(volatile uint8_t *)UART3_BAUD_ADDR ,
		(volatile uint16_t *)UART3_TXBUF_ADDR ,
		(volatile uint16_t *)UART3_RXBUF_ADDR  ,
		UART3_TXINTNO ,
		UART3_RXINTNO	,
	} ,			/* UART3 */
#endif
#if TNUM_SIOP > 4
	{
		(volatile uint8_t *)UART4_UC0_ADDR ,
		(volatile uint8_t *)UART4_UC1_ADDR ,
		(volatile uint8_t *)UART4_MODE_ADDR ,
		(volatile uint8_t *)UART4_BAUD_ADDR ,
		(volatile uint16_t *)UART4_TXBUF_ADDR ,
		(volatile uint16_t *)UART4_RXBUF_ADDR ,
		UART4_TXINTNO ,
		UART4_RXINTNO	,
	  } 			/* UART4 */
#endif
};

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	 ((uint_t)((siopid) - 1))
#define get_siopcb(siopid)	 (&(siopcb_table[INDEX_SIOP(siopid)]))
#define get_siopinib(siopid) (&(siopinib_table[INDEX_SIOP(siopid)]))


static void m16c_uart_setmode(const SIOPINIB *p_siopinib , uint8_t baud , uint8_t clksrc)
{
	/* M֎~ */
	sil_wrb_mem(p_siopinib->ctlreg1 , 0x00U);
	
	/* [hWX^AMWX^0A1̏ */
	sil_wrb_mem(p_siopinib->modereg , ASYNC_8BIT);
	sil_wrb_mem(p_siopinib->ctlreg0 , clksrc | CRD);
	sil_wrb_mem(p_siopinib->ctlreg1 , (TE | RE));
	
	/* {[[gݒ */
	sil_wrb_mem(p_siopinib->baudratereg , baud);
}

/*
 *  SIOhCȍ[`
 */
void m16c_uart_initialize(void)
{
	SIOPCB	*p_siopcb;
	uint_t	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (p_siopcb = siopcb_table, i = 0; i < TNUM_SIOP; p_siopcb++, i++)
	{
		p_siopcb->p_siopinib = &(siopinib_table[i]);
		p_siopcb->openflag = false;
		p_siopcb->sendflag = false;
	}
}

/*
 * J[lÑoi[o͗p̏
 */
void m16c_uart_init(ID siopid , uint8_t baud , uint8_t clksrc)
{
	SIOPCB          *p_siopcb   = get_siopcb(siopid);
	const SIOPINIB  *p_siopinib = get_siopinib(siopid);
	/*  ̎_ł́Ap_siopcb->p_siopinib͏ĂȂ  */
	
	/*  d̖h~  */
	p_siopcb->is_initialized = true;
	
	/*  n[hEFȀƑM  */
	m16c_uart_setmode(p_siopinib , baud , clksrc);
	sil_wrb_mem(p_siopinib->ctlreg1 , (sil_reb_mem(p_siopinib->ctlreg1) | TE));
}

/*
 *  VAI/O|[gւ̃|[Oł̏o
 */
void m16c_uart_pol_putc(char c, ID siopid)
{
	const SIOPINIB *p_siopinib;
	
	p_siopinib = get_siopinib(siopid);
#ifdef SIOHARD	
	while((sil_reb_mem(p_siopinib->ctlreg1) & TI) == 0)
		;
#endif
	sil_wrh_mem(p_siopinib->txbufreg , (uint16_t)c);
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *m16c_uart_opn_por
	(ID siopid, intptr_t exinf , uint8_t baud , uint8_t clksrc)
{
	SIOPCB          *p_siopcb;
	const SIOPINIB  *p_siopinib;
	
	p_siopcb = get_siopcb(siopid);
	p_siopinib = p_siopcb->p_siopinib;
	
	/*
	*  n[hEFȀ     
	*  ɏĂꍇ́AdɏȂB
	*/
	if (!(p_siopcb->is_initialized))
	{
		m16c_uart_setmode(p_siopinib , baud , clksrc);
		p_siopcb->is_initialized = true;
	}
	
	p_siopcb->exinf = exinf;
	p_siopcb->getready = p_siopcb->putready = false;
	p_siopcb->openflag = true;
	
    return(p_siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void m16c_uart_cls_por(SIOPCB *p_siopcb)
{
	/*
	 * UART~
	 */
	sil_wrh_mem(p_siopcb->p_siopinib->ctlreg1, 0x00U);
	p_siopcb->openflag = false;
	p_siopcb->is_initialized = false;
}

/*
 *  VAI/O|[gւ̕M
 */
bool_t m16c_uart_snd_chr(SIOPCB *p_siopcb, char_t c)
{
	bool_t ercd = false;
	
	if ((sil_reb_mem(p_siopcb->p_siopinib->ctlreg1) & TI) != 0)
	{
		sil_wrh_mem(p_siopcb->p_siopinib->txbufreg , (uint16_t)c);
		ercd = true;
	}
	return ercd;
}

/*
 *  VAI/O|[g̕M
 */
int_t m16c_uart_rcv_chr(SIOPCB *p_siopcb)
{
	int_t c = -1;
	
	if ((sil_reb_mem(p_siopcb->p_siopinib->ctlreg1) & RI) != 0)
	{
		c = (int)(sil_reh_mem(p_siopcb->p_siopinib->rxbufreg) & RXDATA);
	}
	return c;
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void  m16c_uart_ena_cbr(SIOPCB *p_siopcb, uint_t cbrtn)
{
	switch (cbrtn) {
		case SIO_RDY_SND:
			ena_int(p_siopcb->p_siopinib->tx_intno);
			break;
		case SIO_RDY_RCV:
			ena_int(p_siopcb->p_siopinib->rx_intno);
			break;
		default:
			assert(1);
			break;
	}
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void m16c_uart_dis_cbr(SIOPCB *p_siopcb, uint_t cbrtn)
{
	switch (cbrtn) {
		case SIO_RDY_SND:
			dis_int(p_siopcb->p_siopinib->tx_intno);
			break;
		case SIO_RDY_RCV:
			dis_int(p_siopcb->p_siopinib->rx_intno);
			break;
		default:
			assert(1);
			break;
	}
}

/*
 *  SIO̊݃T[rX[`
 */
void m16c_uart_tx_isr(ID siopid)
{
	SIOPCB	*p_siopcb = get_siopcb(siopid);

	if ((sil_reb_mem(p_siopcb->p_siopinib->ctlreg1) & TI) != 0U)
	{
		/*
		 *  M\R[obN[`ĂяoD
		 */
		m16c_uart_irdy_snd(p_siopcb->exinf);
	}
}

void m16c_uart_rx_isr(ID siopid)
{
	SIOPCB	*p_siopcb = get_siopcb(siopid);

	if ((sil_reb_mem(p_siopcb->p_siopinib->ctlreg1) & RI) != 0U)
	{
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		m16c_uart_irdy_rcv(p_siopcb->exinf);
	}
}

