/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

#include <sil.h>
#include "target_syssvc.h"
#include "m16c/m16c_ta.h"

/* ^C}WX^ */
typedef struct _M16C_TIMERREG
{
	volatile uint8_t	*mode;				/* ^C}[hWX^ */
	volatile uint16_t	*counter;			/* JE^WX^ */
	volatile uint8_t	*start;				/* JEgJnWX^ */
	volatile uint8_t	*updown;			/* AbvJEg/_EJEgIWX^ */
	volatile uint8_t	*oneshot;			/* VbgJnWX^ */
	volatile uint8_t	*trigsel;			/* gKIWX^ */
	uint8_t				bitmsk;				/* X^[gWX^p̃rbg}XN */
	uint8_t				trig_bitmask;		/* gKIWX^p̃rbgʒuItZbg */
	uint8_t				intno;				/* 荞ݗvԍ */
} M16C_TIMERREG;                    

/* WX^e[u */
static M16C_TIMERREG const timerreg_table[TNUM_M16C_TA] =
{
	/* ^C}A0 */
	{
		(volatile uint8_t *)TA0MR_ADDR ,		/* ^C}[hWX^ */
		(volatile uint16_t *)TA0_ADDR ,	/* JE^WX^ */
		(volatile uint8_t *)TABSR_ADDR ,	/* JEgJnWX^ */
		(volatile uint8_t *)UDF_ADDR ,		/* AbvJEg/_EJEgIWX^ */
		(volatile uint8_t *)ONSF_ADDR ,		/* VbgJnWX^ */
		(volatile uint8_t *)ONSF_ADDR ,		/* gKIWX^ */
		TA0_START_BIT ,						/* JEgJnWX^prbg}XN */
		TA0_TRIGSEL_OFFSET ,					/* gKIWX^p̃rbgʒuItZbg */
		(INT_TA0) ,							/* 荞ݗvԍ */
	} ,
#if	TNUM_M16C_TA > 2
	/* ^C}A1 */
	{
		(volatile uint8_t *)TA1MR_ADDR ,		/* ^C}[hWX^ */
		(volatile uint16_t *)TA1_ADDR ,	/* JE^WX^ */
		(volatile uint8_t *)TABSR_ADDR ,	/* JEgJnWX^ */
		(volatile uint8_t *)UDF_ADDR ,		/* AbvJEg/_EJEgIWX^ */
		(volatile uint8_t *)ONSF_ADDR ,		/* VbgJnWX^ */
		(volatile uint8_t *)TAGSR_ADDR ,	/* gKIWX^ */
		TA1_START_BIT ,						/* WX^p̃rbg}XN */
		TA1_TRIGSEL_OFFSET ,				/* gKIWX^p̃rbgʒuItZbg */
		(INT_TA1) ,							/* 荞ݗvԍ */
	} ,
#endif
#if	TNUM_M16C_TA > 3
	/* ^C}A2 */
	{
		(volatile uint8_t *)TA2MR_ADDR ,		/* ^C}[hWX^ */
		(volatile uint16_t *)TA2_ADDR ,	/* JE^WX^ */
		(volatile uint8_t *)TABSR_ADDR ,	/* JEgJnWX^ */
		(volatile uint8_t *)UDF_ADDR ,		/* AbvJEg/_EJEgIWX^ */
		(volatile uint8_t *)ONSF_ADDR ,		/* VbgJnWX^ */
		(volatile uint8_t *)TAGSR_ADDR ,	/* gKIWX^ */
		TA2_START_BIT ,						/* WX^p̃rbg}XN */
		TA2_TRIGSEL_OFFSET ,				/* gKIWX^p̃rbgʒuItZbg */
		(INT_TA2) ,							/* 荞ݗvԍ */
	} ,
#endif
#if	TNUM_M16C_TA > 4
	/* ^C}A3 */
	{
		(volatile uint8_t *)TA3MR_ADDR ,		/* ^C}[hWX^ */
		(volatile uint16_t *)TA3_ADDR ,	/* JE^WX^ */
		(volatile uint8_t *)TABSR_ADDR ,	/* JEgJnWX^ */
		(volatile uint8_t *)UDF_ADDR ,		/* AbvJEg/_EJEgIWX^ */
		(volatile uint8_t *)ONSF_ADDR ,		/* VbgJnWX^ */
		(volatile uint8_t *)TAGSR_ADDR ,	/* gKIWX^ */
		TA3_START_BIT ,						/* WX^p̃rbg}XN */
		TA3_TRIGSEL_OFFSET ,				/* gKIWX^p̃rbgʒuItZbg */
		(INT_TA3) ,							/* 荞ݗvԍ */
	} ,
#endif
#if	TNUM_M16C_TA > 5
	/* ^C}A4 */
	{
		(volatile uint8_t *)TA4MR_ADDR ,		/* ^C}[hWX^ */
		(volatile uint16_t *)TA4_ADDR ,	/* JE^WX^ */
		(volatile uint8_t *)TABSR_ADDR ,	/* JEgJnWX^ */
		(volatile uint8_t *)UDF_ADDR ,		/* AbvJEg/_EJEgIWX^ */
		(volatile uint8_t *)ONSF_ADDR ,		/* VbgJnWX^ */
		(volatile uint8_t *)TAGSR_ADDR ,	/* gKIWX^ */
		TA4_START_BIT ,						/* WX^p̃rbg}XN */
		TA4_TRIGSEL_OFFSET ,				/* gKIWX^p̃rbgʒuItZbg */
		(INT_TA3) ,							/* 荞ݗvԍ */
	} ,
#endif
};

/*
 *  WX^̎擾
 */
#define get_timerreg(ch)	(&(timerreg_table[(ch)]))

/*
 *  ^C}AhCȍ
 */
void m16c_ta_initialize(void)
{
	const M16C_TIMERREG *tmreg;
	uint8_t i;
	
	for(i = 0 ; i < TNUM_M16C_TA ; i++)
	{
		tmreg = get_timerreg(i);
		/* ^C}~ */
		*(tmreg->start) &= ~(tmreg->bitmsk);
	}
	
}

/*
 *  ^C}AhCȍI
 */
void m16c_ta_terminate(void)
{
	const M16C_TIMERREG *tmreg;
	uint8_t i;
	
	for(i = 0 ; i < TNUM_M16C_TA ; i++)
	{
		tmreg = get_timerreg(i);
		/* ^C}~ */
		*(tmreg->start) &= ~(tmreg->bitmsk);
	}
}

/*
 *  [hݒ
 */
void m16c_ta_setmode(ID ch , uint8_t mode , uint8_t clksrc , uint8_t opt)
{
	const M16C_TIMERREG *tmreg = get_timerreg(ch);
	
	/* [hWX^ւ̐ݒ */
	sil_wrb_mem(tmreg->mode , mode | (clksrc << 6U) | (opt << 3U));
}

/*
 *  ̊Jn
 */
void m16c_ta_start(ID ch , uint16_t period)
{
	const M16C_TIMERREG *tmreg = get_timerreg(ch);
	
	/* ݒ */
	sil_wrh_mem(tmreg->counter , period);
	/* ^C}X^[g */
	sil_wrb_mem(tmreg->start , 
		(sil_reb_mem(tmreg->start) | tmreg->bitmsk));
}

/*
 *  ̒~
 */
void m16c_ta_stop(ID ch)
{
	const M16C_TIMERREG *tmreg = get_timerreg(ch);
	
	/* ^C}Xgbv */
	*(tmreg->start) &= ~(tmreg->bitmsk);
}

/*
 *  ^C}WX^l̓ǂݏo
 */
uint16_t m16c_ta_getcount(ID ch)
{
	const M16C_TIMERREG *tmreg = get_timerreg(ch);
	
	return sil_reh_mem(tmreg->counter);
}

/*
 *  ^C}WX^l̏
 */
void m16c_ta_setcount(ID ch , uint16_t count)
{
	const M16C_TIMERREG *tmreg = get_timerreg(ch);
	
	sil_wrh_mem(tmreg->counter , count);
}

