/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: prc_insn.h 591 2007-11-12 02:39:38Z asp $
 */

/*
 *		vZbT̓ꖽ߂̃CC֐`iM68040pj
 */

#ifndef	TOPPERS_PRC_INSN_H
#define	TOPPERS_PRC_INSN_H

/*
 *  Xe[^XWX^iSRǰݒl̓Ǐo
 */
Inline uint16_t
current_sr(void)
{
	uint16_t	sr;

	Asm("move.w %%sr, %0" : "=g"(sr));
	return(sr);
}

/*
 *  Xe[^XWX^iSRǰݒl̐ݒ
 */
Inline void
set_sr(uint16_t sr)
{
	Asm("move.w %0, %%sr" : : "g"(sr) : "cc");
}

/*
 *  NMIׂĂ݂̊̋֎~
 *
 *  set_srpĎ邱Ƃł邪Cʂ̖߂pĎ
 *  ǂ߂ɗpӂĂD
 */
Inline void
disint(void)
{
	Asm("or.w #0x0700, %sr");
}

/*
 *  ׂĂ݂̊̋
 *
 *  set_srpĎ邱Ƃł邪Cʂ̖߂pĎ
 *  ǂ߂ɗpӂĂD
 */
Inline void
enaint(void)
{
	Asm("and.w #~0x0700, %sr");
}

/*
 *  xN^x[XWX^iVBRǰݒl̓Ǐo
 */
Inline void
*current_vbr(void)
{
	void	*vbr;

	Asm("movec.l %%vbr, %0" : "=r"(vbr));
	return(vbr);
}

/*
 *  xN^x[XWX^iVBRǰݒl̐ݒ
 */
Inline void
set_vbr(void *vbr)
{
	Asm("movec.l %0, %%vbr" : : "r"(vbr));
}

/*
 *  fBL[T[`̂߂̃rbg}bvT[`֐
 *
 *  bfffo߂͍ŏʃrbgT[`邽߁CŏʃrbgōDx
 *  ɑΉD
 */
#define	OMIT_BITMAP_SEARCH
#define	PRIMAP_BIT(pri)		(0x8000U >> (pri))

Inline uint_t
bitmap_search(uint16_t bitmap)
{
	uint32_t	offset;

	Asm("bfffo %1{16,16}, %0" : "=d"(offset) : "d"((uint32_t) bitmap));
	return((uint_t)(offset - 16));
}

#endif /* TOPPERS_PRC_INSN_H */
