/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.uifontchanger;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;

public class L10n {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(L10n.class.getPackage().getName() + ".Bundle");

    public static String get(Key key) {
        if (key == Key.UI_DEFAULT_FONT) {
            return L10n.getUIDefaultFontName();
        }
        return bundle.getString(key.name());
    }

    private static String getUIDefaultFontName() {
        String[] splitted;
        String fontName;
        List<String> availableFonts = Arrays.asList(StaticUtils.getFontNames());
        switch (Platform.getOsType()) {
            case MAC32: 
            case MAC64: {
                fontName = bundle.getString("UI_DEFAULT_FONT_MAC");
                break;
            }
            case WIN32: 
            case WIN64: {
                fontName = bundle.getString("UI_DEFAULT_FONT_WIN");
                break;
            }
            default: {
                fontName = bundle.getString("UI_DEFAULT_FONT_OTH");
            }
        }
        String src = fontName;
        for (String s : splitted = fontName.split("\\s*,\\s*")) {
            if (s.trim().isEmpty() || !availableFonts.contains(s)) continue;
            return s;
        }
        return null;
    }

    public static enum Key {
        UI_DEFAULT_FONT;

    }
}

