/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.uifontchanger;

import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jp.sourceforge.users.yutang.omegat.plugin.uifontchanger.L10n;
import org.omegat.util.FileUtil;
import org.omegat.util.StaticUtils;

public class Config {
    static final String FILE_NAME = "uifontchanger.conf";
    private final File file;
    private ConfigObject config = null;

    public Config(File file) throws IOException {
        this.file = file;
        if (file.isFile()) {
            String script = FileUtil.readTextFile((File)file);
            script = this.getSafeScript(script);
            this.config = this.createBindedConfigSlurper().parse(script);
        } else {
            this.config = Config.getDefaultConfig();
        }
    }

    private ConfigSlurper createBindedConfigSlurper() {
        ConfigSlurper configSlurper = new ConfigSlurper();
        return configSlurper;
    }

    public Object get(String key) {
        Map flatten;
        if (this.config != null && (flatten = this.config.flatten()).containsKey(key)) {
            return flatten.get(key);
        }
        return null;
    }

    public boolean get(String key, boolean defaultValue) {
        Object ret = this.get(key);
        return ret != null ? (Boolean)ret : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.file));
            this.config.writeTo(writer);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static ConfigObject getDefaultConfig() {
        ConfigObject conf = new ConfigObject();
        String defaultFontName = L10n.get(L10n.Key.UI_DEFAULT_FONT);
        if (defaultFontName != null) {
            conf.put((Object)"*", (Object)defaultFontName);
        }
        return conf;
    }

    public static File getPrimaryConfigFile() {
        File configPluginsDir = new File(StaticUtils.getConfigDir(), "plugins");
        List fs = FileUtil.findFiles((File)configPluginsDir, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().equalsIgnoreCase(Config.FILE_NAME);
            }
        });
        if (fs.isEmpty()) {
            return new File(configPluginsDir, FILE_NAME);
        }
        return (File)fs.get(0);
    }

    public static File getSecondaryConfigFile() {
        File installPluginsDir = new File(StaticUtils.installDir(), "plugins");
        List fs = FileUtil.findFiles((File)installPluginsDir, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().equalsIgnoreCase(Config.FILE_NAME);
            }
        });
        if (fs.isEmpty()) {
            return new File(installPluginsDir, FILE_NAME);
        }
        return (File)fs.get(0);
    }

    public static File getConfigFile() {
        File primaryConfigFile = Config.getPrimaryConfigFile();
        if (primaryConfigFile.isFile()) {
            return primaryConfigFile;
        }
        File secondaryConfigFile = Config.getSecondaryConfigFile();
        if (secondaryConfigFile.isFile()) {
            return secondaryConfigFile;
        }
        return primaryConfigFile;
    }

    private String getSafeScript(String script) {
        String RE_IMPLICIT_LIST_VARIANT = "(?m)^\\s*List(?=\\.font\\s*=)";
        String RE_EXPLICIT_LIST_VARIANT = "this\\.'List'";
        String RE_IMPLICIT_UNIVERSAL_VARIANT = "(?m)^\\s*\\*(?=\\s*=)";
        String RE_EXPLICIT_UNIVERSAL_VARIANT = "this\\.'\\*'";
        Pattern PATTERN_FONT_IMPORT_DECLARATION = Pattern.compile("^import\\s+java\\.awt\\.Font;", 8);
        String ret = script;
        ret = ret.replaceAll("(?m)^\\s*List(?=\\.font\\s*=)", "this\\.'List'");
        ret = ret.replaceAll("(?m)^\\s*\\*(?=\\s*=)", "this\\.'\\*'");
        if (!PATTERN_FONT_IMPORT_DECLARATION.matcher(script).find()) {
            ret = "import java.awt.Font;" + ret;
        }
        return ret;
    }
}

