set TCLDIR=..\..\..\..\tcl8.5.11
set TKDIR=..\..\..\..\tk8.5.11
set VCVERSION=VC9
set INCLUDEOPT=-I . -I ..\..\src -I %TCLDIR%\generic -I %TKDIR%\generic -I %TKDIR%\xlib
set PACKAGE_NAME=Tkhtml
set PACKAGE_NAME_LETTER=tkhtml
set PACKAGE_VERSION=3.0

if %1==Release goto release
if %1==Debug goto debug

:release
set OPT=-O2
set CONFIGURATION=Release
set DLLSURFIX=t
set SLIBSURFIX=ts
goto bitmode

:debug
set OPT=-ZI
set CONFIGURATION=Debug
set DLLSURFIX=tg
set SLIBSURFIX=tsg

:bitmode
if %2==x86 goto x86
if %2==x64 goto x64

:x86
set OUTDIR=%CONFIGURATION%_%VCVERSION%
set INSTALLDIR=..\..\..\..\inst_x86
goto build

:x64
set OUTDIR=%CONFIGURATION%_AMD64_%VCVERSION%
set INSTALLDIR=..\..\..\..\inst_x64


:build
set TCLLIBNAME=tcl85%DLLSURFIX%.lib tclstub85.lib
set TKLIBNAME=tk85%DLLSURFIX%.lib

mkdir %OUTDIR%
cd %OUTDIR%

%INSTALLDIR%\bin\tclsh85%DLLSURFIX%.exe ..\..\src\cssprop.tcl
%INSTALLDIR%\bin\tclsh85%DLLSURFIX%.exe ..\..\src\tkhtml.tcl
%INSTALLDIR%\bin\tclsh85%DLLSURFIX%.exe ..\..\src\tokenlist.txt
%INSTALLDIR%\bin\tclsh85%DLLSURFIX%.exe ..\..\src\mkdefaultstyle.tcl > htmldefaultstyle.c
cl ..\..\tools\lemon.c
copy ..\..\tools\lempar.c .
lemon ..\..\src\cssparse.lem
del ..\..\tools\lemon.obj

set SOURCES= ^
	..\..\src\css.c ^
	..\..\src\cssdynamic.c ^
	..\..\src\cssparse.c ^
	..\..\src\csssearch.c ^
	..\..\src\htmldecode.c ^
	..\..\src\htmldraw.c ^
	..\..\src\htmlfloat.c ^
	..\..\src\htmlhash.c ^
	..\..\src\htmlimage.c ^
	..\..\src\htmlinline.c ^
	..\..\src\htmllayout.c ^
	..\..\src\htmlparse.c ^
	..\..\src\htmlprop.c ^
	..\..\src\htmlstyle.c ^
	..\..\src\htmltable.c ^
	..\..\src\htmltagdb.c ^
	..\..\src\htmltcl.c ^
	..\..\src\htmltext.c ^
	..\..\src\htmltree.c ^
	..\..\src\htmlutil.c ^
	..\..\src\restrack.c ^
	..\..\src\swproc.c ^
	.\cssprop.c


rem threads,static
cl -MT %OPT% -DSTATIC_BUILD -c %INCLUDEOPT% %SOURCES%
lib -OUT:%PACKAGE_NAME_LETTER%%SLIBSURFIX%.lib *.obj

rem threads
cl -MT -LD %OPT% -DDLL_EXPORT=__declspec(dllexport) %INCLUDEOPT% %SOURCES% /link /OUT:%PACKAGE_NAME_LETTER%%DLLSURFIX%.dll /IMPLIB:%PACKAGE_NAME%%DLLSURFIX%.lib /LIBPATH:%TCLDIR%\win\%OUTDIR%\ /LIBPATH:%TKDIR%\win\%OUTDIR%\ %TCLLIBNAME% %TKLIBNAME%

rem install

mkdir %INSTALLDIR%\lib\%PACKAGE_NAME%%PACKAGE_VERSION%
copy %PACKAGE_NAME%%DLLSURFIX%.dll %INSTALLDIR%\lib\%PACKAGE_NAME%%PACKAGE_VERSION%
copy *.lib %INSTALLDIR%\lib
echo package ifneeded %PACKAGE_NAME% %PACKAGE_VERSION% [list load [file join $dir %PACKAGE_NAME%%DLLSURFIX%.dll] %PACKAGE_NAME%]  > %INSTALLDIR%\lib\%PACKAGE_NAME%%PACKAGE_VERSION%\pkgIndex.tcl

:end
cd ..
